/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.signatures;

import com.fr.third.fr.pdf.forms.PdfAcroForm;
import com.fr.third.fr.pdf.forms.fields.PdfFormField;
import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.source.RASInputStream;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.source.RandomAccessSourceFactory;
import com.fr.third.fr.pdf.io.source.WindowRandomAccessSource;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDate;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.signatures.PdfPKCS7;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtil {
    private PdfDocument document;
    private PdfAcroForm acroForm;
    private Map<String, int[]> sigNames;
    private List<String> orderedSignatureNames;
    private int totalRevisions;

    public SignatureUtil(PdfDocument document) {
        this.document = document;
        this.acroForm = PdfAcroForm.getAcroForm(document, true);
    }

    public PdfPKCS7 verifySignature(String name) {
        return this.verifySignature(name, null);
    }

    public PdfPKCS7 verifySignature(String name, String provider) {
        PdfDictionary v = this.getSignatureDictionary(name);
        if (v == null) {
            return null;
        }
        try {
            PdfObject obj;
            PdfName sub = v.getAsName(PdfName.SubFilter);
            PdfString contents = v.getAsString(PdfName.Contents);
            PdfPKCS7 pk = null;
            if (sub.equals(PdfName.Adbe_x509_rsa_sha1)) {
                PdfString cert = v.getAsString(PdfName.Cert);
                if (cert == null) {
                    cert = v.getAsArray(PdfName.Cert).getAsString(0);
                }
                pk = new PdfPKCS7(PdfEncodings.convertToBytes(contents.getValue(), null), cert.getValueBytes(), provider);
            } else {
                pk = new PdfPKCS7(PdfEncodings.convertToBytes(contents.getValue(), null), sub, provider);
            }
            this.updateByteRange(pk, v);
            PdfString str = v.getAsString(PdfName.M);
            if (str != null) {
                pk.setSignDate(PdfDate.decode(str.toString()));
            }
            if ((obj = v.get(PdfName.Name)) != null) {
                if (obj.isString()) {
                    pk.setSignName(((PdfString)obj).toUnicodeString());
                } else if (obj.isName()) {
                    pk.setSignName(((PdfName)obj).getValue());
                }
            }
            if ((str = v.getAsString(PdfName.Reason)) != null) {
                pk.setReason(str.toUnicodeString());
            }
            if ((str = v.getAsString(PdfName.Location)) != null) {
                pk.setLocation(str.toUnicodeString());
            }
            return pk;
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    public PdfDictionary getSignatureDictionary(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return null;
        }
        PdfFormField field = this.acroForm.getField(name);
        PdfDictionary merged = (PdfDictionary)field.getPdfObject();
        return merged.getAsDictionary(PdfName.V);
    }

    private void updateByteRange(PdfPKCS7 pkcs7, PdfDictionary v) {
        PdfArray b = v.getAsArray(PdfName.ByteRange);
        RandomAccessFileOrArray rf = this.document.getReader().getSafeFile();
        InputStream rg = null;
        try {
            int rd;
            rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), SignatureUtil.asLongArray(b)));
            byte[] buf = new byte[8192];
            while ((rd = rg.read(buf, 0, buf.length)) > 0) {
                pkcs7.update(buf, 0, rd);
            }
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
        finally {
            try {
                if (rg != null) {
                    rg.close();
                }
            }
            catch (IOException e) {
                throw new PdfException(e);
            }
        }
    }

    public List<String> getSignatureNames() {
        if (this.sigNames != null) {
            return new ArrayList<String>(this.orderedSignatureNames);
        }
        this.sigNames = new HashMap<String, int[]>();
        this.orderedSignatureNames = new ArrayList<String>();
        ArrayList<Object[]> sorter = new ArrayList<Object[]>();
        for (Map.Entry<String, PdfFormField> entry : this.acroForm.getFormFields().entrySet()) {
            int rangeSize;
            PdfArray ro;
            PdfString contents;
            PdfDictionary v;
            PdfFormField field = entry.getValue();
            PdfDictionary merged = (PdfDictionary)field.getPdfObject();
            if (!PdfName.Sig.equals(merged.get(PdfName.FT)) || (v = merged.getAsDictionary(PdfName.V)) == null || (contents = v.getAsString(PdfName.Contents)) == null || (ro = v.getAsArray(PdfName.ByteRange)) == null || (rangeSize = ro.size()) < 2) continue;
            int length = ro.getAsNumber(rangeSize - 1).intValue() + ro.getAsNumber(rangeSize - 2).intValue();
            sorter.add(new Object[]{entry.getKey(), new int[]{length, 0}});
        }
        Collections.sort(sorter, new SorterComparator());
        if (sorter.size() > 0) {
            try {
                this.totalRevisions = (long)((int[])((Object[])sorter.get(sorter.size() - 1))[1])[0] == this.document.getReader().getFileLength() ? sorter.size() : sorter.size() + 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (int k = 0; k < sorter.size(); ++k) {
                Object[] objs = (Object[])sorter.get(k);
                String name = (String)objs[0];
                int[] p = (int[])objs[1];
                p[1] = k + 1;
                this.sigNames.put(name, p);
                this.orderedSignatureNames.add(name);
            }
        }
        return new ArrayList<String>(this.orderedSignatureNames);
    }

    public List<String> getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList<String> sigs = new ArrayList<String>();
        for (Map.Entry<String, PdfFormField> entry : this.acroForm.getFormFields().entrySet()) {
            PdfFormField field = entry.getValue();
            PdfDictionary merged = (PdfDictionary)field.getPdfObject();
            if (!PdfName.Sig.equals(merged.getAsName(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            sigs.add(entry.getKey());
        }
        return sigs;
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String field) {
        this.getSignatureNames();
        field = this.getTranslatedFieldName(field);
        if (!this.sigNames.containsKey(field)) {
            return 0;
        }
        return this.sigNames.get(field)[1];
    }

    public String getTranslatedFieldName(String name) {
        String namex;
        if (this.acroForm.getXfaForm().isXfaPresent() && (namex = this.acroForm.getXfaForm().findFieldName(name)) != null) {
            name = namex;
        }
        return name;
    }

    public InputStream extractRevision(String field) throws IOException {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(field)) {
            return null;
        }
        int length = this.sigNames.get(field)[0];
        RandomAccessFileOrArray raf = this.document.getReader().getSafeFile();
        return new RASInputStream(new WindowRandomAccessSource(raf.createSourceView(), 0L, length));
    }

    public boolean signatureCoversWholeDocument(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return false;
        }
        try {
            return (long)this.sigNames.get(name)[0] == this.document.getReader().getFileLength();
        }
        catch (IOException e) {
            throw new PdfException(e);
        }
    }

    public boolean doesSignatureFieldExist(String name) {
        return this.getBlankSignatureNames().contains(name) || this.getSignatureNames().contains(name);
    }

    public static long[] asLongArray(PdfArray pdfArray) {
        long[] rslt = new long[pdfArray.size()];
        for (int k = 0; k < rslt.length; ++k) {
            rslt[k] = pdfArray.getAsNumber(k).longValue();
        }
        return rslt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SorterComparator
    implements Comparator<Object[]> {
        private SorterComparator() {
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int n1 = ((int[])o1[1])[0];
            int n2 = ((int[])o2[1])[0];
            return n1 - n2;
        }
    }
}

