/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.signatures;

import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDate;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.signatures.PdfSignatureBuildProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfSignature
extends PdfObjectWrapper<PdfDictionary> {
    public PdfSignature() {
        super(new PdfDictionary());
        this.put(PdfName.Type, PdfName.Sig);
    }

    public PdfSignature(PdfName filter, PdfName subFilter) {
        this();
        this.put(PdfName.Filter, filter);
        this.put(PdfName.SubFilter, subFilter);
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        for (int k = 0; k < range.length; ++k) {
            array.add(new PdfNumber(range[k]));
        }
        this.put(PdfName.ByteRange, array);
    }

    public void setContents(byte[] contents) {
        this.put(PdfName.Contents, new PdfString(contents).setHexWriting(true));
    }

    public void setCert(byte[] cert) {
        this.put(PdfName.Cert, new PdfString(cert));
    }

    public void setName(String name) {
        this.put(PdfName.Name, new PdfString(name, "UnicodeBig"));
    }

    public void setDate(PdfDate date) {
        this.put(PdfName.M, (PdfObject)date.getPdfObject());
    }

    public void setLocation(String location) {
        this.put(PdfName.Location, new PdfString(location, "UnicodeBig"));
    }

    public void setReason(String reason) {
        this.put(PdfName.Reason, new PdfString(reason, "UnicodeBig"));
    }

    public void setSignatureCreator(String signatureCreator) {
        if (signatureCreator != null) {
            this.getPdfSignatureBuildProperties().setSignatureCreator(signatureCreator);
        }
    }

    public void setContact(String contactInfo) {
        this.put(PdfName.ContactInfo, new PdfString(contactInfo, "UnicodeBig"));
    }

    public PdfSignature put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfSignatureBuildProperties getPdfSignatureBuildProperties() {
        PdfDictionary buildPropDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Prop_Build);
        if (buildPropDict == null) {
            buildPropDict = new PdfDictionary();
            this.put(PdfName.Prop_Build, buildPropDict);
        }
        return new PdfSignatureBuildProperties(buildPropDict);
    }
}

