/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.pdfa;

import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.log.Counter;
import com.fr.third.fr.pdf.kernel.log.CounterFactory;
import com.fr.third.fr.pdf.kernel.pdf.IsoKey;
import com.fr.third.fr.pdf.kernel.pdf.PdfAConformanceLevel;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutputIntent;
import com.fr.third.fr.pdf.kernel.pdf.PdfPage;
import com.fr.third.fr.pdf.kernel.pdf.PdfReader;
import com.fr.third.fr.pdf.kernel.pdf.PdfResources;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfVersion;
import com.fr.third.fr.pdf.kernel.pdf.PdfWriter;
import com.fr.third.fr.pdf.kernel.pdf.StampingProperties;
import com.fr.third.fr.pdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagStructureContext;
import com.fr.third.fr.pdf.kernel.xmp.XMPException;
import com.fr.third.fr.pdf.kernel.xmp.XMPMeta;
import com.fr.third.fr.pdf.kernel.xmp.XMPMetaFactory;
import com.fr.third.fr.pdf.kernel.xmp.XMPUtils;
import com.fr.third.fr.pdf.pdfa.PdfAConformanceException;
import com.fr.third.fr.pdf.pdfa.checker.PdfA1Checker;
import com.fr.third.fr.pdf.pdfa.checker.PdfA2Checker;
import com.fr.third.fr.pdf.pdfa.checker.PdfA3Checker;
import com.fr.third.fr.pdf.pdfa.checker.PdfAChecker;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PdfADocument
extends PdfDocument {
    private static final long serialVersionUID = -5908390625367471894L;
    protected PdfAChecker checker;
    private static Map<String, CheckerCreater> checkerCreaterHashMap = new HashMap<String, CheckerCreater>();
    private static Map<String, PdfVersion> pdfVersionMap;

    public PdfADocument(PdfWriter writer, PdfAConformanceLevel conformanceLevel, PdfOutputIntent outputIntent) {
        super(writer);
        this.setChecker(conformanceLevel);
        this.addOutputIntent(outputIntent);
    }

    public PdfADocument(PdfReader reader, PdfWriter writer) {
        this(reader, writer, new StampingProperties());
    }

    public PdfADocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        super(reader, writer, properties);
        XMPMeta meta;
        byte[] existingXmpMetadata = this.getXmpMetadata();
        if (existingXmpMetadata == null) {
            throw new PdfAConformanceException("document.to.read.from.shall.be.a.pdfa.conformant.file.with.valid.xmp.metadata");
        }
        try {
            meta = XMPMetaFactory.parseFromBuffer(existingXmpMetadata);
        }
        catch (XMPException exc) {
            throw new PdfAConformanceException("document.to.read.from.shall.be.a.pdfa.conformant.file.with.valid.xmp.metadata");
        }
        PdfAConformanceLevel conformanceLevel = PdfAConformanceLevel.getConformanceLevel(meta);
        if (conformanceLevel == null) {
            throw new PdfAConformanceException("document.to.read.from.shall.be.a.pdfa.conformant.file.with.valid.xmp.metadata");
        }
        this.setChecker(conformanceLevel);
    }

    public void checkIsoConformance(Object obj, IsoKey key) {
        this.checkIsoConformance(obj, key, null);
    }

    public void checkShowTextIsoConformance(Object obj, PdfResources resources) {
        CanvasGraphicsState gState = (CanvasGraphicsState)obj;
        boolean fill = false;
        boolean stroke = false;
        switch (gState.getTextRenderingMode()) {
            case 1: 
            case 5: {
                stroke = true;
                break;
            }
            case 0: 
            case 4: {
                fill = true;
                break;
            }
            case 2: 
            case 6: {
                stroke = true;
                fill = true;
            }
        }
        IsoKey drawMode = null;
        if (fill && stroke) {
            drawMode = IsoKey.DRAWMODE_FILL_STROKE;
        } else if (fill) {
            drawMode = IsoKey.DRAWMODE_FILL;
        } else if (stroke) {
            drawMode = IsoKey.DRAWMODE_STROKE;
        }
        if (fill || stroke) {
            this.checkIsoConformance(gState, drawMode, resources);
        }
    }

    public void checkIsoConformance(Object obj, IsoKey key, PdfResources resources) {
        PdfDictionary currentColorSpaces = null;
        if (resources != null) {
            currentColorSpaces = ((PdfDictionary)resources.getPdfObject()).getAsDictionary(PdfName.ColorSpace);
        }
        switch (key) {
            case CANVAS_STACK: {
                this.checker.checkCanvasStack(((Character)obj).charValue());
                break;
            }
            case PDF_OBJECT: {
                this.checker.checkPdfObject((PdfObject)obj);
                break;
            }
            case RENDERING_INTENT: {
                this.checker.checkRenderingIntent((PdfName)obj);
                break;
            }
            case INLINE_IMAGE: {
                this.checker.checkInlineImage((PdfStream)obj, currentColorSpaces);
                break;
            }
            case GRAPHIC_STATE_ONLY: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkExtGState(gState);
                break;
            }
            case DRAWMODE_FILL: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getFillColor(), currentColorSpaces, true);
                this.checker.checkExtGState(gState);
                break;
            }
            case DRAWMODE_STROKE: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getStrokeColor(), currentColorSpaces, false);
                this.checker.checkExtGState(gState);
                break;
            }
            case DRAWMODE_FILL_STROKE: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getFillColor(), currentColorSpaces, true);
                this.checker.checkColor(gState.getStrokeColor(), currentColorSpaces, false);
                this.checker.checkExtGState(gState);
                break;
            }
            case PAGE: {
                this.checker.checkSinglePage((PdfPage)obj);
            }
        }
    }

    public PdfAConformanceLevel getConformanceLevel() {
        return this.checker.getConformanceLevel();
    }

    protected void updateXmpMetadata() {
        try {
            XMPMeta xmpMeta = this.updateDefaultXmpMetadata();
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", this.checker.getConformanceLevel().getPart());
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", this.checker.getConformanceLevel().getConformance());
            if (this.isTagged()) {
                XMPMeta taggedExtensionMeta = XMPMetaFactory.parseFromString("    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:namespaceURI>http://www.aiim.org/pdfua/ns/id/</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\n                <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\n                      <pdfaProperty:name>part</pdfaProperty:name>\n                      <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\n                      <pdfaProperty:name>amd</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\n                      <pdfaProperty:name>corr</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>");
                XMPUtils.appendProperties(taggedExtensionMeta, xmpMeta, true, false);
            }
            this.setXmpMetadata(xmpMeta);
        }
        catch (XMPException e) {
            Logger logger = LoggerFactory.getLogger(PdfADocument.class);
            logger.error("Exception while updating XmpMetadata", e);
        }
    }

    protected void checkIsoConformance() {
        this.checker.checkDocument(this.catalog);
    }

    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        this.markObjectAsMustBeFlushed(pdfObject);
        if (this.isClosing || this.checker.objectIsChecked(pdfObject)) {
            super.flushObject(pdfObject, canBeInObjStm);
        }
    }

    protected void flushFonts() {
        for (PdfFont pdfFont : this.getDocumentFonts()) {
            if (pdfFont.isEmbedded()) continue;
            throw new PdfAConformanceException("all.the.fonts.must.be.embedded.this.one.isn.t.1").setMessageParams(pdfFont.getFontProgram().getFontNames().getFontName());
        }
        super.flushFonts();
    }

    protected void setChecker(PdfAConformanceLevel conformanceLevel) {
        CheckerCreater creater = checkerCreaterHashMap.get(conformanceLevel.getPart());
        if (creater != null) {
            this.checker = creater.createChecker(conformanceLevel);
        }
    }

    protected void initTagStructureContext() {
        this.tagStructureContext = new TagStructureContext(this, PdfADocument.getPdfVersionForPdfA(this.checker.getConformanceLevel()));
    }

    protected Counter getCounter() {
        return CounterFactory.getCounter(PdfADocument.class);
    }

    private static PdfVersion getPdfVersionForPdfA(PdfAConformanceLevel conformanceLevel) {
        PdfVersion version = pdfVersionMap.get(conformanceLevel.getPart());
        return version == null ? PdfVersion.PDF_1_4 : version;
    }

    static {
        checkerCreaterHashMap.put("1", new CheckerCreater(){

            public PdfAChecker createChecker(PdfAConformanceLevel conformanceLevel) {
                return new PdfA1Checker(conformanceLevel);
            }
        });
        checkerCreaterHashMap.put("2", new CheckerCreater(){

            public PdfAChecker createChecker(PdfAConformanceLevel conformanceLevel) {
                return new PdfA2Checker(conformanceLevel);
            }
        });
        checkerCreaterHashMap.put("3", new CheckerCreater(){

            public PdfAChecker createChecker(PdfAConformanceLevel conformanceLevel) {
                return new PdfA3Checker(conformanceLevel);
            }
        });
        pdfVersionMap = new HashMap<String, PdfVersion>();
        pdfVersionMap.put("1", PdfVersion.PDF_1_4);
        pdfVersionMap.put("2", PdfVersion.PDF_1_7);
        pdfVersionMap.put("3", PdfVersion.PDF_1_7);
    }

    private static interface CheckerCreater {
        public PdfAChecker createChecker(PdfAConformanceLevel var1);
    }
}

