/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfVersion;
import com.fr.third.fr.pdf.kernel.pdf.canvas.CanvasArtifact;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagStructureContext;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagTreePointer;
import com.fr.third.fr.pdf.layout.border.Border;
import com.fr.third.fr.pdf.layout.element.Cell;
import com.fr.third.fr.pdf.layout.element.Table;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutContext;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import com.fr.third.fr.pdf.layout.renderer.AbstractRenderer;
import com.fr.third.fr.pdf.layout.renderer.AccessibleAttributesApplier;
import com.fr.third.fr.pdf.layout.renderer.CellRenderer;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
extends AbstractRenderer {
    protected List<CellRenderer[]> rows = new ArrayList<CellRenderer[]>();
    protected Table.RowRange rowRange;
    protected TableRenderer headerRenderer;
    protected TableRenderer footerRenderer;
    protected boolean isOriginalNonSplitRenderer = true;
    private ArrayList<ArrayList<Border>> horizontalBorders;
    private ArrayList<ArrayList<Border>> verticalBorders;
    private float[] columnWidths = null;
    private List<Float> heights = new ArrayList<Float>();

    private TableRenderer() {
    }

    public TableRenderer(Table modelElement, Table.RowRange rowRange) {
        super(modelElement);
        this.setRowRange(rowRange);
    }

    @Override
    protected Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        return rect;
    }

    @Override
    protected Rectangle applyMargins(Rectangle rect, boolean reverse) {
        return rect;
    }

    @Override
    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return rect;
    }

    public TableRenderer(Table modelElement) {
        this(modelElement, new Table.RowRange(0, modelElement.getNumberOfRows() - 1));
    }

    @Override
    public void addChild(IRenderer renderer) {
        if (renderer instanceof CellRenderer) {
            renderer.setParent(this);
            Cell cell = (Cell)renderer.getModelElement();
            this.rows.get((int)(cell.getRow() - this.rowRange.getStartRow() + cell.getRowspan() - 1))[cell.getCol()] = (CellRenderer)renderer;
        } else {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error("Only BlockRenderer with Cell layout element could be added");
        }
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Table footerElement;
        boolean headerShouldBeApplied;
        LayoutArea area = layoutContext.getArea();
        Rectangle layoutBox = area.getBBox().clone();
        if (!((Table)this.modelElement).isComplete()) {
            this.setFloatProperty(43, 0.0f);
        }
        if (this.rowRange.getStartRow() != 0) {
            this.setFloatProperty(46, 0.0f);
        }
        Table tableModel = (Table)this.getModelElement();
        float tableWidth = this.retrieveWidth(layoutBox.getWidth());
        if (tableWidth == 0.0f) {
            tableWidth = layoutBox.getWidth();
        }
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), tableWidth, 0.0f));
        int numberOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
        this.horizontalBorders = new ArrayList();
        this.verticalBorders = new ArrayList();
        Table headerElement = tableModel.getHeader();
        boolean isFirstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer;
        boolean bl = headerShouldBeApplied = !this.rows.isEmpty() && (!this.isOriginalNonSplitRenderer || isFirstHeader && !tableModel.isSkipFirstHeader());
        if (headerElement != null && headerShouldBeApplied) {
            this.headerRenderer = (TableRenderer)headerElement.createRendererSubTree().setParent(this);
            LayoutResult result = this.headerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            if (result.getStatus() != 1) {
                return new LayoutResult(3, null, null, this);
            }
            float headerHeight = result.getOccupiedArea().getBBox().getHeight();
            layoutBox.decreaseHeight(headerHeight);
            this.occupiedArea.getBBox().moveDown(headerHeight).increaseHeight(headerHeight);
        }
        if ((footerElement = tableModel.getFooter()) != null) {
            this.footerRenderer = (TableRenderer)footerElement.createRendererSubTree().setParent(this);
            LayoutResult result = this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            if (result.getStatus() != 1) {
                return new LayoutResult(3, null, null, this);
            }
            float footerHeight = result.getOccupiedArea().getBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
        }
        this.columnWidths = this.calculateScaledColumnWidths(tableModel, tableWidth);
        LayoutResult[] splits = new LayoutResult[tableModel.getNumberOfColumns()];
        int[] targetOverflowRowIndex = new int[tableModel.getNumberOfColumns()];
        this.horizontalBorders.add(tableModel.getLastRowBottomBorder());
        for (int row = 0; row < this.rows.size(); ++row) {
            int col;
            VerticalAlignment verticalAlignment = null;
            CellRenderer[] currentRow = this.rows.get(row);
            float rowHeight = 0.0f;
            boolean split = false;
            boolean hasContent = true;
            boolean cellWithBigRowspanAdded = false;
            ArrayList<CellRenderer> currChildRenderers = new ArrayList<CellRenderer>();
            LinkedList<CellRendererInfo> cellProcessingQueue = new LinkedList<CellRendererInfo>();
            for (col = 0; col < currentRow.length; ++col) {
                if (currentRow[col] == null) continue;
                cellProcessingQueue.add(new CellRendererInfo(currentRow[col], col, row));
            }
            while (!cellProcessingQueue.isEmpty()) {
                int i;
                CellRenderer nextCell;
                CellRendererInfo currentCellInfo = (CellRendererInfo)cellProcessingQueue.poll();
                int col2 = currentCellInfo.column;
                CellRenderer cell = currentCellInfo.cellRenderer;
                if (cell != null) {
                    this.buildBordersArrays(cell, row, cell.getModelElement().getRowspan(), cell.getModelElement().getColspan(), true);
                }
                if (row + 1 < this.rows.size() && (nextCell = this.rows.get(row + 1)[col2]) != null) {
                    this.buildBordersArrays(nextCell, row + 1, nextCell.getModelElement().getRowspan(), nextCell.getModelElement().getColspan(), true);
                }
                targetOverflowRowIndex[col2] = currentCellInfo.finishRowInd;
                boolean currentCellHasBigRowspan = row != currentCellInfo.finishRowInd;
                int colspan = cell.getColSpan();
                int rowspan = cell.getRowSpan();
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (i = col2; i < col2 + colspan; ++i) {
                    cellWidth += this.columnWidths[i];
                }
                for (i = 0; i < col2; ++i) {
                    colOffset += this.columnWidths[i];
                }
                float rowspanOffset = 0.0f;
                for (int i2 = row - 1; i2 > currentCellInfo.finishRowInd - rowspan && i2 >= 0; --i2) {
                    rowspanOffset += this.heights.get(i2).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + (!currentCellHasBigRowspan || hasContent ? layoutBox.getHeight() : 0.0f);
                float cellLayoutBoxBottom = layoutBox.getY() + (!currentCellHasBigRowspan || hasContent ? 0.0f : layoutBox.getHeight());
                Rectangle cellLayoutBox = new Rectangle(layoutBox.getX() + colOffset, cellLayoutBoxBottom, cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutContext.getArea().getPageNumber(), cellLayoutBox);
                verticalAlignment = cell.getVerticalAlignment();
                cell.setRenderVerticalAlignment(null);
                LayoutResult cellResult = cell.layout(new LayoutContext(cellArea));
                cell.setRenderVerticalAlignment(verticalAlignment);
                if (cellResult.getStatus() != 3) {
                    cell.getOccupiedArea().getBBox().setWidth(cellWidth);
                }
                if (currentCellHasBigRowspan) {
                    if (cellResult.getStatus() == 2) {
                        splits[col2] = cellResult;
                        currentRow[col2] = (CellRenderer)cellResult.getSplitRenderer();
                    } else {
                        this.rows.get((int)currentCellInfo.finishRowInd)[col2] = null;
                        currentRow[col2] = cell;
                    }
                }
                currChildRenderers.add(cell);
                if (cellResult.getStatus() == 3) continue;
                rowHeight = Math.max(rowHeight, cell.getOccupiedArea().getBBox().getHeight() - rowspanOffset);
            }
            if (hasContent || cellWithBigRowspanAdded) {
                this.heights.add(Float.valueOf(rowHeight));
                for (col = 0; col < currentRow.length; ++col) {
                    CellRenderer cell = currentRow[col];
                    if (cell == null) continue;
                    float height = 0.0f;
                    int rowspan = cell.getRowSpan();
                    for (int i = row; i > targetOverflowRowIndex[col] - rowspan && i >= 0; --i) {
                        height += this.heights.get(i).floatValue();
                    }
                    int rowN = row + 1;
                    if (!hasContent) {
                        --rowN;
                    }
                    if (this.horizontalBorders.get(rowN).get(col) == null) {
                        this.horizontalBorders.get(rowN).set(col, cell.getBorders()[2]);
                    }
                    if (cell.getOccupiedArea() != null) {
                        float shift = height - cell.getOccupiedArea().getBBox().getHeight();
                        Rectangle bBox = cell.getOccupiedArea().getBBox();
                        bBox.moveDown(shift);
                        bBox.setHeight(height);
                    }
                    cell.applyVerticalAlignment();
                }
                this.occupiedArea.getBBox().moveDown(rowHeight);
                this.occupiedArea.getBBox().increaseHeight(rowHeight);
                layoutBox.decreaseHeight(rowHeight);
            }
            this.childRenderers.addAll(currChildRenderers);
            currChildRenderers.clear();
        }
        if (this.isPositioned()) {
            float y = this.getPropertyAsFloat(80);
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + y - this.occupiedArea.getBBox().getY());
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (tableModel.isSkipLastFooter() || !tableModel.isComplete()) {
            this.footerRenderer = null;
        }
        this.adjustFooterAndFixOccupiedArea(layoutBox);
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean ignoreTag = false;
        PdfName role = null;
        if (isTagged) {
            role = ((IAccessibleElement)((Object)this.getModelElement())).getRole();
            boolean isHeaderOrFooter = PdfName.THead.equals(role) || PdfName.TFoot.equals(role);
            boolean ignoreHeaderFooterTag = document.getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
            boolean bl = ignoreTag = isHeaderOrFooter && ignoreHeaderFooterTag;
        }
        if (role != null && !role.equals(PdfName.Artifact) && !ignoreTag) {
            boolean toRemoveConnectionsWithTag;
            TagStructureContext tagStructureContext = document.getTagStructureContext();
            TagTreePointer tagPointer = tagStructureContext.getAutoTaggingPointer();
            IAccessibleElement accessibleElement = (IAccessibleElement)((Object)this.getModelElement());
            if (!tagStructureContext.isElementConnectedToTag(accessibleElement)) {
                AccessibleAttributesApplier.applyLayoutAttributes(role, this, document);
            }
            Table modelElement = (Table)this.getModelElement();
            tagPointer.addTag(accessibleElement, true);
            super.draw(drawContext);
            tagPointer.moveToParent();
            boolean bl = toRemoveConnectionsWithTag = this.isLastRendererForModelElement && modelElement.isComplete();
            if (toRemoveConnectionsWithTag) {
                tagPointer.removeElementConnectionToTag(accessibleElement);
            }
        } else {
            super.draw(drawContext);
        }
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        boolean shouldHaveFooterOrHeaderTag;
        Table modelElement = (Table)this.getModelElement();
        if (this.headerRenderer != null) {
            boolean notToTagHeader;
            boolean firstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer && !modelElement.isSkipFirstHeader();
            boolean bl = notToTagHeader = drawContext.isTaggingEnabled() && !firstHeader;
            if (notToTagHeader) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            this.headerRenderer.draw(drawContext);
            if (notToTagHeader) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement && !this.childRenderers.isEmpty();
        TagTreePointer tagPointer = null;
        boolean bl = shouldHaveFooterOrHeaderTag = modelElement.getHeader() != null || modelElement.getFooter() != null;
        if (isTagged) {
            PdfName role = modelElement.getRole();
            if (role != null && !PdfName.Artifact.equals(role)) {
                tagPointer = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
                boolean ignoreHeaderFooterTag = drawContext.getDocument().getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
                boolean bl2 = shouldHaveFooterOrHeaderTag = shouldHaveFooterOrHeaderTag && !ignoreHeaderFooterTag && (!modelElement.isSkipFirstHeader() || !modelElement.isSkipLastFooter());
                if (shouldHaveFooterOrHeaderTag) {
                    if (tagPointer.getKidsRoles().contains(PdfName.TBody)) {
                        tagPointer.moveToKid(PdfName.TBody);
                    } else {
                        tagPointer.addTag(PdfName.TBody);
                    }
                }
            } else {
                isTagged = false;
            }
        }
        for (IRenderer child : this.childRenderers) {
            if (isTagged) {
                int rowsNum;
                int cellRow;
                int adjustByHeaderRowsNum = 0;
                if (modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() && !shouldHaveFooterOrHeaderTag) {
                    adjustByHeaderRowsNum = modelElement.getHeader().getNumberOfRows();
                }
                if ((cellRow = ((Cell)child.getModelElement()).getRow() + adjustByHeaderRowsNum) < (rowsNum = tagPointer.getKidsRoles().size())) {
                    tagPointer.moveToKid(cellRow);
                } else {
                    tagPointer.addTag(PdfName.TR);
                }
            }
            child.draw(drawContext);
            if (!isTagged) continue;
            tagPointer.moveToParent();
        }
        if (isTagged && shouldHaveFooterOrHeaderTag) {
            tagPointer.moveToParent();
        }
        this.drawBorders(drawContext);
        if (this.footerRenderer != null) {
            boolean notToTagFooter;
            boolean lastFooter = this.isLastRendererForModelElement && modelElement.isComplete() && !modelElement.isSkipLastFooter();
            boolean bl3 = notToTagFooter = drawContext.isTaggingEnabled() && !lastFooter;
            if (notToTagFooter) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            this.footerRenderer.draw(drawContext);
            if (notToTagFooter) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        TableRenderer nextTable = new TableRenderer();
        nextTable.modelElement = this.modelElement;
        return nextTable;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        super.move(dxRight, dyUp);
        if (this.headerRenderer != null) {
            this.headerRenderer.move(dxRight, dyUp);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.move(dxRight, dyUp);
        }
    }

    protected float[] calculateScaledColumnWidths(Table tableModel, float tableWidth) {
        int i;
        float[] columnWidths = new float[tableModel.getNumberOfColumns()];
        float widthSum = 0.0f;
        for (i = 0; i < tableModel.getNumberOfColumns(); ++i) {
            columnWidths[i] = tableModel.getColumnWidth(i);
            widthSum += columnWidths[i];
        }
        i = 0;
        while (i < tableModel.getNumberOfColumns()) {
            int n = i++;
            columnWidths[n] = columnWidths[n] * (tableWidth / widthSum);
        }
        return columnWidths;
    }

    protected TableRenderer[] split(int row) {
        return this.split(row, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent) {
        int i;
        TableRenderer splitRenderer = this.createSplitRenderer(new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + row));
        splitRenderer.rows = this.rows.subList(0, row);
        int rowN = row;
        if (hasContent || row == 0) {
            ++rowN;
        }
        splitRenderer.horizontalBorders = new ArrayList();
        for (i = 0; i <= rowN; ++i) {
            splitRenderer.horizontalBorders.add(this.horizontalBorders.get(i));
        }
        splitRenderer.verticalBorders = new ArrayList();
        for (i = 0; i < this.verticalBorders.size(); ++i) {
            splitRenderer.verticalBorders.add(new ArrayList());
            for (int j = 0; j < rowN; ++j) {
                splitRenderer.verticalBorders.get(i).add(this.verticalBorders.get(i).get(j));
            }
        }
        splitRenderer.heights = this.heights;
        splitRenderer.columnWidths = this.columnWidths;
        TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
        overflowRenderer.rows = this.rows.subList(row, this.rows.size());
        splitRenderer.occupiedArea = this.occupiedArea;
        return new TableRenderer[]{splitRenderer, overflowRenderer};
    }

    protected TableRenderer createSplitRenderer(Table.RowRange rowRange) {
        TableRenderer splitRenderer = (TableRenderer)this.getNextRenderer();
        splitRenderer.rowRange = rowRange;
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.childRenderers = this.childRenderers;
        splitRenderer.addAllProperties(this.getOwnProperties());
        splitRenderer.headerRenderer = this.headerRenderer;
        splitRenderer.footerRenderer = this.footerRenderer;
        splitRenderer.isLastRendererForModelElement = false;
        return splitRenderer;
    }

    protected TableRenderer createOverflowRenderer(Table.RowRange rowRange) {
        TableRenderer overflowRenderer = (TableRenderer)this.getNextRenderer();
        overflowRenderer.rowRange = rowRange;
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.isOriginalNonSplitRenderer = false;
        return overflowRenderer;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawBorders(DrawContext drawContext) {
        Border lastBorder;
        Border curBorder;
        Border prevBorder;
        int j;
        boolean isTagged;
        if (this.occupiedArea.getBBox().getHeight() < 1.0E-4f) {
            return;
        }
        float startX = this.getOccupiedArea().getBBox().getX();
        float startY = this.getOccupiedArea().getBBox().getY() + this.getOccupiedArea().getBBox().getHeight();
        for (IRenderer child : this.childRenderers) {
            CellRenderer cell = (CellRenderer)child;
            if (cell.getModelElement().getCol() != 0) continue;
            startX = cell.getOccupiedArea().getBBox().getX();
            startY = cell.getOccupiedArea().getBBox().getY() + cell.getOccupiedArea().getBBox().getHeight();
            break;
        }
        boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        if (isTagged) {
            drawContext.getCanvas().openTag(new CanvasArtifact());
        }
        float y1 = startY;
        int i = 0;
        while (true) {
            Border firstBorder;
            if (i >= this.horizontalBorders.size()) break;
            ArrayList<Border> borders = this.horizontalBorders.get(i);
            float x1 = startX;
            float x2 = x1 + this.columnWidths[0];
            if (i == 0 ? this.verticalBorders != null && this.verticalBorders.size() > 0 && this.verticalBorders.get(0).size() > 0 && this.verticalBorders.get(this.verticalBorders.size() - 1).size() > 0 && (firstBorder = this.verticalBorders.get(0).get(0)) == null : i != this.horizontalBorders.size() - 1 || this.verticalBorders == null || this.verticalBorders.size() <= 0 || this.verticalBorders.get(0).size() <= 0 || this.verticalBorders.get(this.verticalBorders.size() - 1) == null || this.verticalBorders.get(this.verticalBorders.size() - 1).size() <= 0 || this.verticalBorders.get(0) == null || (firstBorder = this.verticalBorders.get(0).get(this.verticalBorders.get(0).size() - 1)) != null) {
                // empty if block
            }
            for (j = 1; j < borders.size(); ++j) {
                prevBorder = borders.get(j - 1);
                curBorder = borders.get(j);
                if (prevBorder != null) {
                    if (!prevBorder.equals(curBorder)) {
                        prevBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x2, y1);
                        x1 = x2;
                    }
                } else {
                    x2 = x1 += this.columnWidths[j - 1];
                }
                if (curBorder == null) continue;
                x2 += this.columnWidths[j];
            }
            Border border = lastBorder = borders.size() > j - 1 ? borders.get(j - 1) : null;
            if (lastBorder != null) {
                Border b;
                ArrayList<Border> ab;
                if (this.verticalBorders.get(j).size() <= 0 || (i == 0 ? (ab = this.verticalBorders.get(j)) != null && (b = ab.get(i)) == null : i != this.horizontalBorders.size() - 1 || this.verticalBorders.get(j).size() < i - 1 || this.verticalBorders.get(j).get(i - 1) == null || (ab = this.verticalBorders.get(j)) == null || (b = ab.get(i - 1)) != null)) {
                    // empty if block
                }
                lastBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x2, y1);
            }
            if (i < this.heights.size()) {
                y1 -= this.heights.get(i).floatValue();
            }
            ++i;
        }
        float x1 = startX;
        int i2 = 0;
        while (true) {
            float y2;
            ArrayList<Border> borders;
            if (i2 < this.verticalBorders.size()) {
                borders = this.verticalBorders.get(i2);
                y2 = y1 = startY;
                if (!this.heights.isEmpty()) {
                    y2 = y1 - this.heights.get(0).floatValue();
                }
            } else {
                if (isTagged) {
                    drawContext.getCanvas().closeTag();
                }
                return;
            }
            for (j = 1; j < borders.size() && j < this.heights.size(); ++j) {
                prevBorder = borders.get(j - 1);
                curBorder = borders.get(j);
                if (prevBorder != null) {
                    if (!prevBorder.equals(curBorder)) {
                        prevBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x1, y2);
                        y1 = y2;
                    }
                } else {
                    y2 = y1 -= this.heights.get(j - 1).floatValue();
                }
                if (curBorder == null) continue;
                y2 -= this.heights.get(j).floatValue();
            }
            if (borders.size() == 0) {
                x1 += this.columnWidths[i2];
            } else {
                lastBorder = borders.get(j - 1);
                if (lastBorder != null) {
                    lastBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x1, y2);
                }
                if (i2 < this.columnWidths.length) {
                    x1 += this.columnWidths[i2];
                }
            }
            ++i2;
        }
    }

    private void adjustFooterAndFixOccupiedArea(Rectangle layoutBox) {
        if (this.footerRenderer != null) {
            this.footerRenderer.move(0.0f, layoutBox.getHeight());
            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
            this.occupiedArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
        }
    }

    private boolean canFitRowsInGivenArea(LayoutArea layoutArea, int startRow, float[] columnWidths, List<Float> heights) {
        layoutArea = layoutArea.clone();
        heights = new ArrayList<Float>(heights);
        for (int row = startRow; row < this.rows.size(); ++row) {
            CellRenderer[] rowCells = this.rows.get(row);
            float rowHeight = 0.0f;
            for (int col = 0; col < rowCells.length; ++col) {
                int i;
                CellRenderer cell = rowCells[col];
                if (cell == null) continue;
                int colspan = cell.getColSpan();
                int rowspan = cell.getRowSpan();
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (i = col; i < col + colspan; ++i) {
                    cellWidth += columnWidths[i];
                }
                for (i = 0; i < col; ++i) {
                    colOffset += columnWidths[i];
                }
                float rowspanOffset = 0.0f;
                for (int i2 = row - 1; i2 > row - rowspan && i2 >= 0; --i2) {
                    rowspanOffset += heights.get(i2).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + layoutArea.getBBox().getHeight();
                Rectangle cellLayoutBox = new Rectangle(layoutArea.getBBox().getX() + colOffset, layoutArea.getBBox().getY(), cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutArea.getPageNumber(), cellLayoutBox);
                LayoutResult cellResult = cell.layout(new LayoutContext(cellArea));
                if (cellResult.getStatus() != 1) {
                    return false;
                }
                rowHeight = Math.max(rowHeight, cellResult.getOccupiedArea().getBBox().getHeight());
            }
            heights.add(Float.valueOf(rowHeight));
            layoutArea.getBBox().moveUp(rowHeight).decreaseHeight(rowHeight);
        }
        return true;
    }

    private void buildBordersArrays(CellRenderer cell, int row, int rowspan, int colspan, boolean hasContent) {
        int i;
        int colN = cell.getModelElement().getCol();
        Border[] cellBorders = cell.getBorders();
        if (row + 1 - rowspan < 0) {
            rowspan = row + 1;
        }
        if (row + 1 - rowspan != 0) {
            for (i = 0; i < colspan; ++i) {
                if (this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1 - rowspan, colN + i, cellBorders[0])) {
                    CellRenderer rend = this.rows.get(row - rowspan)[colN];
                    if (rend == null) continue;
                    rend.setBorders(cellBorders[0], 2);
                    continue;
                }
                cell.setBorders(this.horizontalBorders.get(row + 1 - rowspan).get(colN + i), 0);
            }
        } else {
            for (i = 0; i < colspan; ++i) {
                if (this.checkAndReplaceBorderInArray(this.horizontalBorders, 0, colN + i, cellBorders[0])) continue;
                cell.setBorders(this.horizontalBorders.get(0).get(colN + i), 0);
            }
        }
        for (i = 0; i < colspan; ++i) {
            if (hasContent) {
                while (row + 1 >= this.horizontalBorders.size()) {
                    this.horizontalBorders.add(new ArrayList());
                }
                ArrayList<Border> borders = this.horizontalBorders.get(row + 1);
                if (borders.size() <= colN + i) {
                    for (int count = borders.size(); count < colN + i; ++count) {
                        borders.add(null);
                    }
                    borders.add(cellBorders[2]);
                    continue;
                }
                if (borders.size() == colN + i) {
                    borders.add(cellBorders[2]);
                    continue;
                }
                borders.set(colN + i, cellBorders[2]);
                continue;
            }
            if (row == this.horizontalBorders.size()) {
                this.horizontalBorders.add(new ArrayList());
            }
            this.horizontalBorders.get(row).add(colN + i, cellBorders[2]);
        }
        if (rowspan > 1) {
            int numOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
            for (int i2 = row - rowspan + 1; i2 <= row; ++i2) {
                ArrayList<Border> borders = this.horizontalBorders.get(i2);
                if (borders.size() >= numOfColumns) continue;
                for (int j = borders.size(); j < numOfColumns; ++j) {
                    borders.add(null);
                }
            }
        }
        if (colN != 0) {
            for (i = row - rowspan + 1; i <= row; ++i) {
                CellRenderer rend;
                if (this.checkAndReplaceBorderInArray(this.verticalBorders, colN, i, cellBorders[3])) {
                    rend = this.rows.get(i)[colN - 1];
                    if (rend == null) continue;
                    rend.setBorders(cellBorders[3], 1);
                    continue;
                }
                rend = this.rows.get(i)[colN];
                if (rend == null) continue;
                rend.setBorders(this.verticalBorders.get(colN).get(row), 3);
            }
        } else {
            for (i = row - rowspan + 1; i <= row; ++i) {
                if (this.verticalBorders.isEmpty()) {
                    this.verticalBorders.add(new ArrayList());
                }
                if (this.verticalBorders.get(0).size() <= i) {
                    this.verticalBorders.get(0).add(cellBorders[3]);
                    continue;
                }
                this.verticalBorders.get(0).set(i, cellBorders[3]);
            }
        }
        for (i = row - rowspan + 1; i <= row; ++i) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, colN + colspan, i, cellBorders[1]);
        }
        if (colspan > 1) {
            for (i = colN; i <= colspan + colN; ++i) {
                ArrayList<Border> borders = this.verticalBorders.get(i);
                if (borders.size() >= row + rowspan) continue;
                for (int j = borders.size(); j < row + rowspan; ++j) {
                    borders.add(null);
                }
            }
        }
    }

    private boolean checkAndReplaceBorderInArray(ArrayList<ArrayList<Border>> borderArray, int i, int j, Border borderToAdd) {
        Border neighbour;
        ArrayList<Border> borders;
        if (borderArray.size() <= i) {
            for (int count = borderArray.size(); count <= i; ++count) {
                borderArray.add(new ArrayList());
            }
        }
        if ((borders = borderArray.get(i)).isEmpty()) {
            for (int count = 0; count < j; ++count) {
                borders.add(null);
            }
            borders.add(borderToAdd);
            return true;
        }
        if (borders.size() == j) {
            borders.add(borderToAdd);
            return true;
        }
        if (borders.size() <= j) {
            for (int count = borders.size(); count <= j; ++count) {
                borders.add(count, null);
            }
        }
        if ((neighbour = borders.get(j)) == null) {
            borders.set(j, borderToAdd);
            return true;
        }
        if (neighbour != borderToAdd && borderToAdd != null && neighbour.getWidth() < borderToAdd.getWidth()) {
            borders.set(j, borderToAdd);
            return true;
        }
        return false;
    }

    private void setRowRange(Table.RowRange rowRange) {
        this.rowRange = rowRange;
        for (int row = rowRange.getStartRow(); row <= rowRange.getFinishRow(); ++row) {
            this.rows.add(new CellRenderer[((Table)this.modelElement).getNumberOfColumns()]);
        }
    }

    private static class CellRendererInfo {
        public CellRenderer cellRenderer;
        public int column;
        public int finishRowInd;

        public CellRendererInfo(CellRenderer cellRenderer, int column, int finishRow) {
            this.cellRenderer = cellRenderer;
            this.column = column;
            this.finishRowInd = finishRow;
        }
    }
}

