/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.font.PdfFontFactory;
import com.fr.third.fr.pdf.kernel.numbering.EnglishAlphabetNumbering;
import com.fr.third.fr.pdf.kernel.numbering.GreekAlphabetNumbering;
import com.fr.third.fr.pdf.kernel.numbering.RomanNumbering;
import com.fr.third.fr.pdf.layout.element.Image;
import com.fr.third.fr.pdf.layout.element.List;
import com.fr.third.fr.pdf.layout.element.ListItem;
import com.fr.third.fr.pdf.layout.element.Text;
import com.fr.third.fr.pdf.layout.layout.LayoutContext;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.property.ListNumberingType;
import com.fr.third.fr.pdf.layout.renderer.AbstractRenderer;
import com.fr.third.fr.pdf.layout.renderer.BlockRenderer;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.ImageRenderer;
import com.fr.third.fr.pdf.layout.renderer.ListItemRenderer;
import com.fr.third.fr.pdf.layout.renderer.TextRenderer;
import java.util.ArrayList;

public class ListRenderer
extends BlockRenderer {
    public ListRenderer(List modelElement) {
        super(modelElement);
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        if (!this.hasOwnProperty(40)) {
            ArrayList<Object> symbolRenderers = new ArrayList<Object>();
            int listItemNum = this.getProperty(36, 1);
            for (int i = 0; i < this.childRenderers.size(); ++i) {
                if (!(((IRenderer)this.childRenderers.get(i)).getModelElement() instanceof ListItem)) continue;
                IRenderer currentSymbolRenderer = this.makeListSymbolRenderer(listItemNum++, (IRenderer)this.childRenderers.get(i));
                symbolRenderers.add(currentSymbolRenderer);
                LayoutResult layoutResult = currentSymbolRenderer.layout(layoutContext);
                if (layoutResult.getStatus() == 1) continue;
                return new LayoutResult(3, null, null, this);
            }
            float maxSymbolWidth = 0.0f;
            for (IRenderer iRenderer : symbolRenderers) {
                maxSymbolWidth = Math.max(maxSymbolWidth, iRenderer.getOccupiedArea().getBBox().getWidth());
            }
            Float symbolIndent = (Float)this.modelElement.getProperty(39);
            listItemNum = 0;
            for (IRenderer childRenderer : this.childRenderers) {
                childRenderer.deleteOwnProperty(44);
                childRenderer.setFloatProperty(44, childRenderer.getFloatProperty(44) + maxSymbolWidth + (symbolIndent != null ? symbolIndent.floatValue() : 0.0f));
                if (!(childRenderer.getModelElement() instanceof ListItem)) continue;
                IRenderer symbolRenderer = (IRenderer)symbolRenderers.get(listItemNum++);
                ((ListItemRenderer)childRenderer).addSymbolRenderer(symbolRenderer, maxSymbolWidth);
            }
        }
        return super.layout(layoutContext);
    }

    public IRenderer getNextRenderer() {
        return new ListRenderer((List)this.modelElement);
    }

    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = super.createSplitRenderer(layoutResult);
        splitRenderer.setProperty(40, true);
        return splitRenderer;
    }

    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = super.createOverflowRenderer(layoutResult);
        overflowRenderer.setProperty(40, true);
        return overflowRenderer;
    }

    protected IRenderer makeListSymbolRenderer(int index, IRenderer renderer) {
        Object defaultListSymbol = renderer.getProperty(37);
        if (defaultListSymbol instanceof Text) {
            return new TextRenderer((Text)defaultListSymbol).setParent(this);
        }
        if (defaultListSymbol instanceof Image) {
            return new ImageRenderer((Image)defaultListSymbol).setParent(this);
        }
        if (defaultListSymbol instanceof ListNumberingType) {
            IRenderer textRenderer;
            String numberText;
            ListNumberingType numberingType = (ListNumberingType)((Object)defaultListSymbol);
            switch (numberingType) {
                case DECIMAL: {
                    numberText = String.valueOf(index);
                    break;
                }
                case ROMAN_LOWER: {
                    numberText = RomanNumbering.toRomanLowerCase(index);
                    break;
                }
                case ROMAN_UPPER: {
                    numberText = RomanNumbering.toRomanUpperCase(index);
                    break;
                }
                case ENGLISH_LOWER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase(index);
                    break;
                }
                case ENGLISH_UPPER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase(index);
                    break;
                }
                case GREEK_LOWER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumberLowerCase(index);
                    break;
                }
                case GREEK_UPPER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumberUpperCase(index);
                    break;
                }
                case ZAPF_DINGBATS_1: {
                    numberText = String.valueOf((char)(index + 171));
                    break;
                }
                case ZAPF_DINGBATS_2: {
                    numberText = String.valueOf((char)(index + 181));
                    break;
                }
                case ZAPF_DINGBATS_3: {
                    numberText = String.valueOf((char)(index + 191));
                    break;
                }
                case ZAPF_DINGBATS_4: {
                    numberText = String.valueOf((char)(index + 201));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Text textElement = new Text(renderer.getProperty(41) + numberText + renderer.getProperty(42));
            if (numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER || numberingType == ListNumberingType.ZAPF_DINGBATS_1 || numberingType == ListNumberingType.ZAPF_DINGBATS_2 || numberingType == ListNumberingType.ZAPF_DINGBATS_3 || numberingType == ListNumberingType.ZAPF_DINGBATS_4) {
                final String constantFont = numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER ? "Symbol" : "ZapfDingbats";
                textRenderer = new TextRenderer(textElement){

                    public void draw(DrawContext drawContext) {
                        try {
                            this.setPdfFont(PdfFontFactory.createFont(constantFont));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        super.draw(drawContext);
                    }
                }.setParent(this);
                try {
                    textRenderer.setPdfFont(PdfFontFactory.createFont(constantFont));
                }
                catch (Exception exception) {}
            } else {
                textRenderer = new TextRenderer(textElement).setParent(this);
            }
            return textRenderer;
        }
        throw new IllegalStateException();
    }
}

