/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.geom.AffineTransform;
import com.fr.third.fr.pdf.kernel.geom.Point;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.TagTreePointer;
import com.fr.third.fr.pdf.layout.element.IElement;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutContext;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import com.fr.third.fr.pdf.layout.renderer.AbstractRenderer;
import com.fr.third.fr.pdf.layout.renderer.AccessibleAttributesApplier;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockRenderer
extends AbstractRenderer {
    protected BlockRenderer(IElement modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        float blockWidth;
        int pageNumber = layoutContext.getArea().getPageNumber();
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        float blockHeight = this.retrieveHeight();
        if (!this.isFixedLayout() && blockHeight != 0.0f && blockHeight > parentBBox.getHeight()) {
            this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), blockHeight));
            return new LayoutResult(3, null, null, this);
        }
        this.applyMargins(parentBBox, false);
        this.applyBorderBox(parentBBox, false);
        if (this.isPositioned()) {
            float x = this.getPropertyAsFloat(79);
            float relativeX = this.isFixedLayout() ? 0.0f : parentBBox.getX();
            parentBBox.setX(relativeX + x);
        }
        if ((blockWidth = this.retrieveWidth(parentBBox.getWidth())) != 0.0f && (blockWidth < parentBBox.getWidth() || this.isPositioned())) {
            parentBBox.setWidth(blockWidth);
        }
        this.applyPaddings(parentBBox, false);
        List<Rectangle> areas = this.isPositioned() ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        boolean anythingPlaced = false;
        for (int childPos = 0; childPos < this.childRenderers.size(); ++childPos) {
            LayoutResult result;
            IRenderer childRenderer = (IRenderer)this.childRenderers.get(childPos);
            while ((result = childRenderer.layout(new LayoutContext(new LayoutArea(pageNumber, layoutBox)))).getStatus() != 1) {
                if (result.getOccupiedArea() != null) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle(this.occupiedArea.getBBox(), result.getOccupiedArea().getBBox()));
                    layoutBox.setHeight(layoutBox.getHeight() - result.getOccupiedArea().getBBox().getHeight());
                }
                if (childRenderer.getUnitWidth() != 0.0f) {
                    this.alignChildHorizontally(childRenderer, layoutBox.getWidth());
                }
                if (currentAreaPos + 1 < areas.size()) {
                    if (result.getStatus() == 2) {
                        this.childRenderers.set(childPos, result.getSplitRenderer());
                        this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                    } else {
                        this.childRenderers.set(childPos, result.getOverflowRenderer());
                        --childPos;
                    }
                    layoutBox = areas.get(++currentAreaPos).clone();
                    break;
                }
                if (result.getStatus() == 2) {
                    layoutBox.setHeight(layoutBox.getHeight() - result.getOccupiedArea().getBBox().getHeight());
                    if (currentAreaPos + 1 == areas.size()) {
                        AbstractRenderer splitRenderer = this.createSplitRenderer(2);
                        splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
                        splitRenderer.childRenderers.add(result.getSplitRenderer());
                        splitRenderer.occupiedArea = this.occupiedArea;
                        AbstractRenderer overflowRenderer = this.createOverflowRenderer(2);
                        ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
                        overflowRendererChildren.add(result.getOverflowRenderer());
                        overflowRendererChildren.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                        overflowRenderer.childRenderers = overflowRendererChildren;
                        this.applyPaddings(this.occupiedArea.getBBox(), true);
                        this.applyBorderBox(this.occupiedArea.getBBox(), true);
                        this.applyMargins(this.occupiedArea.getBBox(), true);
                        return new LayoutResult(2, this.occupiedArea, splitRenderer, overflowRenderer);
                    }
                    this.childRenderers.set(childPos, result.getSplitRenderer());
                    this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                    layoutBox = areas.get(++currentAreaPos).clone();
                    break;
                }
                if (result.getStatus() != 3) continue;
                boolean keepTogether = this.getPropertyAsBoolean(32);
                int layoutResult = anythingPlaced && !keepTogether ? 2 : 3;
                AbstractRenderer splitRenderer = this.createSplitRenderer(layoutResult);
                splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
                AbstractRenderer overflowRenderer = this.createOverflowRenderer(layoutResult);
                ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
                overflowRendererChildren.add(result.getOverflowRenderer());
                overflowRendererChildren.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                for (IRenderer renderer : overflowRendererChildren) {
                    renderer.setParent(overflowRenderer);
                }
                overflowRenderer.childRenderers = overflowRendererChildren;
                if (keepTogether) {
                    splitRenderer = null;
                    overflowRenderer.childRenderers.clear();
                    overflowRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers);
                }
                this.applyPaddings(this.occupiedArea.getBBox(), true);
                this.applyBorderBox(this.occupiedArea.getBBox(), true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                this.occupiedArea.getBBox().moveDown(blockHeight - this.occupiedArea.getBBox().getHeight()).setHeight(blockHeight);
                if (this.getPropertyAsBoolean(26).booleanValue()) {
                    return new LayoutResult(1, this.occupiedArea, null, null);
                }
                return new LayoutResult(layoutResult, this.occupiedArea, splitRenderer, overflowRenderer);
            }
            anythingPlaced = true;
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle(this.occupiedArea.getBBox(), result.getOccupiedArea().getBBox()));
            if (result.getStatus() != 1) continue;
            layoutBox.setHeight(layoutBox.getHeight() - result.getOccupiedArea().getBBox().getHeight());
            if (childRenderer.getUnitWidth() == 0.0f) continue;
            this.alignChildHorizontally(childRenderer, layoutBox.getWidth());
        }
        this.applyPaddings(this.occupiedArea.getBBox(), true);
        this.occupiedArea.getBBox().moveDown(blockHeight - this.occupiedArea.getBBox().getHeight()).setHeight(blockHeight);
        if (this.isPositioned()) {
            float y = this.getPropertyAsFloat(80);
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + y - this.occupiedArea.getBBox().getY());
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        this.applyVerticalAlignment();
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = (AbstractRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        return splitRenderer;
    }

    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = (AbstractRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.properties = this.properties;
        return overflowRenderer;
    }

    @Override
    public void draw(DrawContext drawContext) {
        PdfDocument document = drawContext.getDocument();
        this.applyDestination(document);
        this.applyAction(document);
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        TagTreePointer tagPointer = null;
        IAccessibleElement accessibleElement = null;
        if (isTagged) {
            accessibleElement = (IAccessibleElement)((Object)this.getModelElement());
            PdfName role = accessibleElement.getRole();
            if (role != null && !PdfName.Artifact.equals(role)) {
                tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
                if (!tagPointer.isElementConnectedToTag(accessibleElement)) {
                    AccessibleAttributesApplier.applyLayoutAttributes(role, this, document);
                    if (role.equals(PdfName.TD)) {
                        AccessibleAttributesApplier.applyTableAttributes(this);
                    }
                    if (role.equals(PdfName.List)) {
                        AccessibleAttributesApplier.applyListAttributes(this);
                    }
                }
                tagPointer.addTag(accessibleElement, true);
            } else {
                isTagged = false;
            }
        }
        this.beginRotationIfApplied(drawContext.getCanvas());
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.endRotationIfApplied(drawContext.getCanvas());
        if (isTagged) {
            tagPointer.moveToParent();
            if (this.isLastRendererForModelElement) {
                document.getTagStructureContext().removeElementConnectionToTag(accessibleElement);
            }
        }
        this.flushed = true;
    }

    @Override
    public Rectangle getOccupiedAreaBBox() {
        if (this.occupiedArea == null) {
            return ((AbstractRenderer)this.parent).getOccupiedAreaBBox();
        }
        Rectangle bBox = this.occupiedArea.getBBox().clone();
        return bBox;
    }

    protected void applyVerticalAlignment() {
        LayoutArea la;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        if (verticalAlignment != null && verticalAlignment != VerticalAlignment.TOP && this.childRenderers.size() > 0 && (la = ((IRenderer)this.childRenderers.get(this.childRenderers.size() - 1)).getOccupiedArea()) != null) {
            float deltaY = la.getBBox().getY() - this.getInnerAreaBBox().getY();
            switch (verticalAlignment) {
                case BOTTOM: {
                    for (IRenderer child : this.childRenderers) {
                        child.move(0.0f, -deltaY);
                    }
                    break;
                }
                case MIDDLE: {
                    for (IRenderer child : this.childRenderers) {
                        child.move(0.0f, -deltaY / 2.0f);
                    }
                    break;
                }
            }
        }
    }

    protected void applyRotationLayout(Rectangle layoutBox) {
        Float rotationPointX = Float.valueOf(this.getPropertyAsFloat(58));
        Float rotationPointY = Float.valueOf(this.getPropertyAsFloat(59));
        if (rotationPointX == null || rotationPointY == null) {
            rotationPointX = Float.valueOf(this.occupiedArea.getBBox().getX());
            rotationPointY = Float.valueOf(this.occupiedArea.getBBox().getY());
            this.setProperty(58, rotationPointX);
            this.setProperty(59, rotationPointY);
        }
        float height = this.occupiedArea.getBBox().getHeight();
        float width = this.occupiedArea.getBBox().getWidth();
        this.setProperty(57, Float.valueOf(width));
        this.setProperty(56, Float.valueOf(height));
        if (!this.isPositioned()) {
            ArrayList<Point> rotatedPoints = new ArrayList<Point>();
            this.getLayoutShiftAndRotatedPoints(rotatedPoints, rotationPointX.floatValue(), rotationPointY.floatValue());
            Point clipLineBeg = new Point(layoutBox.getRight(), layoutBox.getTop());
            Point clipLineEnd = new Point(layoutBox.getRight(), layoutBox.getBottom());
            List<Point> newOccupiedBox = this.clipBBox(rotatedPoints, clipLineBeg, clipLineEnd);
            double maxX = -1.7976931348623157E308;
            double minY = Double.MAX_VALUE;
            for (Point point : newOccupiedBox) {
                if (point.getX() > maxX) {
                    maxX = point.getX();
                }
                if (!(point.getY() < minY)) continue;
                minY = point.getY();
            }
            float newHeight = (float)((double)this.occupiedArea.getBBox().getTop() - minY);
            float newWidth = (float)(maxX - (double)this.occupiedArea.getBBox().getLeft());
            this.occupiedArea.getBBox().setWidth(newWidth);
            this.occupiedArea.getBBox().setHeight(newHeight);
            this.move(0.0f, height - newHeight);
        }
    }

    protected float[] applyRotation() {
        float dx = 0.0f;
        float dy = 0.0f;
        if (!this.isPositioned()) {
            Point shift = this.getLayoutShiftAndRotatedPoints(new ArrayList<Point>(), 0.0f, 0.0f);
            dy = (float)shift.getY();
            dx = (float)shift.getX();
        }
        float angle = this.getPropertyAsFloat(55);
        AffineTransform transform = new AffineTransform();
        transform.rotate(angle);
        float[] ctm = new float[6];
        transform.getMatrix(ctm);
        ctm[4] = this.getPropertyAsFloat(58) + dx;
        ctm[5] = this.getPropertyAsFloat(59) + dy;
        return ctm;
    }

    private Point getLayoutShiftAndRotatedPoints(List<Point> rotatedPoints, float shiftX, float shiftY) {
        float angle = this.getPropertyAsFloat(55);
        float width = this.getPropertyAsFloat(57);
        float height = this.getPropertyAsFloat(56);
        float left = this.occupiedArea.getBBox().getX() - shiftX;
        float bottom = this.occupiedArea.getBBox().getY() - shiftY;
        float right = left + width;
        float top = bottom + height;
        AffineTransform rotateTransform = new AffineTransform();
        rotateTransform.rotate(angle);
        this.transformBBox(left, bottom, right, top, rotateTransform, rotatedPoints);
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (Point point : rotatedPoints) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        float dx = (float)((double)left - minX);
        float dy = (float)((double)top - maxY);
        for (Point point : rotatedPoints) {
            point.setLocation(point.getX() + (double)dx + (double)shiftX, point.getY() + (double)dy + (double)shiftY);
        }
        return new Point(dx, dy);
    }

    protected void beginRotationIfApplied(PdfCanvas canvas) {
    }

    protected void endRotationIfApplied(PdfCanvas canvas) {
    }

    private List<Point> transformBBox(float left, float bottom, float right, float top, AffineTransform transform, List<Point> bBoxPoints) {
        bBoxPoints.addAll(Arrays.asList(new Point(left, bottom), new Point(right, bottom), new Point(right, top), new Point(left, top)));
        for (Point point : bBoxPoints) {
            transform.transform(point, point);
        }
        return bBoxPoints;
    }

    private List<Point> clipBBox(List<Point> points, Point clipLineBeg, Point clipLineEnd) {
        ArrayList<Point> filteredPoints = new ArrayList<Point>();
        boolean prevOnRightSide = false;
        Point filteringPoint = points.get(0);
        if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
            filteredPoints.add(filteringPoint);
            prevOnRightSide = true;
        }
        Point prevPoint = filteringPoint;
        for (int i = 1; i < points.size() + 1; ++i) {
            filteringPoint = points.get(i % points.size());
            if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
                if (!prevOnRightSide) {
                    filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
                }
                filteredPoints.add(filteringPoint);
                prevOnRightSide = true;
            } else if (prevOnRightSide) {
                filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
            }
            prevPoint = filteringPoint;
        }
        return filteredPoints;
    }

    private int checkPointSide(Point filteredPoint, Point clipLineBeg, Point clipLineEnd) {
        double y1;
        double x2;
        double y2;
        double x1 = filteredPoint.getX() - clipLineBeg.getX();
        double sgn = x1 * (y2 = clipLineEnd.getY() - clipLineBeg.getY()) - (x2 = clipLineEnd.getX() - clipLineBeg.getX()) * (y1 = filteredPoint.getY() - clipLineBeg.getY());
        if (Math.abs(sgn) < 0.001) {
            return 0;
        }
        if (sgn > 0.0) {
            return 1;
        }
        if (sgn < 0.0) {
            return -1;
        }
        return 0;
    }

    private Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }
}

