/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.color.DeviceRgb;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNull;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfStructElem;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.layout.border.Border;
import com.fr.third.fr.pdf.layout.element.Cell;
import com.fr.third.fr.pdf.layout.element.List;
import com.fr.third.fr.pdf.layout.property.HorizontalAlignment;
import com.fr.third.fr.pdf.layout.property.ListNumberingType;
import com.fr.third.fr.pdf.layout.property.TextAlignment;
import com.fr.third.fr.pdf.layout.property.Underline;
import com.fr.third.fr.pdf.layout.renderer.AbstractRenderer;

public class AccessibleAttributesApplier {
    public static void applyLayoutAttributes(PdfName role, AbstractRenderer renderer, PdfDocument doc) {
        if (!(renderer.getModelElement() instanceof IAccessibleElement)) {
            return;
        }
        int tagType = PdfStructElem.identifyType(doc, role);
        PdfDictionary attributes = new PdfDictionary();
        PdfName attributesType = PdfName.Layout;
        attributes.put(PdfName.O, attributesType);
        PdfDictionary roleMap = doc.getStructTreeRoot().getRoleMap();
        if (roleMap.containsKey(role)) {
            role = roleMap.getAsName(role);
        }
        AccessibleAttributesApplier.applyCommonLayoutAttributes(renderer, attributes);
        if (tagType == PdfStructElem.BlockLevel) {
            AccessibleAttributesApplier.applyBlockLevelLayoutAttributes(role, renderer, attributes, doc);
        }
        if (tagType == PdfStructElem.InlineLevel) {
            AccessibleAttributesApplier.applyInlineLevelLayoutAttributes(renderer, attributes);
        }
        if (tagType == PdfStructElem.Illustration) {
            AccessibleAttributesApplier.applyIllustrationLayoutAttributes(renderer, attributes);
        }
        if (attributes.size() > 1) {
            AccessibilityProperties properties = ((IAccessibleElement)((Object)renderer.getModelElement())).getAccessibilityProperties();
            AccessibleAttributesApplier.removeSameAttributesTypeIfPresent(properties, attributesType);
            properties.addAttributes(attributes);
        }
    }

    public static void applyListAttributes(AbstractRenderer renderer) {
        if (!(renderer.getModelElement() instanceof List)) {
            return;
        }
        PdfDictionary attributes = new PdfDictionary();
        PdfName attributesType = PdfName.List;
        attributes.put(PdfName.O, attributesType);
        Object listSymbol = renderer.getProperty(37);
        if (listSymbol instanceof ListNumberingType) {
            ListNumberingType numberingType = (ListNumberingType)((Object)listSymbol);
            attributes.put(PdfName.ListNumbering, AccessibleAttributesApplier.transformNumberingTypeToName(numberingType));
        }
        if (attributes.size() > 1) {
            AccessibilityProperties properties = ((IAccessibleElement)((Object)renderer.getModelElement())).getAccessibilityProperties();
            AccessibleAttributesApplier.removeSameAttributesTypeIfPresent(properties, attributesType);
            properties.addAttributes(attributes);
        }
    }

    public static void applyTableAttributes(AbstractRenderer renderer) {
        if (!(renderer.getModelElement() instanceof IAccessibleElement)) {
            return;
        }
        IAccessibleElement accessibleElement = (IAccessibleElement)((Object)renderer.getModelElement());
        PdfDictionary attributes = new PdfDictionary();
        PdfName attributesType = PdfName.Table;
        attributes.put(PdfName.O, attributesType);
        if (accessibleElement instanceof Cell) {
            Cell cell = (Cell)accessibleElement;
            if (cell.getRowspan() != 1) {
                attributes.put(PdfName.RowSpan, new PdfNumber(cell.getRowspan()));
            }
            if (cell.getColspan() != 1) {
                attributes.put(PdfName.ColSpan, new PdfNumber(cell.getColspan()));
            }
        }
        if (attributes.size() > 1) {
            AccessibilityProperties properties = accessibleElement.getAccessibilityProperties();
            AccessibleAttributesApplier.removeSameAttributesTypeIfPresent(properties, attributesType);
            properties.addAttributes(attributes);
        }
    }

    private static void applyCommonLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        if (!(renderer.getModelElement() instanceof Cell)) {
            AccessibleAttributesApplier.applyBorderAttributes(renderer, attributes);
        }
        AccessibleAttributesApplier.applyPaddingAttribute(renderer, attributes);
        Color color = renderer.getFontColor();
        if (color != null && color instanceof DeviceRgb) {
            attributes.put(PdfName.Color, new PdfArray(color.getColorValue()));
        }
    }

    private static void applyBlockLevelLayoutAttributes(PdfName role, AbstractRenderer renderer, PdfDictionary attributes, PdfDocument doc) {
        boolean connectedToTag;
        boolean elementIsOnSinglePage;
        TextAlignment textAlignment;
        float firstLineIndent;
        float endIndent;
        float startIndent;
        float spaceAfter;
        int[] marginsOrder;
        float[] margins = new float[]{renderer.getPropertyAsFloat(46), renderer.getPropertyAsFloat(43), renderer.getPropertyAsFloat(44), renderer.getPropertyAsFloat(45)};
        float spaceBefore = margins[(marginsOrder = new int[]{0, 1, 2, 3})[0]];
        if (spaceBefore != 0.0f) {
            attributes.put(PdfName.SpaceBefore, new PdfNumber(spaceBefore));
        }
        if ((spaceAfter = margins[marginsOrder[1]]) != 0.0f) {
            attributes.put(PdfName.SpaceAfter, new PdfNumber(spaceAfter));
        }
        if ((startIndent = margins[marginsOrder[2]]) != 0.0f) {
            attributes.put(PdfName.StartIndent, new PdfNumber(startIndent));
        }
        if ((endIndent = margins[marginsOrder[3]]) != 0.0f) {
            attributes.put(PdfName.EndIndent, new PdfNumber(endIndent));
        }
        if ((firstLineIndent = renderer.getPropertyAsFloat(18)) != 0.0f) {
            attributes.put(PdfName.TextIndent, new PdfNumber(firstLineIndent));
        }
        if ((textAlignment = renderer.getTextAlignment()) != null && !role.equals(PdfName.TH) && !role.equals(PdfName.TD)) {
            attributes.put(PdfName.TextAlign, AccessibleAttributesApplier.transformTextAlignmentValueToName(textAlignment));
        }
        boolean bl = elementIsOnSinglePage = !(connectedToTag = doc.getTagStructureContext().isElementConnectedToTag((IAccessibleElement)((Object)renderer.getModelElement()))) && renderer.isLastRendererForModelElement;
        if (elementIsOnSinglePage) {
            Rectangle bbox = renderer.getOccupiedArea().getBBox();
            attributes.put(PdfName.BBox, new PdfArray(bbox));
        }
        if (role.equals(PdfName.TH) || role.equals(PdfName.TD) || role.equals(PdfName.Table)) {
            float height;
            float width = renderer.getUnitWidth();
            if (width != 0.0f) {
                attributes.put(PdfName.Width, new PdfNumber(width));
            }
            if ((height = renderer.getPropertyAsFloat(27)) != 0.0f) {
                attributes.put(PdfName.Height, new PdfNumber(height));
            }
        }
        if (role.equals(PdfName.TH) || role.equals(PdfName.TD)) {
            HorizontalAlignment horizontalAlignment = renderer.getHorizontalAlignment();
            if (horizontalAlignment != null) {
                attributes.put(PdfName.BlockAlign, AccessibleAttributesApplier.transformBlockAlignToName(horizontalAlignment));
            }
            if (textAlignment != null && textAlignment != TextAlignment.JUSTIFIED && textAlignment != TextAlignment.JUSTIFIED_ALL) {
                attributes.put(PdfName.InlineAlign, AccessibleAttributesApplier.transformTextAlignmentValueToName(textAlignment));
            }
        }
    }

    private static void applyInlineLevelLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Object underlines = renderer.getUnderLine();
        if (underlines != null) {
            float fontSize = renderer.getFontSize();
            Underline underline = null;
            if (underlines instanceof java.util.List && !((java.util.List)underlines).isEmpty() && ((java.util.List)underlines).get(0) instanceof Underline) {
                underline = (Underline)((java.util.List)underlines).get(0);
            } else if (underlines instanceof Underline) {
                underline = (Underline)underlines;
            }
            if (underline != null) {
                attributes.put(PdfName.TextDecorationType, underline.getYPosition(fontSize) > 0.0f ? PdfName.LineThrough : PdfName.Underline);
                if (underline.getColor() instanceof DeviceRgb) {
                    attributes.put(PdfName.TextDecorationColor, new PdfArray(underline.getColor().getColorValue()));
                }
                attributes.put(PdfName.TextDecorationThickness, new PdfNumber(underline.getThickness(fontSize)));
            }
        }
    }

    private static void applyIllustrationLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Rectangle bbox = renderer.getOccupiedArea().getBBox();
        attributes.put(PdfName.BBox, new PdfArray(bbox));
        float width = renderer.getUnitWidth();
        if (width != 0.0f) {
            attributes.put(PdfName.Width, new PdfNumber(width));
        } else {
            attributes.put(PdfName.Width, new PdfNumber(bbox.getWidth()));
        }
        float height = renderer.getPropertyAsFloat(27);
        if (height != 0.0f) {
            attributes.put(PdfName.Height, new PdfNumber(height));
        } else {
            attributes.put(PdfName.Height, new PdfNumber(bbox.getHeight()));
        }
    }

    private static void applyPaddingAttribute(AbstractRenderer renderer, PdfDictionary attributes) {
        float[] paddings = new float[]{renderer.getPropertyAsFloat(50), renderer.getPropertyAsFloat(49), renderer.getPropertyAsFloat(47), renderer.getPropertyAsFloat(48)};
        PdfObject padding = null;
        if (paddings[0] == paddings[1] && paddings[0] == paddings[2] && paddings[0] == paddings[3]) {
            if (paddings[0] != 0.0f) {
                padding = new PdfNumber(paddings[0]);
            }
        } else {
            int[] paddingsOrder;
            PdfArray paddingArray = new PdfArray();
            for (int i : paddingsOrder = new int[]{0, 1, 2, 3}) {
                paddingArray.add(new PdfNumber(paddings[i]));
            }
            padding = paddingArray;
        }
        if (padding != null) {
            attributes.put(PdfName.Padding, padding);
        }
    }

    private static void applyBorderAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        boolean generalBorderProperties;
        boolean specificBorderProperties = renderer.getTopBorder() != null || renderer.getRightBorder() != null || renderer.getBottomBorder() != null || renderer.getLeftBorder() != null;
        boolean bl = generalBorderProperties = !specificBorderProperties && renderer.getAllBorder() != null;
        if (generalBorderProperties) {
            Border generalBorder = renderer.getAllBorder();
            Color generalBorderColor = generalBorder.getColor();
            int borderType = generalBorder.getType();
            float borderWidth = generalBorder.getWidth();
            if (generalBorderColor instanceof DeviceRgb) {
                attributes.put(PdfName.BorderColor, new PdfArray(generalBorderColor.getColorValue()));
                attributes.put(PdfName.BorderStyle, AccessibleAttributesApplier.transformBorderTypeToName(borderType));
                attributes.put(PdfName.BorderThikness, new PdfNumber(borderWidth));
            }
        }
        if (specificBorderProperties) {
            int[] borderOrder;
            PdfArray borderColors = new PdfArray();
            PdfArray borderTypes = new PdfArray();
            PdfArray borderWidths = new PdfArray();
            boolean atLeastOneRgb = false;
            Border[] borders = renderer.getBorders();
            boolean allColorsEqual = true;
            boolean allTypesEqual = true;
            boolean allWidthsEqual = true;
            for (int i = 1; i < borders.length; ++i) {
                Border border = borders[i];
                if (border == null) continue;
                if (!border.getColor().equals(borders[0].getColor())) {
                    allColorsEqual = false;
                }
                if (border.getWidth() != borders[0].getWidth()) {
                    allWidthsEqual = false;
                }
                if (border.getType() == borders[0].getType()) continue;
                allTypesEqual = false;
            }
            for (int i : borderOrder = new int[]{0, 1, 2, 3}) {
                if (borders[i] != null) {
                    if (borders[i].getColor() instanceof DeviceRgb) {
                        borderColors.add(new PdfArray(borders[i].getColor().getColorValue()));
                        atLeastOneRgb = true;
                    } else {
                        borderColors.add(PdfNull.PDF_NULL);
                    }
                    borderTypes.add(AccessibleAttributesApplier.transformBorderTypeToName(borders[i].getType()));
                    borderWidths.add(new PdfNumber(borders[i].getWidth()));
                    continue;
                }
                borderColors.add(PdfNull.PDF_NULL);
                borderTypes.add(PdfName.None);
                borderWidths.add(PdfNull.PDF_NULL);
            }
            if (atLeastOneRgb) {
                if (allColorsEqual) {
                    attributes.put(PdfName.BorderColor, borderColors.get(0));
                } else {
                    attributes.put(PdfName.BorderColor, borderColors);
                }
            }
            if (allTypesEqual) {
                attributes.put(PdfName.BorderStyle, borderTypes.get(0));
            } else {
                attributes.put(PdfName.BorderStyle, borderTypes);
            }
            if (allWidthsEqual) {
                attributes.put(PdfName.BorderThikness, borderWidths.get(0));
            } else {
                attributes.put(PdfName.BorderThikness, borderWidths);
            }
        }
    }

    private static PdfName transformTextAlignmentValueToName(TextAlignment textAlignment) {
        boolean isLeftToRight = true;
        switch (textAlignment) {
            case LEFT: {
                if (isLeftToRight) {
                    return PdfName.Start;
                }
                return PdfName.End;
            }
            case CENTER: {
                return PdfName.Center;
            }
            case RIGHT: {
                if (isLeftToRight) {
                    return PdfName.End;
                }
                return PdfName.Start;
            }
            case JUSTIFIED: 
            case JUSTIFIED_ALL: {
                return PdfName.Justify;
            }
        }
        return PdfName.Start;
    }

    private static PdfName transformBlockAlignToName(HorizontalAlignment horizontalAlignment) {
        boolean isLeftToRight = true;
        switch (horizontalAlignment) {
            case LEFT: {
                if (isLeftToRight) {
                    return PdfName.Before;
                }
                return PdfName.After;
            }
            case CENTER: {
                return PdfName.Middle;
            }
            case RIGHT: {
                if (isLeftToRight) {
                    return PdfName.After;
                }
                return PdfName.Before;
            }
        }
        return PdfName.Before;
    }

    private static PdfName transformBorderTypeToName(int borderType) {
        switch (borderType) {
            case 0: {
                return PdfName.Solid;
            }
            case 1: {
                return PdfName.Dashed;
            }
            case 2: {
                return PdfName.Dotted;
            }
            case 4: {
                return PdfName.Dotted;
            }
            case 3: {
                return PdfName.Double;
            }
            case 5: {
                return PdfName.Groove;
            }
            case 6: {
                return PdfName.Inset;
            }
            case 7: {
                return PdfName.Outset;
            }
            case 8: {
                return PdfName.Ridge;
            }
        }
        return PdfName.Solid;
    }

    private static PdfName transformNumberingTypeToName(ListNumberingType numberingType) {
        switch (numberingType) {
            case DECIMAL: {
                return PdfName.Decimal;
            }
            case ROMAN_UPPER: {
                return PdfName.UpperRoman;
            }
            case ROMAN_LOWER: {
                return PdfName.LowerRoman;
            }
            case ENGLISH_UPPER: 
            case GREEK_UPPER: {
                return PdfName.UpperAlpha;
            }
            case ENGLISH_LOWER: 
            case GREEK_LOWER: {
                return PdfName.LowerAlpha;
            }
        }
        return PdfName.None;
    }

    private static void removeSameAttributesTypeIfPresent(AccessibilityProperties properties, PdfName attributesType) {
        PdfDictionary attr;
        int i;
        java.util.List<PdfDictionary> attributesList = properties.getAttributesList();
        for (i = 0; i < attributesList.size() && !attributesType.equals((attr = attributesList.get(i)).get(PdfName.O)); ++i) {
        }
        if (i < attributesList.size()) {
            attributesList.remove(i);
        }
    }
}

