/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.property;

import com.fr.third.fr.pdf.kernel.utils.jdk5.JDK5Utils;

public class UnitValue {
    public static final int POINT = 1;
    public static final int PERCENT = 2;
    protected int unitType;
    protected float value;

    public UnitValue(int unitType, float value) {
        this.unitType = unitType;
        this.value = value;
    }

    public static UnitValue createPointValue(float value) {
        return new UnitValue(1, value);
    }

    public static UnitValue createPercentValue(float value) {
        return new UnitValue(2, value);
    }

    public int getUnitType() {
        return this.unitType;
    }

    public void setUnitType(int unitType) {
        this.unitType = unitType;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean isPointValue() {
        return this.unitType == 1;
    }

    public boolean isPercentValue() {
        return this.unitType == 2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitValue)) {
            return false;
        }
        UnitValue other = (UnitValue)obj;
        return JDK5Utils.compare(this.unitType, other.unitType) == 0 && Float.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.unitType;
        hash = 71 * hash + Float.floatToIntBits(this.value);
        return hash;
    }
}

