/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.element;

import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.fr.third.fr.pdf.layout.element.BlockElement;
import com.fr.third.fr.pdf.layout.element.ILeafElement;
import com.fr.third.fr.pdf.layout.element.Image;
import com.fr.third.fr.pdf.layout.element.TabStop;
import com.fr.third.fr.pdf.layout.element.Text;
import com.fr.third.fr.pdf.layout.property.Leading;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.ParagraphRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paragraph
extends BlockElement<Paragraph> {
    protected PdfName role = PdfName.P;
    protected AccessibilityProperties tagProperties;
    private static Float DefaultFirstLine = Float.valueOf(0.0f);
    private static Float DefaultBottom = Float.valueOf(4.0f);
    private static Float DefaultTab = Float.valueOf(50.0f);

    public Paragraph() {
    }

    public Paragraph(String text) {
        this(new Text(text));
    }

    public Paragraph(Text text) {
        this.add(text);
    }

    public Paragraph add(String text) {
        return this.add(new Text(text));
    }

    public Paragraph add(ILeafElement element) {
        this.childElements.add(element);
        return this;
    }

    public <T2 extends ILeafElement> Paragraph addAll(List<T2> elements) {
        for (ILeafElement element : elements) {
            this.add(element);
        }
        return this;
    }

    public Paragraph addTabStops(TabStop ... tabStops) {
        this.addTabStopsAsProperty(Arrays.asList(tabStops));
        return this;
    }

    public Paragraph addTabStops(List<TabStop> tabStops) {
        this.addTabStopsAsProperty(tabStops);
        return this;
    }

    public Paragraph removeTabStop(float tabStopPosition) {
        Map tabStops = (Map)this.getProperty(69);
        if (tabStops != null) {
            tabStops.remove(Float.valueOf(tabStopPosition));
        }
        return this;
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 33: {
                return (T1)new Leading(2, this.childElements.size() == 1 && this.childElements.get(0) instanceof Image ? 1.0f : 1.35f);
            }
            case 18: {
                return (T1)DefaultFirstLine;
            }
            case 43: 
            case 46: {
                return (T1)DefaultBottom;
            }
            case 67: {
                return (T1)DefaultTab;
            }
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        switch (property) {
            case 18: {
                return 0.0f;
            }
            case 43: 
            case 46: {
                return 4.0f;
            }
            case 67: {
                return 50.0f;
            }
        }
        return super.getDefaultFloatProperty(property);
    }

    public Paragraph setFirstLineIndent(float indent) {
        this.setFloatProperty(18, indent);
        return this;
    }

    public Paragraph setFixedLeading(float leading) {
        this.setProperty(33, new Leading(1, leading));
        return this;
    }

    public Paragraph setMultipliedLeading(float leading) {
        this.setProperty(33, new Leading(2, leading));
        return this;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new ParagraphRenderer(this);
    }

    private void addTabStopsAsProperty(List<TabStop> newTabStops) {
        TreeMap<Float, TabStop> tabStops = (TreeMap<Float, TabStop>)this.getProperty(69);
        if (tabStops == null) {
            tabStops = new TreeMap<Float, TabStop>();
            this.setProperty(69, tabStops);
        }
        for (TabStop tabStop : newTabStops) {
            tabStops.put(Float.valueOf(tabStop.getTabPosition()), tabStop);
        }
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
        if (PdfName.Artifact.equals(role)) {
            this.propagateArtifactRoleToChildElements();
        }
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }
}

