/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.border;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;

public abstract class Border {
    public static final Border NO_BORDER = null;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DOUBLE = 3;
    public static final int ROUND_DOTS = 4;
    public static final int _3D_GROOVE = 5;
    public static final int _3D_INSET = 6;
    public static final int _3D_OUTSET = 7;
    public static final int _3D_RIDGE = 8;
    protected Color color;
    protected float width;
    protected int type;
    private int hash;

    protected Border(float width) {
        this(Color.BLACK, width);
    }

    protected Border(Color color, float width) {
        this.color = color;
        this.width = width;
    }

    public abstract void draw(PdfCanvas var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public abstract void drawCellBorder(PdfCanvas var1, float var2, float var3, float var4, float var5);

    public abstract int getType();

    public Color getColor() {
        return this.color;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Border) {
            Border anotherBorder = (Border)anObject;
            return anotherBorder.getType() == this.getType() && anotherBorder.getColor() == this.getColor() && anotherBorder.getWidth() == this.getWidth();
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = (int)this.getWidth() * 31 + this.getColor().hashCode();
        }
        return h;
    }

    protected Side getBorderSide(float x1, float y1, float x2, float y2) {
        boolean isLeft = false;
        boolean isRight = false;
        if (Math.abs(y2 - y1) > 5.0E-4f) {
            isLeft = y2 - y1 > 0.0f;
            isRight = y2 - y1 < 0.0f;
        }
        boolean isTop = false;
        boolean isBottom = false;
        if (Math.abs(x2 - x1) > 5.0E-4f) {
            isTop = x2 - x1 > 0.0f;
            boolean bl = isBottom = x2 - x1 < 0.0f;
        }
        if (isTop) {
            return Side.TOP;
        }
        if (isRight) {
            return Side.RIGHT;
        }
        if (isBottom) {
            return Side.BOTTOM;
        }
        if (isLeft) {
            return Side.LEFT;
        }
        return Side.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Side {
        NONE,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

