/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.layout.IPropertyContainer;
import com.fr.third.fr.pdf.layout.border.Border;
import com.fr.third.fr.pdf.layout.hyphenation.HyphenationConfig;
import com.fr.third.fr.pdf.layout.property.Background;
import com.fr.third.fr.pdf.layout.property.BaseDirection;
import com.fr.third.fr.pdf.layout.property.FontKerning;
import com.fr.third.fr.pdf.layout.property.HorizontalAlignment;
import com.fr.third.fr.pdf.layout.property.TextAlignment;
import com.fr.third.fr.pdf.layout.property.Underline;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import com.fr.third.fr.pdf.layout.renderer.FloatPropertiesMap;
import com.fr.third.fr.pdf.layout.renderer.PropertiesMap;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementPropertyContainer<T extends IPropertyContainer>
implements IPropertyContainer {
    protected PropertiesMap properties = new PropertiesMap();
    protected FloatPropertiesMap floatProperties = new FloatPropertiesMap();
    private static Float DefaultLayoutPosition = new Float(0.0f);
    private static Integer DefaultLayoutPosition2 = 1;
    private boolean italic = false;
    private boolean bold = false;
    private Border border = null;
    private Border topBorder = null;
    private Border rightBorder = null;
    private Border bottomBorder = null;
    private Border leftBorder = null;
    private Background background;
    private TextAlignment alignment;
    private VerticalAlignment verticalAlignment;
    private float width;
    private Color fontColor;
    private Color strokeColor;
    private HorizontalAlignment horizontalAlignment;
    private Object underLine;
    private BaseDirection direction;
    private float font_size;
    private PdfFont font = null;

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public void setFloatProperty(int key, float value) {
        this.floatProperties.put(key, value);
    }

    @Override
    public boolean hasFloatProperty(int key) {
        return this.floatProperties.containsKey(key);
    }

    @Override
    public float getFloatProperty(int key) {
        if (this.floatProperties.containsKey(key)) {
            return this.floatProperties.get(key);
        }
        return this.getDefaultFloatProperty(key);
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        return 0.0f;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    @Override
    public <T1> T1 getProperty(int property) {
        return this.getOwnProperty(property);
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return (T1)DefaultLayoutPosition;
            }
            case 52: {
                return (T1)DefaultLayoutPosition2;
            }
            case 26: {
                return (T1)Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public boolean isITALIC() {
        return this.italic;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public void setITALIC(boolean italic) {
        this.italic = italic;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
    }

    @Override
    public Border getAllBorder() {
        return this.border;
    }

    @Override
    public void setAllBorder(Border border) {
        this.border = border;
    }

    @Override
    public Border getTopBorder() {
        return this.topBorder;
    }

    @Override
    public void setTopBorder(Border topBorder) {
        this.topBorder = topBorder;
    }

    @Override
    public Border getRightBorder() {
        return this.rightBorder;
    }

    @Override
    public void setRightBorder(Border rightBorder) {
        this.rightBorder = rightBorder;
    }

    @Override
    public Border getBottomBorder() {
        return this.bottomBorder;
    }

    @Override
    public void setBottomBorder(Border bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    @Override
    public Border getLeftBorder() {
        return this.leftBorder;
    }

    @Override
    public void setLeftBorder(Border leftBorder) {
        this.leftBorder = leftBorder;
    }

    @Override
    public Border getDefaultBorder() {
        return null;
    }

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Background background) {
        this.background = background;
    }

    @Override
    public TextAlignment getTextAlignment() {
        return this.alignment;
    }

    @Override
    public void setRenderTextAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setRenderVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public float getUnitWidth() {
        return this.width;
    }

    @Override
    public void setUnitWidth(float width) {
        this.width = width;
    }

    @Override
    public void setRenderFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public void setRenderStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    @Override
    public Color getFontColor() {
        return this.fontColor;
    }

    @Override
    public Color getRenderStrokeColor() {
        return this.strokeColor;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setRenderHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Object getUnderLine() {
        return this.underLine;
    }

    @Override
    public void setRenderUnderLine(Object underLine) {
        this.underLine = underLine;
    }

    @Override
    public BaseDirection getBaseDirection() {
        return this.direction;
    }

    @Override
    public BaseDirection getOwnBaseDirection() {
        return this.direction;
    }

    @Override
    public void setRenderBaseDirection(BaseDirection direction) {
        this.direction = direction;
    }

    @Override
    public float getFontSize() {
        if (this.font_size != 0.0f) {
            return this.font_size;
        }
        return 12.0f;
    }

    @Override
    public void setRenderFontSize(float font_size) {
        this.font_size = font_size;
    }

    public float getWidth() {
        return this.getUnitWidth();
    }

    public T setWidth(float width) {
        this.setUnitWidth(width);
        return (T)this;
    }

    public float getHeight() {
        return this.getFloatProperty(27);
    }

    public T setHeight(float height) {
        this.setFloatProperty(27, height);
        return (T)this;
    }

    public T setRelativePosition(float left, float top, float right, float bottom) {
        this.setProperty(52, 2);
        this.setFloatProperty(34, left);
        this.setFloatProperty(54, right);
        this.setFloatProperty(73, top);
        this.setFloatProperty(14, bottom);
        return (T)this;
    }

    public T setFixedPosition(float x, float y, float width) {
        this.setProperty(52, 4);
        this.setFloatProperty(79, x);
        this.setFloatProperty(80, y);
        this.setUnitWidth(width);
        return (T)this;
    }

    public T setFixedPosition(int pageNumber, float x, float y, float width) {
        this.setFixedPosition(x, y, width);
        this.setProperty(51, pageNumber);
        return (T)this;
    }

    public T setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.setRenderHorizontalAlignment(horizontalAlignment);
        return (T)this;
    }

    public T setFont(PdfFont font) {
        this.setPdfFont(font);
        return (T)this;
    }

    @Override
    public void setPdfFont(PdfFont font) {
        this.font = font;
    }

    @Override
    public PdfFont getPdfFont() {
        return this.font;
    }

    public T setFontColor(Color fontColor) {
        this.setRenderFontColor(fontColor);
        return (T)this;
    }

    public T setFontSize(float fontSize) {
        this.setRenderFontSize(fontSize);
        return (T)this;
    }

    public T setTextAlignment(TextAlignment alignment) {
        this.setRenderTextAlignment(alignment);
        return (T)this;
    }

    public T setCharacterSpacing(float charSpacing) {
        this.setFloatProperty(15, charSpacing);
        return (T)this;
    }

    public T setWordSpacing(float wordSpacing) {
        this.setFloatProperty(78, wordSpacing);
        return (T)this;
    }

    public T setFontKerning(FontKerning fontKerning) {
        this.setProperty(22, (Object)fontKerning);
        return (T)this;
    }

    public T setBackgroundColor(Color backgroundColor) {
        return this.setBackgroundColor(backgroundColor, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public T setBackgroundColor(Color backgroundColor, float extraLeft, float extraTop, float extraRight, float extraBottom) {
        this.setBackground(new Background(backgroundColor, extraLeft, extraTop, extraRight, extraBottom));
        return (T)this;
    }

    public T setBorder(Border border) {
        this.setAllBorder(border);
        return (T)this;
    }

    public T setBorderTop(Border border) {
        this.setTopBorder(border);
        return (T)this;
    }

    public T setBorderRight(Border border) {
        this.setRightBorder(border);
        return (T)this;
    }

    public T setBorderBottom(Border border) {
        this.setBottomBorder(border);
        return (T)this;
    }

    public T setBorderLeft(Border border) {
        this.setLeftBorder(border);
        return (T)this;
    }

    public Color getStrokeColor() {
        return this.getRenderStrokeColor();
    }

    public T setStrokeColor(Color strokeColor) {
        this.setRenderStrokeColor(strokeColor);
        return (T)this;
    }

    public float getStrokeWidth() {
        return this.getFloatProperty(64);
    }

    public T setStrokeWidth(float strokeWidth) {
        this.setFloatProperty(64, strokeWidth);
        return (T)this;
    }

    public T setBold() {
        this.setBold(true);
        return (T)this;
    }

    public T setItalic() {
        this.setITALIC(true);
        return (T)this;
    }

    public T setLineThrough() {
        return this.setUnderline(null, 0.75f, 0.0f, 0.0f, 0.29166666f, 0);
    }

    public T setUnderline() {
        return this.setUnderline(null, 0.75f, 0.0f, 0.0f, -0.125f, 0);
    }

    public T setUnderline(float thickness, float yPosition) {
        return this.setUnderline(null, thickness, 0.0f, yPosition, 0.0f, 0);
    }

    public T setUnderline(Color color, float thickness, float thicknessMul, float yPosition, float yPositionMul, int lineCapStyle) {
        Underline newUnderline = new Underline(color, thickness, thicknessMul, yPosition, yPositionMul, lineCapStyle);
        Object currentProperty = this.getUnderLine();
        if (currentProperty instanceof List) {
            ((List)currentProperty).add(newUnderline);
        } else if (currentProperty instanceof Underline) {
            this.setRenderUnderLine(Arrays.asList((Underline)currentProperty, newUnderline));
        } else {
            this.setRenderUnderLine(newUnderline);
        }
        return (T)this;
    }

    public T setBaseDirection(BaseDirection baseDirection) {
        this.setRenderBaseDirection(baseDirection);
        return (T)this;
    }

    public T setHyphenation(HyphenationConfig hyphenationConfig) {
        this.setProperty(30, hyphenationConfig);
        return (T)this;
    }
}

