/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.geom.PageSize;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.layout.RootElement;
import com.fr.third.fr.pdf.layout.element.AreaBreak;
import com.fr.third.fr.pdf.layout.element.BlockElement;
import com.fr.third.fr.pdf.layout.element.IElement;
import com.fr.third.fr.pdf.layout.element.ILargeElement;
import com.fr.third.fr.pdf.layout.renderer.DocumentRenderer;
import com.fr.third.fr.pdf.layout.renderer.RootRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends RootElement<Document> {
    protected float leftMargin = 36.0f;
    protected float rightMargin = 36.0f;
    protected float topMargin = 36.0f;
    protected float bottomMargin = 36.0f;

    public Document(PdfDocument pdfDoc) {
        this(pdfDoc, pdfDoc.getDefaultPageSize());
    }

    public Document(PdfDocument pdfDoc, PageSize pageSize) {
        this(pdfDoc, pageSize, true);
    }

    public Document(PdfDocument pdfDoc, PageSize pageSize, boolean immediateFlush) {
        this.pdfDocument = pdfDoc;
        this.pdfDocument.setDefaultPageSize(pageSize);
        this.immediateFlush = immediateFlush;
    }

    public void close() {
        if (this.rootRenderer != null && !this.immediateFlush) {
            this.rootRenderer.flush();
        }
        this.pdfDocument.close();
    }

    public Document add(AreaBreak areaBreak) {
        this.childElements.add(areaBreak);
        this.ensureRootRendererNotNull().addChild(areaBreak.createRendererSubTree());
        return this;
    }

    @Override
    public <T extends IElement> Document add(BlockElement<T> element) {
        this.checkClosingStatus();
        super.add(element);
        if (element instanceof ILargeElement) {
            ((ILargeElement)((Object)element)).setDocument(this);
            ((ILargeElement)((Object)element)).flushContent();
        }
        return this;
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public void setRenderer(DocumentRenderer documentRenderer) {
        this.rootRenderer = documentRenderer;
    }

    public void flush() {
        this.rootRenderer.flush();
    }

    public void relayout() {
        if (this.immediateFlush) {
            throw new IllegalStateException("Operation not supported with immediate flush");
        }
        try {
            while (this.pdfDocument.getNumberOfPages() > 0) {
                this.pdfDocument.removePage(this.pdfDocument.getNumberOfPages());
            }
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        this.rootRenderer = new DocumentRenderer(this, this.immediateFlush);
        for (IElement element : this.childElements) {
            this.rootRenderer.addChild(element.createRendererSubTree());
        }
    }

    @Override
    protected RootRenderer ensureRootRendererNotNull() {
        if (this.rootRenderer == null) {
            this.rootRenderer = new DocumentRenderer(this, this.immediateFlush);
        }
        return this.rootRenderer;
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(float leftMargin) {
        this.leftMargin = leftMargin;
    }

    public float getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(float rightMargin) {
        this.rightMargin = rightMargin;
    }

    public float getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(float topMargin) {
        this.topMargin = topMargin;
    }

    public float getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(float bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setMargins(float topMargin, float rightMargin, float bottomMargin, float leftMargin) {
        this.setTopMargin(topMargin);
        this.setRightMargin(rightMargin);
        this.setBottomMargin(bottomMargin);
        this.setLeftMargin(leftMargin);
    }

    public Rectangle getPageEffectiveArea(PageSize pageSize) {
        return new Rectangle(pageSize.getLeft() + this.leftMargin, pageSize.getBottom() + this.bottomMargin, pageSize.getWidth() - this.leftMargin - this.rightMargin, pageSize.getHeight() - this.bottomMargin - this.topMargin);
    }

    protected void checkClosingStatus() {
        if (this.getPdfDocument().isClosed()) {
            throw new PdfException("document.was.closed.it.is.impossible.execute.action");
        }
    }
}

