/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.filters;

import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.filters.ASCII85DecodeFilter;
import com.fr.third.fr.pdf.kernel.pdf.filters.ASCIIHexDecodeFilter;
import com.fr.third.fr.pdf.kernel.pdf.filters.CCITTFaxDecodeFilter;
import com.fr.third.fr.pdf.kernel.pdf.filters.DoNothingFilter;
import com.fr.third.fr.pdf.kernel.pdf.filters.FlateDecodeFilter;
import com.fr.third.fr.pdf.kernel.pdf.filters.IFilterHandler;
import com.fr.third.fr.pdf.kernel.pdf.filters.LZWDecodeFilter;
import com.fr.third.fr.pdf.kernel.pdf.filters.RunLengthDecodeFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterHandlers {
    private static final Map<PdfName, IFilterHandler> defaults;

    public static Map<PdfName, IFilterHandler> getDefaultFilterHandlers() {
        return defaults;
    }

    static {
        HashMap<PdfName, IFilterHandler> map = new HashMap<PdfName, IFilterHandler>();
        map.put(PdfName.FlateDecode, new FlateDecodeFilter());
        map.put(PdfName.FL, new FlateDecodeFilter());
        map.put(PdfName.ASCIIHexDecode, new ASCIIHexDecodeFilter());
        map.put(PdfName.AHx, new ASCIIHexDecodeFilter());
        map.put(PdfName.ASCII85Decode, new ASCII85DecodeFilter());
        map.put(PdfName.A85, new ASCII85DecodeFilter());
        map.put(PdfName.LZWDecode, new LZWDecodeFilter());
        map.put(PdfName.CCITTFaxDecode, new CCITTFaxDecodeFilter());
        map.put(PdfName.Crypt, new DoNothingFilter());
        map.put(PdfName.RunLengthDecode, new RunLengthDecodeFilter());
        defaults = Collections.unmodifiableMap(map);
    }
}

