/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.parser.filter;

import com.fr.third.fr.pdf.kernel.geom.LineSegment;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.geom.Vector;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.EventType;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.IEventData;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.filter.IEventFilter;

public class TextRegionEventFilter
implements IEventFilter {
    private final Rectangle filterRect;

    public TextRegionEventFilter(Rectangle filterRect) {
        this.filterRect = filterRect;
    }

    public boolean accept(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            LineSegment segment = renderInfo.getBaseline();
            Vector startPoint = segment.getStartPoint();
            Vector endPoint = segment.getEndPoint();
            float x1 = startPoint.get(0);
            float y1 = startPoint.get(1);
            float x2 = endPoint.get(0);
            float y2 = endPoint.get(1);
            return this.filterRect == null || this.filterRect.intersectsLine(x1, y1, x2, y2);
        }
        return false;
    }
}

