/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.annot;

import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfLineAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -6047928061827404283L;

    public PdfLineAnnotation(Rectangle rect, float[] line) {
        super(rect);
        this.put(PdfName.L, new PdfArray(line));
    }

    public PdfLineAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfName getSubtype() {
        return PdfName.Line;
    }

    public PdfArray getLine() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.L);
    }

    public PdfArray getLineEndingStyles() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.LE);
    }

    public PdfLineAnnotation setLineEndingStyles(PdfArray lineEndingStyles) {
        return (PdfLineAnnotation)this.put(PdfName.LE, lineEndingStyles);
    }

    public float getLeaderLine() {
        PdfNumber n = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.LE);
        return n == null ? 0.0f : n.floatValue();
    }

    public PdfLineAnnotation setLeaderLine(float leaderLine) {
        return (PdfLineAnnotation)this.put(PdfName.LE, new PdfNumber(leaderLine));
    }

    public float getLeaderLineExtension() {
        PdfNumber n = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.LLE);
        return n == null ? 0.0f : n.floatValue();
    }

    public PdfLineAnnotation setLeaderLineExtension(float leaderLineExtension) {
        return (PdfLineAnnotation)this.put(PdfName.LLE, new PdfNumber(leaderLineExtension));
    }

    public float getLeaderLineOffset() {
        PdfNumber n = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.LLO);
        return n == null ? 0.0f : n.floatValue();
    }

    public PdfLineAnnotation setLeaderLineOffset(float leaderLineOffset) {
        return (PdfLineAnnotation)this.put(PdfName.LLO, new PdfNumber(leaderLineOffset));
    }

    public boolean getContentsAsCaption() {
        PdfBoolean b = ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.Cap);
        return b != null && b.getValue();
    }

    public PdfLineAnnotation setContentsAsCaption(boolean contentsAsCaption) {
        return (PdfLineAnnotation)this.put(PdfName.Cap, new PdfBoolean(contentsAsCaption));
    }

    public PdfName getCaptionPosition() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.CP);
    }

    public PdfLineAnnotation setCaptionPosition(PdfName captionPosition) {
        return (PdfLineAnnotation)this.put(PdfName.CP, captionPosition);
    }

    public PdfDictionary getMeasure() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Measure);
    }

    public PdfLineAnnotation setMeasure(PdfDictionary measure) {
        return (PdfLineAnnotation)this.put(PdfName.Measure, measure);
    }

    public PdfArray getCaptionOffset() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CO);
    }

    public PdfLineAnnotation setCaptionOffset(PdfArray captionOffset) {
        return (PdfLineAnnotation)this.put(PdfName.CO, captionOffset);
    }

    public PdfLineAnnotation setCaptionOffset(float[] captionOffset) {
        return this.setCaptionOffset(new PdfArray(captionOffset));
    }
}

