/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.source.ByteArrayOutputStream;
import com.fr.third.fr.pdf.io.source.ByteUtils;
import com.fr.third.fr.pdf.io.source.DeflaterOutputStream;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.crypto.OutputStreamEncryption;
import com.fr.third.fr.pdf.kernel.pdf.ByteBufferOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfEncryption;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfLiteral;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNull;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfPrimitiveObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.filters.FlateDecodeFilter;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfOutputStream
extends com.fr.third.fr.pdf.io.source.OutputStream<PdfOutputStream> {
    private static final long serialVersionUID = -548180479472231600L;
    private static final byte[] stream = ByteUtils.getIsoBytes("stream\n");
    private static final byte[] endstream = ByteUtils.getIsoBytes("\nendstream");
    private static final byte[] openDict = ByteUtils.getIsoBytes("<<");
    private static final byte[] closeDict = ByteUtils.getIsoBytes(">>");
    private static final byte[] endIndirect = ByteUtils.getIsoBytes(" R");
    private static final byte[] endIndirectWithZeroGenNr = ByteUtils.getIsoBytes(" 0 R");
    private byte[] duplicateContentBuffer = null;
    protected PdfDocument document = null;
    protected PdfEncryption crypto;

    public PdfOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public PdfOutputStream write(PdfObject pdfObject) {
        if (pdfObject.checkState((short)64) && this.document != null) {
            pdfObject.makeIndirect(this.document);
            pdfObject = pdfObject.getIndirectReference();
        }
        if (pdfObject.checkState((short)256)) {
            throw new PdfException("Cannot write object after it was released. In normal situation the object must be read once again before being written");
        }
        switch (pdfObject.getType()) {
            case 1: {
                this.write((PdfArray)pdfObject);
                break;
            }
            case 3: {
                this.write((PdfDictionary)pdfObject);
                break;
            }
            case 5: {
                this.write((PdfIndirectReference)pdfObject);
                break;
            }
            case 6: {
                this.write((PdfName)pdfObject);
                break;
            }
            case 2: 
            case 7: {
                this.write((PdfPrimitiveObject)pdfObject);
                break;
            }
            case 4: {
                this.write((PdfLiteral)pdfObject);
                break;
            }
            case 10: {
                this.write((PdfString)pdfObject);
                break;
            }
            case 8: {
                this.write((PdfNumber)pdfObject);
                break;
            }
            case 9: {
                this.write((PdfStream)pdfObject);
            }
        }
        return this;
    }

    private void write(PdfArray pdfArray) {
        this.writeByte(91);
        for (int i = 0; i < pdfArray.size(); ++i) {
            PdfObject value = pdfArray.get(i, false);
            PdfIndirectReference indirectReference = value.getIndirectReference();
            if (indirectReference != null) {
                this.write(indirectReference);
            } else {
                this.write(value);
            }
            if (i >= pdfArray.size() - 1) continue;
            this.writeSpace();
        }
        this.writeByte(93);
    }

    private void write(PdfDictionary pdfDictionary) {
        this.writeBytes(openDict);
        for (Map.Entry<PdfName, PdfObject> entry : pdfDictionary.entrySet()) {
            PdfIndirectReference indirectReference;
            boolean isAlreadyWriteSpace = false;
            this.write(entry.getKey());
            PdfObject value = entry.getValue();
            if (value == null) {
                Logger logger = LoggerFactory.getLogger(PdfOutputStream.class);
                logger.warn(MessageFormat.format("Invalid key value: key {0} has null value.", entry.getKey()));
                value = PdfNull.PDF_NULL;
            }
            if (value.getType() == 8 || value.getType() == 4 || value.getType() == 2 || value.getType() == 7 || value.getType() == 5 || value.checkState((short)64)) {
                isAlreadyWriteSpace = true;
                this.writeSpace();
            }
            if ((indirectReference = value.getIndirectReference()) != null) {
                if (!isAlreadyWriteSpace) {
                    this.writeSpace();
                }
                this.write(indirectReference);
                continue;
            }
            this.write(value);
        }
        this.writeBytes(closeDict);
    }

    private void write(PdfIndirectReference indirectReference) {
        if (this.document != null && !indirectReference.getDocument().equals(this.document)) {
            throw new PdfException("pdf.inderect.object.belong.to.other.pdf.document.Copy.object.to.current.pdf.document");
        }
        if (indirectReference.getRefersTo() == null) {
            this.write(PdfNull.PDF_NULL);
        } else if (indirectReference.getGenNumber() == 0) {
            ((PdfOutputStream)this.writeInteger(indirectReference.getObjNumber())).writeBytes(endIndirectWithZeroGenNr);
        } else {
            ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)this.writeInteger(indirectReference.getObjNumber())).writeSpace()).writeInteger(indirectReference.getGenNumber())).writeBytes(endIndirect);
        }
    }

    private void write(PdfPrimitiveObject pdfPrimitive) {
        this.writeBytes(pdfPrimitive.getInternalContent());
    }

    private void write(PdfLiteral literal) {
        literal.setPosition(this.getCurrentPos());
        this.writeBytes(literal.getInternalContent());
    }

    private void write(PdfString pdfString) {
        pdfString.encrypt(this.crypto);
        if (pdfString.isHexWriting()) {
            this.writeByte(60);
            this.writeBytes(pdfString.getInternalContent());
            this.writeByte(62);
        } else {
            this.writeByte(40);
            this.writeBytes(pdfString.getInternalContent());
            this.writeByte(41);
        }
    }

    private void write(PdfName name) {
        this.writeByte(47);
        this.writeBytes(name.getInternalContent());
    }

    private void write(PdfNumber pdfNumber) {
        if (pdfNumber.hasContent()) {
            this.writeBytes(pdfNumber.getInternalContent());
        } else if (pdfNumber.isDoubleNumber()) {
            this.writeDouble(pdfNumber.getValue());
        } else {
            this.writeInteger(pdfNumber.intValue());
        }
    }

    private boolean isNotMetadataPdfStream(PdfStream pdfStream) {
        return pdfStream.getAsName(PdfName.Type) == null || pdfStream.getAsName(PdfName.Type) != null && !pdfStream.getAsName(PdfName.Type).equals(PdfName.Metadata);
    }

    private void write(PdfStream pdfStream) {
        block23: {
            try {
                ByteBufferOutputStream byteArrayStream;
                boolean allowCompression;
                boolean userDefinedCompression;
                boolean bl = userDefinedCompression = pdfStream.getCompressionLevel() != Integer.MIN_VALUE;
                if (!userDefinedCompression) {
                    int defaultCompressionLevel = this.document != null ? this.document.getWriter().getCompressionLevel() : -1;
                    pdfStream.setCompressionLevel(defaultCompressionLevel);
                }
                boolean toCompress = pdfStream.getCompressionLevel() != 0;
                boolean bl2 = allowCompression = !pdfStream.containsKey(PdfName.Filter) && this.isNotMetadataPdfStream(pdfStream);
                if (pdfStream.getInputStream() != null) {
                    int n;
                    OutputStream fout = this;
                    DeflaterOutputStream def = null;
                    OutputStreamEncryption ose = null;
                    if (this.crypto != null && !this.crypto.isEmbeddedFilesOnly()) {
                        ose = this.crypto.getEncryptionStream(fout);
                        fout = ose;
                    }
                    if (toCompress && (allowCompression || userDefinedCompression)) {
                        this.updateCompressionFilter(pdfStream);
                        def = new DeflaterOutputStream(fout, pdfStream.getCompressionLevel(), 32768);
                        fout = def;
                    }
                    this.write((PdfDictionary)pdfStream);
                    this.writeBytes(stream);
                    long beginStreamContent = this.getCurrentPos();
                    byte[] buf = new byte[4192];
                    while ((n = pdfStream.getInputStream().read(buf)) > 0) {
                        fout.write(buf, 0, n);
                    }
                    if (def != null) {
                        def.finish();
                    }
                    if (ose != null) {
                        ose.finish();
                    }
                    PdfNumber length = pdfStream.getAsNumber(PdfName.Length);
                    length.setValue((int)(this.getCurrentPos() - beginStreamContent));
                    pdfStream.updateLength(length.intValue());
                    this.writeBytes(endstream);
                    break block23;
                }
                if (pdfStream.getOutputStream() == null && pdfStream.getIndirectReference().getReader() != null) {
                    byte[] bytes = pdfStream.getIndirectReference().getReader().readStreamBytes(pdfStream, false);
                    if (userDefinedCompression) {
                        bytes = this.decodeFlateBytes(pdfStream, bytes);
                    }
                    pdfStream.initOutputStream(new ByteArrayOutputStream(bytes.length));
                    pdfStream.getOutputStream().write(bytes);
                }
                assert (pdfStream.getOutputStream() != null) : "PdfStream lost OutputStream";
                try {
                    if (toCompress && !this.containsFlateFilter(pdfStream) && (allowCompression || userDefinedCompression)) {
                        this.updateCompressionFilter(pdfStream);
                        byteArrayStream = new ByteBufferOutputStream();
                        DeflaterOutputStream zip = new DeflaterOutputStream((OutputStream)byteArrayStream, pdfStream.getCompressionLevel());
                        if (pdfStream instanceof PdfObjectStream) {
                            PdfObjectStream objectStream = (PdfObjectStream)pdfStream;
                            ((ByteBufferOutputStream)objectStream.getIndexStream().getOutputStream()).writeTo(zip);
                            ((ByteBufferOutputStream)objectStream.getOutputStream().getOutputStream()).writeTo(zip);
                        } else {
                            assert (pdfStream.getOutputStream() != null) : "Error in outputStream";
                            ((ByteBufferOutputStream)pdfStream.getOutputStream().getOutputStream()).writeTo(zip);
                        }
                        zip.close();
                    } else if (pdfStream instanceof PdfObjectStream) {
                        PdfObjectStream objectStream = (PdfObjectStream)pdfStream;
                        byteArrayStream = new ByteBufferOutputStream();
                        ((ByteBufferOutputStream)objectStream.getIndexStream().getOutputStream()).writeTo(byteArrayStream);
                        ((ByteBufferOutputStream)objectStream.getOutputStream().getOutputStream()).writeTo(byteArrayStream);
                    } else {
                        assert (pdfStream.getOutputStream() != null) : "Error in outputStream";
                        byteArrayStream = (ByteBufferOutputStream)pdfStream.getOutputStream().getOutputStream();
                    }
                    if (this.checkEncryption(pdfStream)) {
                        ByteBufferOutputStream encodedStream = new ByteBufferOutputStream();
                        OutputStreamEncryption ose = this.crypto.getEncryptionStream(encodedStream);
                        byteArrayStream.writeTo(ose);
                        ose.finish();
                        byteArrayStream = encodedStream;
                    }
                }
                catch (IOException ioe) {
                    throw new PdfException("io.exception", ioe);
                }
                pdfStream.put(PdfName.Length, new PdfNumber(byteArrayStream.size()));
                pdfStream.updateLength(byteArrayStream.size());
                this.write((PdfDictionary)pdfStream);
                this.writeBytes(stream);
                byteArrayStream.writeTo(this);
                this.writeBytes(endstream);
            }
            catch (IOException e) {
                throw new PdfException("cannot.write.pdf.stream", e, pdfStream);
            }
        }
    }

    protected boolean checkEncryption(PdfStream pdfStream) {
        if (this.crypto == null || this.crypto.isEmbeddedFilesOnly()) {
            return false;
        }
        PdfObject filter = pdfStream.get(PdfName.Filter, true);
        if (filter != null) {
            PdfArray filters;
            if (PdfName.Crypt.equals(filter)) {
                return false;
            }
            if (filter.getType() == 1 && !(filters = (PdfArray)filter).isEmpty() && PdfName.Crypt.equals(filters.get(0, true))) {
                return false;
            }
        }
        return true;
    }

    protected boolean containsFlateFilter(PdfStream pdfStream) {
        PdfObject filter = pdfStream.get(PdfName.Filter);
        if (filter != null) {
            if (filter.getType() == 6) {
                if (PdfName.FlateDecode.equals(filter)) {
                    return true;
                }
            } else if (filter.getType() == 1) {
                if (((PdfArray)filter).contains(PdfName.FlateDecode)) {
                    return true;
                }
            } else {
                throw new PdfException("filter.is.not.a.name.or.array");
            }
        }
        return false;
    }

    protected void updateCompressionFilter(PdfStream pdfStream) {
        PdfObject filter = pdfStream.get(PdfName.Filter);
        if (filter == null) {
            pdfStream.put(PdfName.Filter, PdfName.FlateDecode);
        } else {
            PdfArray filters = new PdfArray();
            filters.add(PdfName.FlateDecode);
            if (filter instanceof PdfArray) {
                filters.addAll((PdfArray)filter);
            } else {
                filters.add(filter);
            }
            PdfObject decodeParms = pdfStream.get(PdfName.DecodeParms);
            if (decodeParms != null) {
                if (decodeParms instanceof PdfDictionary) {
                    PdfArray array = new PdfArray();
                    array.add(new PdfNull());
                    array.add(decodeParms);
                    pdfStream.put(PdfName.DecodeParms, array);
                } else if (decodeParms instanceof PdfArray) {
                    ((PdfArray)decodeParms).add(0, new PdfNull());
                } else {
                    throw new PdfException("decode.parameter.type {0} is.not.supported").setMessageParams(decodeParms.getClass().toString());
                }
            }
            pdfStream.put(PdfName.Filter, filters);
        }
    }

    protected byte[] decodeFlateBytes(PdfStream stream, byte[] bytes) {
        PdfDictionary decodeParams;
        PdfName filterName;
        PdfObject filterObject = stream.get(PdfName.Filter);
        if (filterObject == null) {
            return bytes;
        }
        PdfArray filtersArray = null;
        if (filterObject instanceof PdfName) {
            filterName = (PdfName)filterObject;
        } else if (filterObject instanceof PdfArray) {
            filtersArray = (PdfArray)filterObject;
            filterName = filtersArray.getAsName(0);
        } else {
            throw new PdfException("filter.is.not.a.name.or.array");
        }
        if (!PdfName.FlateDecode.equals(filterName)) {
            return bytes;
        }
        PdfArray decodeParamsArray = null;
        PdfObject decodeParamsObject = stream.get(PdfName.DecodeParms);
        if (decodeParamsObject == null) {
            decodeParams = null;
        } else if (decodeParamsObject.getType() == 3) {
            decodeParams = (PdfDictionary)decodeParamsObject;
        } else if (decodeParamsObject.getType() == 1) {
            decodeParamsArray = (PdfArray)decodeParamsObject;
            decodeParams = decodeParamsArray.getAsDictionary(0);
        } else {
            throw new PdfException("decode.parameter.type {0} is.not.supported").setMessageParams(decodeParamsObject.getClass().toString());
        }
        byte[] res = FlateDecodeFilter.flateDecode(bytes, true);
        if (res == null) {
            res = FlateDecodeFilter.flateDecode(bytes, false);
        }
        bytes = FlateDecodeFilter.decodePredictor(res, decodeParams);
        filterObject = null;
        if (filtersArray != null) {
            filtersArray.remove(0);
            if (filtersArray.size() == 1) {
                filterObject = filtersArray.get(0);
            } else if (!filtersArray.isEmpty()) {
                filterObject = filtersArray;
            }
        }
        decodeParamsObject = null;
        if (decodeParamsArray != null) {
            decodeParamsArray.remove(0);
            if (decodeParamsArray.size() == 1 && decodeParamsArray.get(0).getType() != 7) {
                decodeParamsObject = decodeParamsArray.get(0);
            } else if (!decodeParamsArray.isEmpty()) {
                decodeParamsObject = decodeParamsArray;
            }
        }
        if (filterObject == null) {
            stream.remove(PdfName.Filter);
        } else {
            stream.put(PdfName.Filter, filterObject);
        }
        if (decodeParamsObject == null) {
            stream.remove(PdfName.DecodeParms);
        } else {
            stream.put(PdfName.DecodeParms, decodeParamsObject);
        }
        return bytes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.outputStream == null && this.duplicateContentBuffer != null) {
            this.outputStream = new ByteArrayOutputStream();
            this.write(this.duplicateContentBuffer);
            this.duplicateContentBuffer = null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        OutputStream tempOutputStream = this.outputStream;
        if (this.outputStream instanceof java.io.ByteArrayOutputStream) {
            this.duplicateContentBuffer = ((java.io.ByteArrayOutputStream)this.outputStream).toByteArray();
        }
        this.outputStream = null;
        out.defaultWriteObject();
        this.outputStream = tempOutputStream;
    }
}

