/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.pdf.PdfDate;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfDocumentInfo
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -21957940280527123L;

    public PdfDocumentInfo(PdfDictionary pdfObject, PdfDocument pdfDocument) {
        super(pdfObject == null ? new PdfDictionary() : pdfObject);
        if (pdfDocument.getWriter() != null) {
            ((PdfDictionary)this.getPdfObject()).makeIndirect(pdfDocument);
        }
        this.setForbidRelease();
    }

    public PdfDocumentInfo(PdfDictionary pdfObject) {
        this(pdfObject, null);
    }

    public PdfDocumentInfo(PdfDocument pdfDocument) {
        this(new PdfDictionary(), pdfDocument);
    }

    public PdfDocumentInfo setTitle(String title) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Title, new PdfString(title, "UnicodeBig"));
        return this;
    }

    public PdfDocumentInfo setAuthor(String author) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Author, new PdfString(author, "UnicodeBig"));
        return this;
    }

    public PdfDocumentInfo setSubject(String subject) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Subject, new PdfString(subject, "UnicodeBig"));
        return this;
    }

    public PdfDocumentInfo setKeywords(String keywords) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Keywords, new PdfString(keywords, "UnicodeBig"));
        return this;
    }

    public PdfDocumentInfo setCreator(String creator) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Creator, new PdfString(creator, "UnicodeBig"));
        return this;
    }

    public String getTitle() {
        return this.getStringValue(PdfName.Title);
    }

    public String getAuthor() {
        return this.getStringValue(PdfName.Author);
    }

    public String getSubject() {
        return this.getStringValue(PdfName.Subject);
    }

    public String getKeywords() {
        return this.getStringValue(PdfName.Keywords);
    }

    public String getCreator() {
        return this.getStringValue(PdfName.Creator);
    }

    public String getProducer() {
        return this.getStringValue(PdfName.Producer);
    }

    public PdfDocumentInfo addCreationDate() {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.CreationDate, (PdfObject)new PdfDate().getPdfObject());
        return this;
    }

    public PdfDocumentInfo addModDate() {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ModDate, (PdfObject)new PdfDate().getPdfObject());
        return this;
    }

    public void setMoreInfo(Map<String, String> moreInfo) {
        if (moreInfo != null) {
            for (Map.Entry<String, String> entry : moreInfo.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.setMoreInfo(key, value);
            }
        }
    }

    public void setMoreInfo(String key, String value) {
        PdfName keyName = new PdfName(key);
        if (value == null) {
            ((PdfDictionary)this.getPdfObject()).remove(keyName);
        } else {
            ((PdfDictionary)this.getPdfObject()).put(keyName, new PdfString(value, "UnicodeBig"));
        }
    }

    @Override
    public void flush() {
        ((PdfDictionary)this.getPdfObject()).flush(false);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private String getStringValue(PdfName name) {
        PdfString pdfString = ((PdfDictionary)this.getPdfObject()).getAsString(name);
        return pdfString != null ? pdfString.toUnicodeString() : null;
    }
}

