/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.source.ByteUtils;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPrimitiveObject;

public class PdfBoolean
extends PdfPrimitiveObject {
    private static final long serialVersionUID = -1363839858135046832L;
    public static final PdfBoolean TRUE = new PdfBoolean(true, true);
    public static final PdfBoolean FALSE = new PdfBoolean(false, true);
    private static final byte[] True = ByteUtils.getIsoBytes("true");
    private static final byte[] False = ByteUtils.getIsoBytes("false");
    private boolean value;

    public PdfBoolean(boolean value) {
        this(value, false);
    }

    private PdfBoolean(boolean value, boolean directOnly) {
        super(directOnly);
        this.value = value;
    }

    private PdfBoolean() {
    }

    public boolean getValue() {
        return this.value;
    }

    public byte getType() {
        return 2;
    }

    public PdfBoolean makeIndirect(PdfDocument document) {
        return (PdfBoolean)super.makeIndirect(document);
    }

    public PdfBoolean makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfBoolean)super.makeIndirect(document, reference);
    }

    public PdfBoolean copyTo(PdfDocument document) {
        return (PdfBoolean)super.copyTo(document, true);
    }

    public PdfBoolean copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfBoolean)super.copyTo(document, allowDuplicating);
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    protected void generateContent() {
        this.content = this.value ? True : False;
    }

    protected PdfBoolean newInstance() {
        return new PdfBoolean();
    }

    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfBoolean bool = (PdfBoolean)from;
        this.value = bool.value;
    }
}

