/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.otf;

import com.fr.third.fr.pdf.io.font.otf.FeatureRecord;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeFontTableReader;
import com.fr.third.fr.pdf.io.font.otf.TagAndLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTypeFeature {
    private OpenTypeFontTableReader openTypeReader;
    private List<FeatureRecord> records;

    public OpenTypeFeature(OpenTypeFontTableReader openTypeReader, int locationFeatureTable) throws IOException {
        TagAndLocation[] tagsLocs;
        this.openTypeReader = openTypeReader;
        this.records = new ArrayList<FeatureRecord>();
        openTypeReader.rf.seek(locationFeatureTable);
        for (TagAndLocation tagLoc : tagsLocs = openTypeReader.readTagAndLocations(locationFeatureTable)) {
            openTypeReader.rf.seek(tagLoc.location + 2);
            int lookupCount = openTypeReader.rf.readUnsignedShort();
            FeatureRecord rec = new FeatureRecord();
            rec.tag = tagLoc.tag;
            rec.lookups = openTypeReader.readUShortArray(lookupCount);
            this.records.add(rec);
        }
    }

    public List<FeatureRecord> getRecords() {
        return this.records;
    }

    public FeatureRecord getRecord(int idx) {
        if (idx < 0 || idx >= this.records.size()) {
            return null;
        }
        return this.records.get(idx);
    }
}

