/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.font.CidFontProperties;
import com.fr.third.fr.pdf.io.font.FontCache;
import com.fr.third.fr.pdf.io.font.FontProgram;
import com.fr.third.fr.pdf.io.font.cmap.CMapCidUni;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.util.IntHashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CidFont
extends FontProgram {
    private static final long serialVersionUID = 5444988003799502179L;
    private int pdfFontFlags;
    private Set<String> compatibleCmaps;

    CidFont(String fontName, Set<String> cmaps) {
        this.compatibleCmaps = cmaps;
        this.initializeCidFontNameAndStyle(fontName);
        Map<String, Object> fontDesc = CidFontProperties.getAllFonts().get(this.fontNames.getFontName());
        if (fontDesc == null) {
            throw new IOException("no.such.predefined.font.1").setMessageParams(fontName);
        }
        this.initializeCidFontProperties(fontDesc);
    }

    CidFont(String fontName, Set<String> cmaps, Map<String, Object> fontDescription) {
        this.initializeCidFontNameAndStyle(fontName);
        this.initializeCidFontProperties(fontDescription);
        this.compatibleCmaps = cmaps;
    }

    public boolean compatibleWith(String cmap) {
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            return true;
        }
        return this.compatibleCmaps != null && this.compatibleCmaps.contains(cmap);
    }

    @Override
    public int getKerning(Glyph glyph1, Glyph glyph2) {
        return 0;
    }

    @Override
    public int getPdfFontFlags() {
        return this.pdfFontFlags;
    }

    @Override
    public boolean isFontSpecific() {
        return false;
    }

    private void initializeCidFontNameAndStyle(String fontName) {
        String nameBase = CidFont.getBaseName(fontName);
        if (nameBase.length() < fontName.length()) {
            this.fontNames.setFontName(fontName);
            this.fontNames.setStyle(fontName.substring(nameBase.length()));
        } else {
            this.fontNames.setFontName(fontName);
        }
    }

    private void initializeCidFontProperties(Map<String, Object> fontDesc) {
        this.fontIdentification.setPanose((String)fontDesc.get("Panose"));
        this.fontMetrics.setItalicAngle(Integer.parseInt((String)fontDesc.get("ItalicAngle")));
        this.fontMetrics.setCapHeight(Integer.parseInt((String)fontDesc.get("CapHeight")));
        this.fontMetrics.setTypoAscender(Integer.parseInt((String)fontDesc.get("Ascent")));
        this.fontMetrics.setTypoDescender(Integer.parseInt((String)fontDesc.get("Descent")));
        this.fontMetrics.setStemV(Integer.parseInt((String)fontDesc.get("StemV")));
        this.pdfFontFlags = Integer.parseInt((String)fontDesc.get("Flags"));
        String fontBBox = (String)fontDesc.get("FontBBox");
        StringTokenizer tk = new StringTokenizer(fontBBox, " []\r\n\t\f");
        Integer llx = Integer.parseInt(tk.nextToken());
        Integer lly = Integer.parseInt(tk.nextToken());
        Integer urx = Integer.parseInt(tk.nextToken());
        Integer ury = Integer.parseInt(tk.nextToken());
        this.fontMetrics.updateBbox(llx.intValue(), lly.intValue(), urx.intValue(), ury.intValue());
        this.registry = (String)fontDesc.get("Registry");
        String uniMap = CidFont.getCompatibleUniMap(this.registry);
        if (uniMap != null) {
            IntHashtable metrics = (IntHashtable)fontDesc.get("W");
            CMapCidUni cid2Uni = FontCache.getCid2UniCmap(uniMap);
            this.avgWidth = 0;
            for (int cid : cid2Uni.getCids()) {
                int uni = cid2Uni.lookup(cid);
                int width = metrics.containsKey(cid) ? metrics.get(cid) : 1000;
                Glyph glyph = new Glyph(cid, width, uni);
                this.avgWidth += glyph.getWidth();
                this.codeToGlyph.put(cid, glyph);
                this.unicodeToGlyph.put(uni, glyph);
            }
            this.fixSpaceIssue();
            if (this.codeToGlyph.size() != 0) {
                this.avgWidth /= this.codeToGlyph.size();
            }
        }
    }

    private static String getCompatibleUniMap(String registry) {
        String uniMap = "";
        Iterator<String> iterator = CidFontProperties.getRegistryNames().get(registry + "_Uni").iterator();
        while (iterator.hasNext()) {
            String name;
            uniMap = name = iterator.next();
            if (!name.endsWith("H")) continue;
            break;
        }
        return uniMap;
    }
}

