/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.codec;

import com.fr.third.fr.pdf.io.IOException;

public class TIFFLZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    byte[] uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int dstIndex;
    int w;
    int h;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public TIFFLZWDecoder(int w, int predictor, int samplesPerPixel) {
        this.w = w;
        this.predictor = predictor;
        this.samplesPerPixel = samplesPerPixel;
    }

    public byte[] decode(byte[] data, byte[] uncompData, int h) {
        int code;
        if (data[0] == 0 && data[1] == 1) {
            throw new IOException("tiff.5.0.style.lzw.codes.are.not.supported");
        }
        this.initializeStringTable();
        this.data = data;
        this.h = h;
        this.uncompData = uncompData;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.dstIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int oldCode = 0;
        while ((code = this.getNextCode()) != 257 && this.dstIndex < uncompData.length) {
            byte[] str;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode();
                if (code == 257) break;
                this.writeString(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                str = this.stringTable[code];
                this.writeString(str);
                this.addStringToTable(this.stringTable[oldCode], str[0]);
                oldCode = code;
                continue;
            }
            str = this.stringTable[oldCode];
            str = this.composeString(str, str[0]);
            this.writeString(str);
            this.addStringToTable(str);
            oldCode = code;
        }
        if (this.predictor == 2) {
            for (int j = 0; j < h; ++j) {
                int count = this.samplesPerPixel * (j * this.w + 1);
                for (int i = this.samplesPerPixel; i < this.w * this.samplesPerPixel; ++i) {
                    int n = count;
                    uncompData[n] = (byte)(uncompData[n] + uncompData[count - this.samplesPerPixel]);
                    ++count;
                }
            }
        }
        return uncompData;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] str) {
        int max = this.uncompData.length - this.dstIndex;
        if (str.length < max) {
            max = str.length;
        }
        System.arraycopy(str, 0, this.uncompData, this.dstIndex, max);
        this.dstIndex += max;
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] str = new byte[length + 1];
        System.arraycopy(oldString, 0, str, 0, length);
        str[length] = newString;
        this.stringTable[this.tableIndex++] = str;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] str) {
        this.stringTable[this.tableIndex++] = str;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] str = new byte[length + 1];
        System.arraycopy(oldString, 0, str, 0, length);
        str[length] = newString;
        return str;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 257;
        }
    }
}

