/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.barcodes;

import com.fr.third.fr.pdf.barcodes.BarcodePDF417;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class BarCodePDF417Test {
    public static void main(String[] args) {
        try {
            ImageIO.write((RenderedImage)BarCodePDF417Test.createPDF417Image("\u4e2d\u56fd\u4eba", 100, 50), "jpg", new FileOutputStream("D:/1.jpg"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BufferedImage createPDF417Image(String text, int width, int height) {
        BarcodePDF417 bp = new BarcodePDF417();
        bp.setCode(text);
        bp.paintCode();
        int bitColumns = bp.getBitColumns();
        int codeRows = bp.getCodeRows();
        byte[] outBits = bp.getOutBits();
        int moduleWidth = Math.max(1, (width - 1) / bitColumns + 1);
        int moduleHeight = Math.max(1, (height - 1) / codeRows + 1);
        BufferedImage image = new BufferedImage(bitColumns * moduleWidth, moduleHeight * codeRows, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        int stride = (bitColumns + 7) / 8;
        g2d.setColor(Color.black);
        for (int k = 0; k < codeRows; ++k) {
            int p = k * stride;
            for (int j = 0; j < bitColumns; ++j) {
                int b = outBits[p + j / 8] & 0xFF;
                if (((b <<= j % 8) & 0x80) == 0) continue;
                g2d.fillRect(j * moduleWidth, (codeRows - k - 1) * moduleHeight, moduleWidth, moduleHeight);
            }
        }
        g2d.dispose();
        BufferedImage result = new BufferedImage(width, height, 1);
        Image scaledImage = image.getScaledInstance(width, height, 2);
        g2d = result.createGraphics();
        g2d.drawImage(scaledImage, 0, 0, Color.white, null);
        g2d.dispose();
        return result;
    }
}

