/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.text;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Section;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.field.RtfTOCEntry;
import com.fr.third.com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected ArrayList items = new ArrayList();

    public RtfSection(RtfDocument doc, Section section) {
        super(doc);
        try {
            if (section.getTitle() != null) {
                this.title = (RtfParagraph)doc.getMapper().mapElement(section.getTitle())[0];
            }
            if (this.document.getAutogenerateTOCEntries()) {
                StringBuffer titleText = new StringBuffer();
                Iterator it = section.getTitle().iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (element.type() != 10) continue;
                    titleText.append(((Chunk)element).getContent());
                }
                if (titleText.toString().trim().length() > 0) {
                    RtfTOCEntry tocEntry = new RtfTOCEntry(titleText.toString());
                    tocEntry.setRtfDocument(this.document);
                    this.items.add(tocEntry);
                }
            }
            Iterator iterator = section.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(element);
                int i = 0;
                while (i < rtfElements.length) {
                    if (rtfElements[i] != null) {
                        this.items.add(rtfElements[i]);
                    }
                    ++i;
                }
            }
            this.updateIndentation(section.getIndentationLeft(), section.getIndentationRight(), section.getIndentation());
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    public void writeContent(OutputStream result) throws IOException {
        result.write(RtfParagraph.PARAGRAPH);
        if (this.title != null) {
            this.title.writeContent(result);
        }
        int i = 0;
        while (i < this.items.size()) {
            RtfBasicElement rbe = (RtfBasicElement)this.items.get(i);
            rbe.writeContent(result);
            ++i;
        }
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i = 0;
        while (i < this.items.size()) {
            ((RtfBasicElement)this.items.get(i)).setInTable(inTable);
            ++i;
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i = 0;
        while (i < this.items.size()) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(inHeader);
            ++i;
        }
    }

    private void updateIndentation(float indentLeft, float indentRight, float indentContent) {
        if (this.title != null) {
            this.title.setIndentLeft((int)((double)this.title.getIndentLeft() + (double)indentLeft * 20.0));
            this.title.setIndentRight((int)((double)this.title.getIndentRight() + (double)indentRight * 20.0));
        }
        int i = 0;
        while (i < this.items.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.items.get(i);
            if (rtfElement instanceof RtfSection) {
                ((RtfSection)rtfElement).updateIndentation(indentLeft + indentContent, indentRight, 0.0f);
            } else if (rtfElement instanceof RtfParagraph) {
                ((RtfParagraph)rtfElement).setIndentLeft((int)((double)((RtfParagraph)rtfElement).getIndentLeft() + (double)(indentLeft + indentContent) * 20.0));
                ((RtfParagraph)rtfElement).setIndentRight((int)((double)((RtfParagraph)rtfElement).getIndentRight() + (double)indentRight * 20.0));
            }
            ++i;
        }
    }
}

