/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.style;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.RtfExtendedElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = DocWriter.getISOBytes("\\deff");
    private static final byte[] FONT_TABLE = DocWriter.getISOBytes("\\fonttbl");
    public static final byte[] FONT_NUMBER = DocWriter.getISOBytes("\\f");
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument doc) {
        super(doc);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public void writeContent(OutputStream out) throws IOException {
    }

    public int getFontNumber(RtfFont font) {
        if (font instanceof RtfParagraphStyle) {
            font = new RtfFont(this.document, font);
        }
        int fontIndex = -1;
        int i = 0;
        while (i < this.fontList.size()) {
            if (this.fontList.get(i).equals(font)) {
                fontIndex = i;
            }
            ++i;
        }
        if (fontIndex == -1) {
            fontIndex = this.fontList.size();
            this.fontList.add(font);
        }
        return fontIndex;
    }

    public void writeDefinition(OutputStream result) throws IOException {
        result.write(DEFAULT_FONT);
        result.write(this.intToByteArray(0));
        result.write(OPEN_GROUP);
        result.write(FONT_TABLE);
        int i = 0;
        while (i < this.fontList.size()) {
            result.write(OPEN_GROUP);
            result.write(FONT_NUMBER);
            result.write(this.intToByteArray(i));
            RtfFont rf = (RtfFont)this.fontList.get(i);
            rf.writeDefinition(result);
            result.write(COMMA_DELIMITER);
            result.write(CLOSE_GROUP);
            ++i;
        }
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
    }
}

