/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.document.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class RtfByteArrayBuffer
extends OutputStream {
    private final List arrays = new ArrayList();
    private byte[] buffer;
    private int pos = 0;
    private int size = 0;

    public RtfByteArrayBuffer() {
        this(256);
    }

    public RtfByteArrayBuffer(int bufferSize) {
        if (bufferSize <= 0 || bufferSize > 0x40000000) {
            throw new IllegalArgumentException("bufferSize " + bufferSize);
        }
        int n = 32;
        while (n < bufferSize) {
            n <<= 1;
        }
        this.buffer = new byte[n];
    }

    public String toString() {
        return "RtfByteArrayBuffer: size=" + this.size() + " #arrays=" + this.arrays.size() + " pos=" + this.pos;
    }

    public void reset() {
        this.arrays.clear();
        this.pos = 0;
        this.size = 0;
    }

    public long size() {
        return this.size;
    }

    private void flushBuffer() {
        this.flushBuffer(1);
    }

    private void flushBuffer(int reqSize) {
        if (reqSize < 0) {
            throw new IllegalArgumentException();
        }
        if (this.pos == 0) {
            return;
        }
        if (this.pos == this.buffer.length) {
            this.arrays.add(this.buffer);
            int newSize = this.buffer.length;
            this.buffer = null;
            int MAX = Math.max(1, this.size >> 24) << 16;
            while (newSize < MAX) {
                if ((newSize <<= 1) >= reqSize) break;
            }
            this.buffer = new byte[newSize];
        } else {
            byte[] c = new byte[this.pos];
            System.arraycopy(this.buffer, 0, c, 0, this.pos);
            this.arrays.add(c);
        }
        this.pos = 0;
    }

    public void write(int b) {
        this.buffer[this.pos] = (byte)b;
        ++this.size;
        if (++this.pos == this.buffer.length) {
            this.flushBuffer();
        }
    }

    public void write(byte[] src) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (src.length < this.buffer.length - this.pos) {
            System.arraycopy(src, 0, this.buffer, this.pos, src.length);
            this.pos += src.length;
            this.size += src.length;
            return;
        }
        this.writeLoop(src, 0, src.length);
    }

    public void write(byte[] src, int off, int len) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > src.length || len < 0 || off + len > src.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.writeLoop(src, off, len);
    }

    private void writeLoop(byte[] src, int off, int len) {
        while (len > 0) {
            int room = this.buffer.length - this.pos;
            int n = len > room ? room : len;
            System.arraycopy(src, off, this.buffer, this.pos, n);
            len -= n;
            off += n;
            this.pos += n;
            this.size += n;
            if (this.pos != this.buffer.length) continue;
            this.flushBuffer(len);
        }
    }

    public long write(InputStream in) throws IOException {
        int n;
        if (in == null) {
            throw new NullPointerException();
        }
        long sizeStart = this.size;
        while ((n = in.read(this.buffer, this.pos, this.buffer.length - this.pos)) >= 0) {
            this.pos += n;
            this.size += n;
            if (this.pos != this.buffer.length) continue;
            this.flushBuffer();
        }
        return (long)this.size - sizeStart;
    }

    public void append(byte[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (a.length == 0) {
            return;
        }
        if (a.length <= 8) {
            this.write(a, 0, a.length);
        } else if (a.length <= 16 && this.pos > 0 && this.buffer.length - this.pos > a.length) {
            this.write(a, 0, a.length);
        } else {
            this.flushBuffer();
            this.arrays.add(a);
            this.size += a.length;
        }
    }

    public void append(byte[][] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        int k = 0;
        while (k < a.length) {
            this.append(a[k]);
            ++k;
        }
    }

    public byte[][] toByteArrayArray() {
        this.flushBuffer();
        return (byte[][])this.arrays.toArray((T[])new byte[this.arrays.size()][]);
    }

    public byte[] toByteArray() {
        byte[] r = new byte[this.size];
        int off = 0;
        int n = this.arrays.size();
        int k = 0;
        while (k < n) {
            byte[] src = (byte[])this.arrays.get(k);
            System.arraycopy(src, 0, r, off, src.length);
            off += src.length;
            ++k;
        }
        if (this.pos > 0) {
            System.arraycopy(this.buffer, 0, r, off, this.pos);
        }
        return r;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException();
        }
        int n = this.arrays.size();
        int k = 0;
        while (k < n) {
            byte[] src = (byte[])this.arrays.get(k);
            out.write(src);
            ++k;
        }
        if (this.pos > 0) {
            out.write(this.buffer, 0, this.pos);
        }
    }
}

