/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf.fonts.cmaps;

import com.fr.third.com.lowagie.text.pdf.fonts.cmaps.CodespaceRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMap {
    private List codeSpaceRanges = new ArrayList();
    private Map singleByteMappings = new HashMap();
    private Map doubleByteMappings = new HashMap();

    public boolean hasOneByteMappings() {
        return !this.singleByteMappings.isEmpty();
    }

    public boolean hasTwoByteMappings() {
        return !this.doubleByteMappings.isEmpty();
    }

    public String lookup(byte[] code, int offset, int length) {
        String result = null;
        Integer key = null;
        if (length == 1) {
            key = new Integer((code[offset] + 256) % 256);
            result = (String)this.singleByteMappings.get(key);
        } else if (length == 2) {
            int intKey = (code[offset] + 256) % 256;
            intKey <<= 8;
            key = new Integer(intKey += (code[offset + 1] + 256) % 256);
            result = (String)this.doubleByteMappings.get(key);
        }
        return result;
    }

    public void addMapping(byte[] src, String dest) throws IOException {
        if (src.length == 1) {
            this.singleByteMappings.put(new Integer(src[0]), dest);
        } else if (src.length == 2) {
            int intSrc = src[0] & 0xFF;
            intSrc <<= 8;
            this.doubleByteMappings.put(new Integer(intSrc |= src[1] & 0xFF), dest);
        } else {
            throw new IOException("Mapping code should be 1 or two bytes and not " + src.length);
        }
    }

    public void addCodespaceRange(CodespaceRange range) {
        this.codeSpaceRanges.add(range);
    }

    public List getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }
}

