/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf.draw;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.ElementListener;
import com.fr.third.com.lowagie.text.pdf.PdfContentByte;
import com.fr.third.com.lowagie.text.pdf.draw.DrawInterface;
import java.util.ArrayList;

public class VerticalPositionMark
implements DrawInterface,
Element {
    protected DrawInterface drawInterface = null;
    protected float offset = 0.0f;

    public VerticalPositionMark() {
    }

    public VerticalPositionMark(DrawInterface drawInterface, float offset) {
        this.drawInterface = drawInterface;
        this.offset = offset;
    }

    public void draw(PdfContentByte canvas, float llx, float lly, float urx, float ury, float y) {
        if (this.drawInterface != null) {
            this.drawInterface.draw(canvas, llx, lly, urx, ury, y + this.offset);
        }
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException e) {
            return false;
        }
    }

    public int type() {
        return 55;
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        list.add(new Chunk((DrawInterface)this, true));
        return list;
    }

    public DrawInterface getDrawInterface() {
        return this.drawInterface;
    }

    public void setDrawInterface(DrawInterface drawInterface) {
        this.drawInterface = drawInterface;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }
}

