/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr.debug;

import com.fr.third.antlr.debug.InputBufferEvent;
import com.fr.third.antlr.debug.InputBufferListener;
import com.fr.third.antlr.debug.ListenerBase;
import java.util.Vector;

public class InputBufferEventSupport {
    private Object source;
    private Vector inputBufferListeners;
    private InputBufferEvent inputBufferEvent;
    protected static final int CONSUME = 0;
    protected static final int LA = 1;
    protected static final int MARK = 2;
    protected static final int REWIND = 3;

    public InputBufferEventSupport(Object source) {
        this.inputBufferEvent = new InputBufferEvent(source);
        this.source = source;
    }

    public void addInputBufferListener(InputBufferListener l) {
        if (this.inputBufferListeners == null) {
            this.inputBufferListeners = new Vector();
        }
        this.inputBufferListeners.addElement(l);
    }

    public void fireConsume(char c) {
        this.inputBufferEvent.setValues(0, c, 0);
        this.fireEvents(0, this.inputBufferListeners);
    }

    public void fireEvent(int type, ListenerBase l) {
        switch (type) {
            case 0: {
                ((InputBufferListener)l).inputBufferConsume(this.inputBufferEvent);
                break;
            }
            case 1: {
                ((InputBufferListener)l).inputBufferLA(this.inputBufferEvent);
                break;
            }
            case 2: {
                ((InputBufferListener)l).inputBufferMark(this.inputBufferEvent);
                break;
            }
            case 3: {
                ((InputBufferListener)l).inputBufferRewind(this.inputBufferEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad type " + type + " for fireEvent()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(int type, Vector listeners) {
        Vector targets = null;
        ListenerBase l = null;
        InputBufferEventSupport inputBufferEventSupport = this;
        synchronized (inputBufferEventSupport) {
            if (listeners == null) {
                return;
            }
            targets = (Vector)listeners.clone();
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                l = (ListenerBase)targets.elementAt(i);
                this.fireEvent(type, l);
            }
        }
    }

    public void fireLA(char c, int la) {
        this.inputBufferEvent.setValues(1, c, la);
        this.fireEvents(1, this.inputBufferListeners);
    }

    public void fireMark(int pos) {
        this.inputBufferEvent.setValues(2, ' ', pos);
        this.fireEvents(2, this.inputBufferListeners);
    }

    public void fireRewind(int pos) {
        this.inputBufferEvent.setValues(3, ' ', pos);
        this.fireEvents(3, this.inputBufferListeners);
    }

    public Vector getInputBufferListeners() {
        return this.inputBufferListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Vector listeners) {
        Vector v;
        Vector vector = listeners;
        synchronized (vector) {
            v = (Vector)listeners.clone();
        }
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                ((ListenerBase)v.elementAt(i)).refresh();
            }
        }
    }

    public void refreshListeners() {
        this.refresh(this.inputBufferListeners);
    }

    public void removeInputBufferListener(InputBufferListener l) {
        if (this.inputBufferListeners != null) {
            this.inputBufferListeners.removeElement(l);
        }
    }
}

