/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ForwardSeekableStream;
import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoder;
import com.fr.third.JAI.PNMEncodeParam;
import com.fr.third.JAI.PNMImageDecoder;
import com.fr.third.JAI.PNMImageEncoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNMCodec
extends ImageCodec {
    public String getFormatName() {
        return "pnm";
    }

    public Class getEncodeParamClass() {
        return PNMEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return Object.class;
    }

    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        SampleModel sampleModel = im.getSampleModel();
        int dataType = sampleModel.getTransferType();
        if (dataType == 4 || dataType == 5) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        return numBands == 1 || numBands == 3;
    }

    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        PNMEncodeParam p = null;
        if (param != null) {
            p = (PNMEncodeParam)param;
        }
        return new PNMImageEncoder(dst, p);
    }

    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        if (!(src instanceof BufferedInputStream)) {
            src = new BufferedInputStream(src);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(src), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new PNMImageDecoder(src, null);
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 80 && header[1] >= 49 && header[1] <= 54;
    }
}

