/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.JPEGDecodeParam;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.NoMarkStream;
import com.fr.third.JAI.SimpleRenderedImage;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class JPEGImage
extends SimpleRenderedImage {
    private static final Object LOCK = new Object();
    private Raster theTile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPEGImage(InputStream stream, ImageDecodeParam param) {
        if (stream.markSupported()) {
            stream = new NoMarkStream(stream);
        }
        BufferedImage image = null;
        Object object = LOCK;
        synchronized (object) {
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)stream);
            try {
                image = decoder.decodeAsBufferedImage();
            }
            catch (ImageFormatException e) {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder1"));
            }
            catch (IOException e) {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder2"));
            }
        }
        this.minX = 0;
        this.minY = 0;
        this.tileWidth = this.width = image.getWidth();
        this.tileHeight = this.height = image.getHeight();
        if ((param == null || param instanceof JPEGDecodeParam && ((JPEGDecodeParam)param).getDecodeToCSM()) && !(image.getSampleModel() instanceof ComponentSampleModel)) {
            int type = -1;
            int numBands = image.getSampleModel().getNumBands();
            if (numBands == 1) {
                type = 10;
            } else if (numBands == 3) {
                type = 5;
            } else if (numBands == 4) {
                type = 6;
            } else {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder3"));
            }
            BufferedImage bi = new BufferedImage(this.width, this.height, type);
            bi.getWritableTile(0, 0).setRect(image.getWritableTile(0, 0));
            bi.releaseWritableTile(0, 0);
            image = bi;
        }
        this.sampleModel = image.getSampleModel();
        this.colorModel = image.getColorModel();
        this.theTile = image.getWritableTile(0, 0);
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGImageDecoder4"));
        }
        return this.theTile;
    }
}

