/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.output.json.cell;

import com.fr.base.Base64;
import com.fr.base.Formula;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.present.Present;
import com.fr.data.DataUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.DynamicAttrElem;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.stable.core.NodeVisitor;
import com.fr.web.output.json.cell.AbstractCellBuildAction;
import java.awt.Dimension;
import java.awt.Image;
import java.text.Format;

public class PageCellValueBuildAction
extends AbstractCellBuildAction {
    protected Object realValue;

    public void buildDataTo(NodeVisitor nodeVisitor, JSONObject jSONObject) throws JSONException {
        CellGUIAttr cellGUIAttr = this.getCellGUIAttr();
        if (cellGUIAttr.isShowAsHTML()) {
            jSONObject.put("showAsHtml", true);
        }
        if (cellGUIAttr.isShowAsImage()) {
            jSONObject.put("showAsImage", true);
        }
        if (cellGUIAttr.isShowAsDownload()) {
            jSONObject.put("showAsDownload", true);
        }
        this.realValue = DataUtils.resolveOtherValue((Object)this.cell.getValue(), (boolean)cellGUIAttr.isShowAsImage(), (boolean)cellGUIAttr.isShowAsDownload(), (Object)cellGUIAttr.getFileName(), (boolean)true);
        if (this.realValue instanceof String) {
            this.realValue = ((String)this.realValue).replace("\\n", "\n");
        }
        if (this.realValue instanceof Painter) {
            Dimension dimension = this.getCellDimension();
            jSONObject.put("value", (Object)((Painter)this.realValue).toJSONObject(nodeVisitor, this.getRepository(), dimension.width, dimension.height));
            return;
        }
        Present present = null;
        if (this.cell instanceof DynamicAttrElem) {
            present = ((DynamicAttrElem)((Object)this.cell)).getPresent();
        }
        if (this.realValue instanceof Formula && present == null) {
            this.dealWithCellFormula(jSONObject, (Formula)this.realValue);
            jSONObject.put("text", (Object)Style.valueToText((Object)this.realValue, (Format)this.cell.getStyle().getFormat()));
        } else {
            jSONObject.put("text", (Object)Style.valueToText((Object)this.cell.getShowValue(), (Format)this.cell.getStyle().getFormat()));
        }
        if (this.realValue instanceof Image) {
            jSONObject.put("value", (Object)new JSONObject().put("type", (Object)"image").put("value", (Object)Base64.encode((Image)((Image)this.realValue), (String)"png")).put("imageLayout", (Object)new Integer(this.cell.getStyle().getImageLayout())));
            return;
        }
        if (this.realValue instanceof Number) {
            jSONObject.put("isnumber", true);
        }
    }

    private CellGUIAttr getCellGUIAttr() {
        CellGUIAttr cellGUIAttr = this.cell.getCellGUIAttr();
        if (cellGUIAttr == null) {
            cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
        return cellGUIAttr;
    }

    protected void dealWithCellFormula(JSONObject jSONObject, Formula formula) throws JSONException {
        this.realValue = formula.getResult();
    }
}

