/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.output.json.cell;

import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.CellElement;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.web.output.CellOutlet;
import com.fr.web.output.exception.OutputException;
import com.fr.web.output.json.cell.CellBuildAction;
import com.fr.web.output.json.cell.EnvVariableManager;
import com.fr.web.output.json.cell.EnvVariableManagerImpl;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONCellOutlet
implements CellOutlet<JSONObject> {
    private CellElement cell;
    private JSONObject json;
    private List<CellBuildAction> actionList = new ArrayList<CellBuildAction>();
    private EnvVariableManager envVariableManager = new EnvVariableManagerImpl();

    public JSONObject out(NodeVisitor nodeVisitor) throws OutputException {
        try {
            for (CellBuildAction cellBuildAction : this.actionList) {
                cellBuildAction.buildDataTo(nodeVisitor, this.json);
            }
            return this.json;
        }
        catch (JSONException jSONException) {
            throw new OutputException(jSONException.getMessage(), (Throwable)jSONException);
        }
    }

    public void addCellPutAction(CellBuildAction cellBuildAction) {
        if (cellBuildAction == null) {
            return;
        }
        cellBuildAction.setEnvVariableManager(this.envVariableManager);
        this.actionList.add(cellBuildAction);
    }

    public void addCellPutAction(Collection<? extends CellBuildAction> collection) {
        this.actionList.addAll(collection);
    }

    public void resetCell(CellElement cellElement) {
        this.resetOutJson();
        this.updatePutActionCell(cellElement);
        this.cell = cellElement;
    }

    public void setEnvVariableManager(EnvVariableManager envVariableManager) {
        this.envVariableManager = envVariableManager;
        for (CellBuildAction cellBuildAction : this.actionList) {
            cellBuildAction.setEnvVariableManager(envVariableManager);
        }
    }

    private void updateEnvVariable() {
    }

    public void setRepository(Repository repository) {
        for (CellBuildAction cellBuildAction : this.actionList) {
            cellBuildAction.setRepository(repository);
        }
    }

    private void updatePutActionCell(CellElement cellElement) {
        for (CellBuildAction cellBuildAction : this.actionList) {
            cellBuildAction.setCell(cellElement);
        }
    }

    private void resetOutJson() {
        this.json = new JSONObject();
    }

    public void setCellDimension(Dimension dimension) {
        this.envVariableManager.setCellDimension(dimension);
    }
}

