/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.utils;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.cache.Attachment;
import com.fr.file.WebImage;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.core.PaintUtils;
import com.fr.stable.fun.AttachmentDownloader;
import com.fr.stable.fun.BackgroundImageDisplayModeProcessor;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.stable.web.Repository;
import com.fr.web.BaseHTMLWriterUtils;
import com.fr.web.Browser;
import com.fr.web.core.utils.StyleWithSize;
import com.fr.web.fun.DefaultAttachmentDownloader;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReportHTMLWriterUtils {
    private ReportHTMLWriterUtils() {
    }

    private static void writeBackground(Tag tag, Background background, Dimension dimension, Repository repository) {
        BaseHTMLWriterUtils.writeBackground((Tag)tag, (Background)background, (Dimension)dimension, (boolean)false, (Repository)repository);
    }

    public static Tag createFileDownloadTag(Attachment attachment, String string) {
        String string2 = "${servletURL}?op=fr_attach&cmd=ah_download&id=" + attachment.getID();
        try {
            string2 = TemplateUtils.render((String)string2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        AttachmentDownloader attachmentDownloader = (AttachmentDownloader)ExtraClassManager.getInstance().getSingle("AttachmentDownloader");
        if (attachmentDownloader == null) {
            attachmentDownloader = DefaultAttachmentDownloader.getInstance();
        }
        String string3 = attachmentDownloader.createDownloadScript(string2);
        Tag tag = new Tag("span").sub(string).css("text-decoration", "underline").css("cursor", "pointer").css("color", "#0000FF").attr("onclick", string3);
        return tag;
    }

    public static void value2PaintableTag4Print(Object object, StyleWithSize styleWithSize, Tag tag, Repository repository) {
        ReportHTMLWriterUtils.value2PaintableTag(object, styleWithSize, tag, repository, true);
    }

    public static void value2PaintableTag(Object object, StyleWithSize styleWithSize, Tag tag, Repository repository) {
        ReportHTMLWriterUtils.value2PaintableTag(object, styleWithSize, tag, repository, false);
    }

    private static void value2PaintableTag(Object object, StyleWithSize styleWithSize, Tag tag, Repository repository, boolean bl) {
        if (object instanceof Painter) {
            if (repository.getBrowser().shouldModifyWidth4PainterAccordingToBorderWidth()) {
                styleWithSize.setWidth(styleWithSize.getWidth() - (BaseUtils.getBorderWidth((int)styleWithSize.getStyle().getBorderLeft()) + BaseUtils.getBorderWidth((int)styleWithSize.getStyle().getBorderRight()) + 1) / 2);
            }
            if (bl) {
                tag.sub((Html)BaseHTMLWriterUtils.createImageTag4RepoWithCheckVml((Image)CellUtils.value2Image(object, repository.getResolution(), styleWithSize.getStyle(), styleWithSize.getWidth(), styleWithSize.getHeight()), (Dimension)styleWithSize.getDimension(), (Repository)repository));
            } else {
                PaintUtils.paintTag((Painter)object, repository, styleWithSize.getWidth(), styleWithSize.getHeight(), styleWithSize.getStyle(), tag);
            }
        } else if (object instanceof Attachment) {
            tag.css("text-align", "center");
            tag.sub((Html)ReportHTMLWriterUtils.createFileDownloadTag((Attachment)object, ((Attachment)object).getFilename()));
        } else if (object instanceof WebImage) {
            Tag tag2 = new Tag("img").css("width", styleWithSize.getDimension().width + "px").css("height", styleWithSize.getDimension().height + "px").css("border", "0").attr("src", ((WebImage)object).getImageUrl());
            if (repository.getBrowser().shouldConsiderVML()) {
                tag2.attr("onload", "FR.correctPNG(this)");
            }
            tag.sub((Html)tag2);
        } else {
            Image image = CellUtils.value2ImageWithBackground(object, repository.getResolution(), styleWithSize.getStyle(), styleWithSize.getWidth(), styleWithSize.getHeight());
            BackgroundImageDisplayModeProcessor backgroundImageDisplayModeProcessor = (BackgroundImageDisplayModeProcessor)ExtraClassManager.getInstance().getSingle("BackgroundImageDisplayModeProcessor");
            if (backgroundImageDisplayModeProcessor != null) {
                tag.sub((Html)BaseHTMLWriterUtils.createImageTagFromParentTag4RepoWithCheckVml((Image)image, (Dimension)styleWithSize.getDimension(), (Repository)repository, (Tag)tag));
            } else {
                tag.sub((Html)BaseHTMLWriterUtils.createImageTag4RepoWithCheckVml((Image)image, (Dimension)styleWithSize.getDimension(), (Repository)repository));
            }
        }
    }

    public static void writeTagBackground(Tag tag, Image image, Repository repository) {
        String string = repository.checkoutObject((Object)image, "image");
        tag.css("background", "url(" + string + ") no-repeat");
    }

    public static void contentStyle2CssExceptBorderAndBackground(Style style, Tag tag) {
        ReportHTMLWriterUtils.contentStyle2Css(style, tag, null);
    }

    private static void contentStyle2Css(Style style, Tag tag, Object object) {
        ReportHTMLWriterUtils.contentStyle2Css(style, tag, object, new ArrayList());
    }

    private static void contentStyle2Css(Style style, Tag tag, Object object, List list) {
        tag.cls(style.getContentClsCss(object));
        Map map = style.getContentStyleCssMap();
        if (!map.isEmpty()) {
            for (Object k2 : map.keySet()) {
                if (list.contains(k2)) continue;
                tag.css(Utils.objectToString(k2), Utils.objectToString(map.get(k2)));
            }
        }
    }

    public static void style2CssOnlyWithBorder(Style style, Tag tag) {
        tag.cls(style.getBorderClsCss());
        Map map = style.getBorderStyleCssMap();
        if (!map.isEmpty()) {
            tag.css(map);
        }
    }

    public static void style2Css4Background(StyleWithSize styleWithSize, Tag tag, CellGUIAttr cellGUIAttr, Repository repository, Object object, List list) {
        ReportHTMLWriterUtils.style2Css4BackgroundWithoutBorder(styleWithSize, tag, cellGUIAttr, repository, object, list);
        Style style = styleWithSize.getStyle();
        ReportHTMLWriterUtils.style2CssOnlyWithBorder(style, tag);
    }

    public static int[] writeFloatElement(Iterator iterator, int n2, int n3, Tag tag, int n4, int n5, Repository repository) {
        while (iterator.hasNext()) {
            MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
            FloatElement floatElement = (FloatElement)iterator.next();
            Tag tag2 = null;
            NameJavaScriptGroup nameJavaScriptGroup = floatElement.getNameHyperlinkGroup();
            if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
                tag2 = new Tag("span");
                String string = "{}";
                try {
                    string = BaseUtils.writeJSLinkContent((NameJavaScriptGroup)nameJavaScriptGroup, (Repository)repository);
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
                }
                tag2.attr("onclick", "FR.doHyperlink(event ||window.event," + string + ")");
                tag2.css("cursor", "pointer");
            }
            int n6 = floatElement.getLeftDistance().toPixI(repository.getResolution());
            int n7 = floatElement.getTopDistance().toPixI(repository.getResolution());
            int n8 = floatElement.getWidth().toPixI(repository.getResolution()) + 1;
            int n9 = floatElement.getHeight().toPixI(repository.getResolution()) + 1;
            n2 = Math.max(n2, n6 + n8);
            n3 = Math.max(n3, n7 + n9);
            Tag tag3 = new Tag("div");
            if (tag2 == null) {
                tag2 = tag3;
            } else {
                tag2.sub((Html)tag3);
            }
            tag.sub((Html)tag2);
            tag3.css("overflow", "hidden");
            tag3.css("position", "absolute");
            tag3.css("left", n4 + n6 + "px");
            tag3.css("top", n5 + n7 + "px");
            tag3.css("width", n8 + "px");
            tag3.css("height", n9 + "px");
            if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
                tag3.css("z-index", "20");
            }
            tag3.sub((Html)floatElement.toTag(repository));
        }
        MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
        return new int[]{n2, n3};
    }

    private static boolean shouldModifyBorder(Repository repository, Style style) {
        return repository.getBrowser().isIE() && !repository.getBrowser().isQuirksModel() && repository.getBrowser() instanceof Browser && ComparatorUtils.equals((String)"8.0", (String)((Browser)repository.getBrowser()).getVersion()) && style.getBackground() != null && !(style.getBackground() instanceof ColorBackground);
    }

    private static void style2Css4BackgroundWithoutBorder(StyleWithSize styleWithSize, Tag tag, CellGUIAttr cellGUIAttr, Repository repository, Object object, List list) {
        ReportHTMLWriterUtils.contentStyle2Css(styleWithSize.getStyle(), tag, object, list);
        if (cellGUIAttr == null || cellGUIAttr.isPreviewBackground()) {
            ReportHTMLWriterUtils.writeBackground(tag, styleWithSize.getStyle().getBackground(), styleWithSize.getDimension(), repository);
        }
    }
}

