/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.utils;

import com.fr.base.FRContext;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.base.headerfooter.DateHFElement;
import com.fr.base.headerfooter.HFElement;
import com.fr.base.headerfooter.NewLineHFElement;
import com.fr.base.headerfooter.NumberOfPageHFElement;
import com.fr.base.headerfooter.PageNumberHFElement;
import com.fr.base.headerfooter.TextHFElement;
import com.fr.base.headerfooter.TimeHFElement;
import com.fr.base.types.StringNumberType;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.IOUtils;
import com.fr.io.exporter.poi.wrapper.POIClientAnchorAction;
import com.fr.io.exporter.poi.wrapper.POIHeaderFooterAction;
import com.fr.io.exporter.poi.wrapper.POIPatriarchAction;
import com.fr.io.exporter.poi.wrapper.POIPrintSetupAction;
import com.fr.io.exporter.poi.wrapper.POISheetAction;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFooter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFHeader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Format;
import java.text.NumberFormat;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class ExportUtils {
    private ExportUtils() {
    }

    public static void dealWithBufferImage(Object object, POIClientAnchorAction pOIClientAnchorAction, POIPatriarchAction pOIPatriarchAction, BufferedImage bufferedImage, POIWorkbookAction pOIWorkbookAction) {
        if (object != null) {
            pOIClientAnchorAction.setAnchorType(2);
            try {
                int n2 = ExportUtils.loadPicture(bufferedImage, pOIWorkbookAction);
                pOIPatriarchAction.createPicture(pOIClientAnchorAction, n2);
            }
            catch (IOException iOException) {
                FRContext.getLogger().error(iOException.getMessage());
            }
        }
    }

    public static void setSheetName(POIWorkbookAction pOIWorkbookAction, String string) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        int n2 = 1;
        while (pOIWorkbookAction.getSheet(string) != null) {
            string = "Sheet" + n2;
            ++n2;
        }
        pOIWorkbookAction.setSheetName(pOIWorkbookAction.getNumberOfSheets() - 1, string);
    }

    public static void dealWithPrintSetUp(POIPrintSetupAction pOIPrintSetupAction, PaperSize paperSize, int n2, ReportSettingsProvider reportSettingsProvider) {
        if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_A4)) {
            pOIPrintSetupAction.setPaperSize((short)9);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_LETTER)) {
            pOIPrintSetupAction.setPaperSize((short)5);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_HALFLETTER)) {
            pOIPrintSetupAction.setPaperSize((short)2);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_TABLOID)) {
            pOIPrintSetupAction.setPaperSize((short)3);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_LEDGER)) {
            pOIPrintSetupAction.setPaperSize((short)4);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_LEGAL)) {
            pOIPrintSetupAction.setPaperSize((short)5);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_A3)) {
            pOIPrintSetupAction.setPaperSize((short)8);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_A5)) {
            pOIPrintSetupAction.setPaperSize((short)11);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_A6)) {
            pOIPrintSetupAction.setPaperSize((short)70);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_B4)) {
            pOIPrintSetupAction.setPaperSize((short)12);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_B5_JIS)) {
            pOIPrintSetupAction.setPaperSize((short)13);
        } else if (ComparatorUtils.equals((Object)paperSize, (Object)PaperSize.PAPERSIZE_NOTE)) {
            pOIPrintSetupAction.setPaperSize((short)18);
        } else {
            pOIPrintSetupAction.setPaperSize((short)9);
        }
        pOIPrintSetupAction.setLandscape(n2 == 1);
        pOIPrintSetupAction.setLeftToRight(reportSettingsProvider.getPageOrder() == 1);
        pOIPrintSetupAction.setHeaderMargin(reportSettingsProvider.getHeaderHeight().toINCHValue4Scale3());
        pOIPrintSetupAction.setFooterMargin(reportSettingsProvider.getFooterHeight().toINCHValue4Scale3());
    }

    public static void dealWithAlignAndMargin(POISheetAction pOISheetAction, ReportSettingsProvider reportSettingsProvider, Margin margin) {
        pOISheetAction.setVerticallyCenter(reportSettingsProvider.isVerticalCenterOnPage());
        pOISheetAction.setMargin((short)2, margin.getTop().toINCHValue4Scale3());
        pOISheetAction.setMargin((short)0, margin.getLeft().toINCHValue4Scale3());
        pOISheetAction.setMargin((short)3, margin.getBottom().toINCHValue4Scale3());
        pOISheetAction.setMargin((short)1, margin.getRight().toINCHValue4Scale3());
    }

    public static void applyReportHFHeader(ReportHFProvider reportHFProvider, POIHeaderFooterAction pOIHeaderFooterAction) {
        pOIHeaderFooterAction.setLeft(ExportUtils.createHFString(reportHFProvider.getLeftList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
        pOIHeaderFooterAction.setCenter(ExportUtils.createHFString(reportHFProvider.getCenterList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
        pOIHeaderFooterAction.setRight(ExportUtils.createHFString(reportHFProvider.getRightList(), HSSFHeader.date(), HSSFHeader.time(), HSSFHeader.page(), HSSFHeader.numPages()));
    }

    public static void applyReportHFFooter(ReportHFProvider reportHFProvider, POIHeaderFooterAction pOIHeaderFooterAction) {
        pOIHeaderFooterAction.setLeft(ExportUtils.createHFString(reportHFProvider.getLeftList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
        pOIHeaderFooterAction.setCenter(ExportUtils.createHFString(reportHFProvider.getCenterList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
        pOIHeaderFooterAction.setRight(ExportUtils.createHFString(reportHFProvider.getRightList(), HSSFFooter.date(), HSSFFooter.time(), HSSFFooter.page(), HSSFFooter.numPages()));
    }

    private static String createHFString(List list, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HFElement hFElement = (HFElement)list.get(i2);
            if (!(hFElement instanceof TextHFElement)) continue;
            FRFont fRFont = ((TextHFElement)hFElement).getFRFont();
            String string5 = "";
            if (fRFont.getStyle() == 0) {
                string5 = "Plain";
            } else if (fRFont.getStyle() == 1) {
                string5 = "Bold";
            } else if (fRFont.getStyle() == 2) {
                string5 = "Italic";
            } else if (fRFont.getStyle() == 3) {
                string5 = "Bold Italic";
            }
            stringBuffer.append(HSSFHeader.font((String)fRFont.getName(), (String)string5));
            stringBuffer.append(HSSFHeader.fontSize((short)((short)fRFont.getSize())));
            stringBuffer.append(' ');
            if (ComparatorUtils.equals(hFElement.getClass(), TextHFElement.class)) {
                stringBuffer.append(((TextHFElement)hFElement).getText());
                continue;
            }
            if (ComparatorUtils.equals(hFElement.getClass(), DateHFElement.class)) {
                stringBuffer.append(string);
                continue;
            }
            if (ComparatorUtils.equals(hFElement.getClass(), TimeHFElement.class)) {
                stringBuffer.append(string2);
                continue;
            }
            if (ComparatorUtils.equals(hFElement.getClass(), PageNumberHFElement.class)) {
                stringBuffer.append(string3);
                continue;
            }
            if (ComparatorUtils.equals(hFElement.getClass(), NumberOfPageHFElement.class)) {
                stringBuffer.append(string4);
                continue;
            }
            if (!ComparatorUtils.equals(hFElement.getClass(), NewLineHFElement.class)) continue;
        }
        return stringBuffer.toString();
    }

    public static String replaceNewLineChar(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        if (string.contains("\\\\n")) {
            string = string.replaceAll("\\\\n", "\n");
        }
        if (string.contains("\\n")) {
            string = string.replaceAll("\\\\n", "\n");
        }
        if (string.contains("\r\n")) {
            string = string.replaceAll("\r\n", "\n");
        }
        if (string.contains("\r")) {
            string = string.replaceAll("\r", "\n");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadPicture(BufferedImage bufferedImage, POIWorkbookAction pOIWorkbookAction) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.writeImage((Image)bufferedImage, (String)"png", (OutputStream)byteArrayOutputStream);
            n2 = pOIWorkbookAction.addPicture(byteArrayOutputStream.toByteArray(), 6);
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
        }
        return n2;
    }

    public static Object checkNumberFormat(Format format, Object object) {
        try {
            if (format instanceof NumberFormat && object instanceof String) {
                Number number = StableUtils.string2Number((String)((String)object));
                return number == null ? object : number;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static Object checkExcel2007NumberFormat(Format format, Object object) {
        try {
            if (format instanceof NumberFormat && object instanceof String && StableUtils.isNumber((String)((String)object))) {
                return new StringNumberType((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static void setPDFContent(HttpServletResponse httpServletResponse, String string, boolean bl) {
        httpServletResponse.setContentType("application/pdf");
        httpServletResponse.setHeader("extension", "pdf");
        if (bl) {
            httpServletResponse.setHeader("Content-disposition", "anyword; filename=" + string + ".pdf");
        } else {
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".pdf");
        }
    }

    public static void setExcelContent(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/x-excel");
        httpServletResponse.setHeader("extension", "xls");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".xls");
    }

    public static void setExcel2007Content(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/x-excel");
        httpServletResponse.setHeader("extension", "xlsx");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".xlsx");
    }

    public static void setWordConetent(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/msword");
        httpServletResponse.setHeader("extension", "doc");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".doc");
    }

    public static void setZipContext(HttpServletResponse httpServletResponse, String string, boolean bl) {
        if (bl) {
            httpServletResponse.setContentType("application/zip");
        }
        httpServletResponse.setHeader("extension", "zip");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".zip");
    }

    public static void setSVGContext(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("image/svg+xml");
        httpServletResponse.setHeader("extension", "svg");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".svg");
    }

    public static void setCSVContext(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("extension", "csv");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".csv");
    }

    public static void setTextContext(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("extension", "txt");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".txt");
    }

    public static void setImageContext(HttpServletResponse httpServletResponse, String string, String string2) {
        httpServletResponse.setContentType("image/" + string2);
        httpServletResponse.setHeader("extension", string2);
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + "." + string2);
    }

    public static void setCPTContext(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("extension", "cpt");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".cpt");
    }

    public static void setHTMLContext(HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("extension", "html");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".html");
    }
}

