/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reserve;

import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.data.NetworkHelper;
import com.fr.data.TableDataSource;
import com.fr.form.FormElementCaseProvider;
import com.fr.form.FormElementCaseResultProvider;
import com.fr.form.main.Form;
import com.fr.form.ui.ElementCaseEditor;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.DeclareRecordType;
import com.fr.page.PageSetCreater;
import com.fr.page.PageSetProvider;
import com.fr.report.ResultWorkBookProvider;
import com.fr.stable.fun.impl.NoOPService;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.web.Browser;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.FormSessionIDInfor;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WidgetSessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportECService
extends NoOPService {
    public String actionOP() {
        return "ec_export";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        this.dealWithExport(httpServletRequest, httpServletResponse, string, false);
    }

    public void dealWithExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) throws Exception {
        FormSessionIDInfor formSessionIDInfor;
        if (string == null) {
            string = NetworkHelper.getHTTPRequestSessionIDParameter((HttpServletRequest)httpServletRequest);
        }
        if ((formSessionIDInfor = (FormSessionIDInfor)SessionDealWith.getSessionIDInfor((String)string)) == null) {
            return;
        }
        NetworkHelper.setCacheSettings((HttpServletResponse)httpServletResponse);
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"widgetName");
        String string3 = this.getfileName(httpServletRequest, (SessionIDInfor)formSessionIDInfor, string2);
        this.setContent(httpServletRequest, httpServletResponse, string3);
        this.doExport(httpServletRequest, httpServletResponse, formSessionIDInfor, string2);
        MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
        formSessionIDInfor.setAttribute("genpdfprint", Boolean.FALSE);
    }

    private void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (ExcelUtils.checkThirdJarSupportPOI() && !WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"isExcel2003")) {
            httpServletResponse.setContentType("application/x-excel");
            httpServletResponse.setHeader("extension", "xlsx");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".xlsx");
        } else {
            httpServletResponse.setContentType("application/x-excel");
            httpServletResponse.setHeader("extension", "xls");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string + ".xls");
        }
    }

    private String getfileName(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, String string) throws Exception {
        String string2 = NetworkHelper.getHTTPRequestFileNameParameter((HttpServletRequest)httpServletRequest);
        if (string2 == null) {
            string2 = (String)sessionIDInfor.getParameterValue("__filename__");
        }
        if (string2 == null) {
            string2 = sessionIDInfor.getWebTitle().replaceAll("\\s", "_");
            string2 = string2.replaceAll(",", "_");
        }
        string2 = string2 + "_" + string;
        Browser browser = Browser.resolve((HttpServletRequest)httpServletRequest);
        string2 = browser.getEncodedFileName4Download(string2);
        return string2;
    }

    public void doExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FormSessionIDInfor formSessionIDInfor, String string) throws Exception {
        Form form = (Form)((Object)formSessionIDInfor.getForm2Show().clone());
        Map map = formSessionIDInfor.getParameterMap4Execute();
        map.put("__FIT__", true);
        map.put("_PAPERHEIGHT", WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"_PAPERHEIGHT"));
        map.put("_PAPERWIDTH", WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"_PAPERWIDTH"));
        map.put("_SHOWPARA", WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"_SHOWPARA"));
        form.resizeFormElems(map);
        Widget widget = form.getWidgetByName(string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            this.doElementCase((OutputStream)servletOutputStream, httpServletRequest, form, widget, string, formSessionIDInfor, this.getRecordType(httpServletRequest));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, (Throwable)exception);
        }
        try {
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DeclareRecordType getRecordType(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"format");
        if (ComparatorUtils.equalsIgnoreCase((String)"excel", (String)string)) {
            String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"extype");
            if (ComparatorUtils.equalsIgnoreCase((String)"simple", (String)string2)) {
                return DeclareRecordType.EXPORT_TYPE_EXCEL_ORIGINAL;
            }
            return DeclareRecordType.EXPORT_TYPE_EXCEL_PAGE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doElementCase(OutputStream outputStream, HttpServletRequest httpServletRequest, Form form, Widget widget, String string, FormSessionIDInfor formSessionIDInfor, DeclareRecordType declareRecordType) {
        if (!widget.acceptType(new Class[]{ElementCaseEditor.class})) {
            return;
        }
        if (!widget.isVisible()) {
            return;
        }
        FormSessionIDInfor formSessionIDInfor2 = formSessionIDInfor;
        synchronized (formSessionIDInfor2) {
            ElementCaseEditor elementCaseEditor = (ElementCaseEditor)widget;
            FormElementCaseProvider formElementCaseProvider = elementCaseEditor.getElementCase();
            formElementCaseProvider.setName(string);
            formElementCaseProvider.setTabledataSource((TableDataSource)form);
            formSessionIDInfor.applySessionIDInforParameters(httpServletRequest);
            Map map = formSessionIDInfor.getParameterMap4Execute();
            FormElementCaseResultProvider formElementCaseResultProvider = formSessionIDInfor.getElementCaseResult(string);
            final PageSetProvider pageSetProvider = formElementCaseResultProvider == null ? formElementCaseProvider.generateNewPageSet(map, (WidgetSessionIDInfor)formSessionIDInfor) : formElementCaseProvider.generateCachedPageset(formElementCaseResultProvider);
            ResultWorkBookProvider resultWorkBookProvider = formElementCaseProvider.getResultBook(map);
            try {
                formElementCaseProvider.export(outputStream, resultWorkBookProvider, new PageSetCreater(){

                    public PageSetProvider createPageSet() {
                        return pageSetProvider;
                    }
                }, httpServletRequest, (SessionIDInfor)formSessionIDInfor, declareRecordType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

