/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.worksheet;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.TableData;
import com.fr.base.headerfooter.FormulaHFElement;
import com.fr.base.headerfooter.HFElement;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.io.attr.ReportExportAttr;
import com.fr.main.TemplateWorkBook;
import com.fr.main.parameter.ReportParameterAttr;
import com.fr.main.parameter.TemplateParameterAttr;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.privilege.finegrain.WorkSheetPrivilegeControl;
import com.fr.report.block.ElementCaseBlockImplement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.TemplateCellCaseCreator;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.C;
import com.fr.report.core.A.J;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.elementcase.mod.InsertDeleteRowOrColumnAction;
import com.fr.report.extension.AttributeTarget;
import com.fr.report.extension.AttributeTargetPool;
import com.fr.report.report.AbstractECReport;
import com.fr.report.report.ResultReport;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.LayerReportAttr;
import com.fr.report.stable.WorkSheetAttr;
import com.fr.report.stable.fun.Actor;
import com.fr.report.worksheet.TemplateElementCaseBlockImplement;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.attr.ReportWebAttr;
import com.fr.xml.ReportXMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkSheet
extends AbstractECReport
implements TemplateReport,
TemplateElementCase {
    private static final double NUM = 6.5;
    private static final long serialVersionUID = -8922304295595224713L;
    public static final String REPORT_NAME_COMPATIBLE0651WORKSHEET = "Compatible0651WorkSheet";
    private WorkSheetAttr workSheetAttr = null;
    private LayerReportAttr layerReportAttr = null;
    private boolean isPaintSelection = true;
    private WorkSheetPrivilegeControl workSheetPrivilegeControl;
    private Map<String, AttributeTarget> attributeTargetMap;

    public void setPaintSelection(boolean bl) {
        this.isPaintSelection = bl;
    }

    public boolean isPaintSelection() {
        return this.isPaintSelection;
    }

    @Override
    public TemplateWorkBook getTemplateWorkBook() {
        return (TemplateWorkBook)super.getBook();
    }

    @Override
    public void setTemplateWorkBook(TemplateWorkBook templateWorkBook) {
        super.setBook(templateWorkBook);
    }

    public TemplateReport getTemplateReport() {
        return this;
    }

    public void addAttributeTarget(AttributeTarget attributeTarget) {
        if (this.attributeTargetMap == null) {
            this.attributeTargetMap = new HashMap<String, AttributeTarget>();
        }
        this.attributeTargetMap.put(attributeTarget.xmlTag(), attributeTarget);
    }

    public <T> T getAttributeTarget(String string) {
        if (this.attributeTargetMap == null) {
            return null;
        }
        AttributeTarget attributeTarget = this.attributeTargetMap.get(string);
        if (attributeTarget != null) {
            return (T)attributeTarget;
        }
        return null;
    }

    @Override
    public void addCellElement(TemplateCellElement templateCellElement) {
        super.addCellElement(templateCellElement);
    }

    @Override
    public void addCellElement(TemplateCellElement templateCellElement, boolean bl) {
        super.addCellElement(templateCellElement, bl);
    }

    @Override
    public boolean removeCellElement(TemplateCellElement templateCellElement) {
        if (templateCellElement == null) {
            return true;
        }
        return super.removeCellElement(templateCellElement);
    }

    @Override
    public TemplateCellElement getTemplateCellElement(int n2, int n3) {
        return (TemplateCellElement)super.getCellElement(n2, n3);
    }

    @Override
    public TemplateCellElement removeTemplateCellElement(int n2, int n3) {
        return (TemplateCellElement)super.removeCellElement(n2, n3);
    }

    private void compatibleTableDataRead(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            final String string = xMLableReader.getAttrAsString("name", null);
            if (ComparatorUtils.equals((String)"NameTableData", (String)xMLableReader.getTagName())) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)xMLableReader.getTagName(), (String)"TableData")) {
                            TableData tableData = DataCoreXmlUtils.readXMLTableData((XMLableReader)xMLableReader);
                            WorkSheet.this.getTemplateWorkBook().putTableData(string, tableData);
                        }
                    }
                });
            } else {
                TableData tableData = DataCoreXmlUtils.readXMLTableData((XMLableReader)xMLableReader);
                this.getTemplateWorkBook().putTableData(string, tableData);
            }
        }
    }

    public WorkSheetAttr getWorkSheetAttr() {
        return this.workSheetAttr;
    }

    public void setWorkSheetAttr(WorkSheetAttr workSheetAttr) {
        this.workSheetAttr = workSheetAttr;
    }

    public LayerReportAttr getLayerReportAttr() {
        return this.layerReportAttr;
    }

    public void setLayerReportAttr(LayerReportAttr layerReportAttr) {
        this.layerReportAttr = layerReportAttr;
    }

    @Override
    public WorkSheetPrivilegeControl getWorkSheetPrivilegeControl() {
        if (this.workSheetPrivilegeControl == null) {
            this.workSheetPrivilegeControl = new WorkSheetPrivilegeControl();
        }
        return this.workSheetPrivilegeControl;
    }

    @Override
    public void setWorkSheetPrivilegeControl(WorkSheetPrivilegeControl workSheetPrivilegeControl) {
        this.workSheetPrivilegeControl = workSheetPrivilegeControl;
    }

    @Override
    public ResultReport execute(Map<String, Object> map, Actor actor) {
        WorkSheet workSheet;
        try {
            workSheet = (WorkSheet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        if (actor.canCalculateOnDemand() && this.layerReportAttr != null) {
            if (this.layerReportAttr.isPageQuery()) {
                return new C(workSheet, map, this.layerReportAttr.getCountPerPage());
            }
            return new A(workSheet, map);
        }
        J j2 = new J(workSheet, map, null, workSheet.getTableDataSource());
        return j2.execute(actor);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (this.getTemplateWorkBook() != null) {
                xMLableReader = this.readNotEmptyWorkBook(xMLableReader, string);
            }
            String string2 = null;
            if ("WorkSheetAttr".equals(string)) {
                if (this.workSheetAttr == null) {
                    this.workSheetAttr = new WorkSheetAttr();
                }
                xMLableReader.readXMLObject((XMLReadable)this.workSheetAttr);
            } else if ("LayerAttr".equals(string)) {
                if (Boolean.valueOf(xMLableReader.getElementValue()).booleanValue()) {
                    this.setLayerReportAttr(new LayerReportAttr());
                }
            } else if ("ElementCase".equals(string)) {
                this.setElementCase(xMLableReader);
            } else if ("LayerReportAttr".equals(string)) {
                if (this.getLayerReportAttr() == null) {
                    this.setLayerReportAttr(new LayerReportAttr());
                }
                xMLableReader.readXMLObject((XMLReadable)this.getLayerReportAttr());
            } else if (string.equals("SheetRegion")) {
                this.setSheetRegion(string2, xMLableReader);
            } else {
                for (String string3 : AttributeTargetPool.getKeySet()) {
                    AttributeTarget attributeTarget;
                    if (!string3.equals(string) || (attributeTarget = AttributeTargetPool.buildByTag(string3)) == null) continue;
                    xMLableReader.readXMLObject((XMLReadable)attributeTarget);
                    this.addAttributeTarget(attributeTarget);
                }
                this.readOthers(string, xMLableReader);
            }
        }
    }

    private void readOthers(String string, XMLableReader xMLableReader) {
        if ("ReportPageAttr".equals(string)) {
            ReportPageAttrProvider reportPageAttrProvider = (ReportPageAttrProvider)StableFactory.createXmlObject((String)"ReportPageAttr");
            xMLableReader.readXMLObject((XMLReadable)reportPageAttrProvider);
            this.setReportPageAttr(reportPageAttrProvider);
        } else if ("CellElementList".equals(string)) {
            this.setCellElementList(xMLableReader);
        } else if ("FloatElementList".equals(string)) {
            ArrayList arrayList = new ArrayList();
            ReportXMLUtils.readFloatElementList(xMLableReader, arrayList, this.block);
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.block.addFloatElement((FloatElement)arrayList.get(i2));
            }
        } else if ("PrivilegeControl".equals(string)) {
            WorkSheetPrivilegeControl workSheetPrivilegeControl = new WorkSheetPrivilegeControl();
            xMLableReader.readXMLObject((XMLReadable)workSheetPrivilegeControl);
            this.setWorkSheetPrivilegeControl(workSheetPrivilegeControl);
        }
    }

    private void setElementCase(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    WorkSheet.this.block.readXML(xMLableReader);
                }
            }
        });
    }

    private void setCellElementList(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement();
                    xMLableReader.readXMLObject((XMLReadable)defaultTemplateCellElement);
                    WorkSheet.this.addCellElement(defaultTemplateCellElement, false);
                }
            }
        });
    }

    private void setSheetRegion(String string, XMLableReader xMLableReader) {
        ReportPageAttrProvider reportPageAttrProvider = this.getReportPageAttr();
        if (reportPageAttrProvider == null) {
            reportPageAttrProvider = (ReportPageAttrProvider)StableFactory.createXmlObject((String)"ReportPageAttr");
            this.setReportPageAttr(reportPageAttrProvider);
        }
        if ((string = xMLableReader.getAttrAsString("prhf", null)) != null) {
            reportPageAttrProvider.setRepeatHeaderRowFrom(this.parseIntWithoutException(string));
        }
        if ((string = xMLableReader.getAttrAsString("drf", null)) != null) {
            reportPageAttrProvider.setRepeatHeaderRowTo(this.parseIntWithoutException(string));
        }
        if ((string = xMLableReader.getAttrAsString("prff", null)) != null) {
            reportPageAttrProvider.setRepeatFooterRowFrom(this.parseIntWithoutException(string));
        }
        if ((string = xMLableReader.getAttrAsString("frff", null)) != null) {
            reportPageAttrProvider.setRepeatFooterRowTo(this.parseIntWithoutException(string));
        }
        if ((string = xMLableReader.getAttrAsString("pcht", null)) != null) {
            reportPageAttrProvider.setRepeatHeaderColumnFrom(0);
            reportPageAttrProvider.setRepeatHeaderColumnTo(this.parseIntWithoutException(string));
        }
        if ((string = xMLableReader.getAttrAsString("pcff", null)) != null) {
            reportPageAttrProvider.setRepeatFooterColumnFrom(this.parseIntWithoutException(string));
        }
    }

    private XMLableReader readNotEmptyWorkBook(XMLableReader xMLableReader, String string) {
        if (REPORT_NAME_COMPATIBLE0651WORKSHEET.equals(this.getTemplateWorkBook().getReportName(0))) {
            if ("TableDataMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isAttr()) {
                            WorkSheet.this.getTemplateWorkBook().clearAllTableData();
                        }
                        WorkSheet.this.compatibleTableDataRead(xMLableReader);
                    }
                });
            } else if ("ReportWebAttr".equals(string)) {
                ReportWebAttr reportWebAttr = this.getTemplateWorkBook().getReportWebAttr();
                if (reportWebAttr == null) {
                    reportWebAttr = new ReportWebAttr();
                    this.getTemplateWorkBook().setReportWebAttr(reportWebAttr);
                }
                xMLableReader.readXMLObject((XMLReadable)reportWebAttr);
            } else if ("ReportParameterAttr".equals(string)) {
                ReportParameterAttr reportParameterAttr = this.getTemplateWorkBook().getReportParameterAttr();
                if (reportParameterAttr == null) {
                    reportParameterAttr = new ReportParameterAttr();
                    this.getTemplateWorkBook().setReportParameterAttr(reportParameterAttr);
                }
                xMLableReader.readXMLObject((XMLReadable)reportParameterAttr);
            } else if ("ReportExportAttr".equals(string)) {
                ReportExportAttr reportExportAttr = this.getTemplateWorkBook().getReportExportAttr();
                if (reportExportAttr == null) {
                    reportExportAttr = new ReportExportAttr();
                    this.getTemplateWorkBook().setReportExportAttr(reportExportAttr);
                }
                xMLableReader.readXMLObject((XMLReadable)reportExportAttr);
            }
        } else {
            this.nowWorkBook(xMLableReader, string);
        }
        return xMLableReader;
    }

    private void nowWorkBook(XMLableReader xMLableReader, String string) {
        Object object;
        if (xMLableReader.getXMLVersion().getVersion() < 6.5) {
            if ("TableDataMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WorkSheet.this.compatibleTableDataRead(xMLableReader);
                    }
                });
            } else if ("ReportParameterAttr".equals(string)) {
                object = new ReportParameterAttr();
                xMLableReader.readXMLObject((XMLReadable)object);
                if (this.getTemplateWorkBook().getReportParameterAttr() == null) {
                    this.getTemplateWorkBook().setReportParameterAttr((ReportParameterAttr)object);
                } else {
                    Parameter[] parameterArray = ((TemplateParameterAttr)object).getParameters();
                    for (int i2 = 0; i2 < parameterArray.length; ++i2) {
                        this.getTemplateWorkBook().getReportParameterAttr().addParameter(parameterArray[i2]);
                    }
                }
            }
        }
        if (this.getTemplateWorkBook() != null && "ReportWebAttr".equals(string)) {
            if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_XML_VERSION()) {
                object = new ReportWebAttr();
                xMLableReader.readXMLObject((XMLReadable)object);
                this.webReportAtr((ReportWebAttr)object);
            }
        } else if (this.getTemplateWorkBook() != null && "ReportExportAttr".equals(string) && (object = this.getTemplateWorkBook().getReportExportAttr()) == null) {
            object = new ReportExportAttr();
            this.getTemplateWorkBook().setReportExportAttr((ReportExportAttr)object);
            xMLableReader.readXMLObject((XMLReadable)object);
        }
    }

    private void webReportAtr(ReportWebAttr reportWebAttr) {
        ReportWebAttr reportWebAttr2 = this.getTemplateWorkBook().getReportWebAttr();
        if (reportWebAttr2 == null) {
            this.getTemplateWorkBook().setReportWebAttr(reportWebAttr);
        } else {
            int n2;
            if (reportWebAttr.getWebPage() != null) {
                if (reportWebAttr2.getWebPage() == null) {
                    reportWebAttr2.setWebPage(reportWebAttr.getWebPage());
                } else if (reportWebAttr2.getWebPage().getToolBarManagers() == null) {
                    reportWebAttr2.getWebPage().setToolBarManagers(reportWebAttr.getWebPage().getToolBarManagers());
                }
            }
            if (reportWebAttr.getWebWrite() != null) {
                if (reportWebAttr2.getWebWrite() == null) {
                    reportWebAttr2.setWebWrite(reportWebAttr.getWebWrite());
                } else if (reportWebAttr2.getWebWrite().getToolBarManagers() == null) {
                    reportWebAttr2.getWebWrite().setToolBarManagers(reportWebAttr.getWebWrite().getToolBarManagers());
                }
            }
            if (reportWebAttr.getBackground() != null && reportWebAttr2.getBackground() == null) {
                reportWebAttr2.setBackground(reportWebAttr.getBackground());
            }
            if (reportWebAttr.getPrinter() != null && reportWebAttr2.getPrinter() == null) {
                reportWebAttr2.setPrinter(reportWebAttr.getPrinter());
            }
            int n3 = reportWebAttr.getCSSImportCount();
            for (n2 = 0; n2 < n3; ++n2) {
                reportWebAttr2.addCSSImport(reportWebAttr.getCSSImport(n2));
            }
            n3 = reportWebAttr.getJSImportCount();
            for (n2 = 0; n2 < n3; ++n2) {
                reportWebAttr2.addJSImport(reportWebAttr.getJSImport(n2));
            }
            if (StringUtils.isNotBlank((String)reportWebAttr.getTitle()) && StringUtils.isBlank((String)reportWebAttr2.getTitle())) {
                reportWebAttr2.setTitle(reportWebAttr.getTitle());
            }
        }
    }

    private int parseIntWithoutException(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Object object;
        super.writeXML(xMLPrintWriter);
        if (this.workSheetAttr != null) {
            this.workSheetAttr.writeXML(xMLPrintWriter);
        }
        if (this.layerReportAttr != null) {
            this.layerReportAttr.writeXML(xMLPrintWriter);
        }
        if (this.attributeTargetMap != null) {
            object = this.attributeTargetMap.values().iterator();
            while (object.hasNext()) {
                AttributeTarget attributeTarget = (AttributeTarget)object.next();
                attributeTarget.writeXML(xMLPrintWriter);
            }
        }
        if ((object = this.getWorkSheetPrivilegeControl()) != null) {
            ((WorkSheetPrivilegeControl)object).writeXML(xMLPrintWriter);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof WorkSheet && super.equals(object) && ComparatorUtils.equals((Object)this.workSheetAttr, (Object)((WorkSheet)object).workSheetAttr) && ComparatorUtils.equals((Object)this.layerReportAttr, (Object)((WorkSheet)object).layerReportAttr) && ComparatorUtils.equals(this.attributeTargetMap, ((WorkSheet)object).attributeTargetMap);
    }

    @Override
    public void cloneWithoutCellCase(AbstractECReport abstractECReport) throws CloneNotSupportedException {
        super.cloneWithoutCellCase(abstractECReport);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WorkSheet workSheet = (WorkSheet)super.clone();
        if (this.workSheetAttr != null) {
            workSheet.workSheetAttr = (WorkSheetAttr)this.workSheetAttr.clone();
        }
        if (this.layerReportAttr != null) {
            workSheet.layerReportAttr = (LayerReportAttr)this.layerReportAttr.clone();
        }
        if (this.attributeTargetMap != null) {
            HashMap<String, AttributeTarget> hashMap = new HashMap<String, AttributeTarget>();
            for (Map.Entry<String, AttributeTarget> entry : this.attributeTargetMap.entrySet()) {
                hashMap.put(entry.getKey(), (AttributeTarget)entry.getValue().clone());
            }
            workSheet.attributeTargetMap = hashMap;
        }
        workSheet.workSheetPrivilegeControl = (WorkSheetPrivilegeControl)this.getWorkSheetPrivilegeControl().clone();
        return workSheet;
    }

    @Override
    protected ElementCaseBlockImplement createElementCaseBlockImplement() {
        return new TemplateElementCaseBlockImplement(TemplateCellCaseCreator.getInstance());
    }

    protected CellElement createDefaultCellElementCase() {
        return new DefaultTemplateCellElement();
    }

    @Override
    protected Object __mod_column_row(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (super.__mod_column_row(mOD_COLUMN_ROW) == null) {
            return null;
        }
        this.setFormula(mOD_COLUMN_ROW);
        if (this.attributeTargetMap != null) {
            for (AttributeTarget attributeTarget : this.attributeTargetMap.values()) {
                attributeTarget.__mod_column_row(mOD_COLUMN_ROW, this);
            }
        }
        this.__mod_write_frozen(mOD_COLUMN_ROW);
        WorkSheetAttr workSheetAttr = this.getWorkSheetAttr();
        if (workSheetAttr != null && workSheetAttr.getDirection() != 2 && mOD_COLUMN_ROW instanceof InsertDeleteRowOrColumnAction) {
            ((InsertDeleteRowOrColumnAction)mOD_COLUMN_ROW).mod_sheetAttr(workSheetAttr);
        }
        return mOD_COLUMN_ROW;
    }

    private void __mod_write_frozen(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.getReportSettings() == null) {
            return;
        }
        ReportSettingsProvider reportSettingsProvider = null;
        try {
            reportSettingsProvider = (ReportSettingsProvider)this.getReportSettings().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage());
        }
        ColumnRow columnRow = mOD_COLUMN_ROW.mod_columnrow(reportSettingsProvider.getWriteFrozenColumnRow());
        reportSettingsProvider.setWriteFrozenColumnRow(columnRow);
        this.setReportSettings(reportSettingsProvider);
    }

    private void setFormula(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        for (int i2 = 0; i2 <= 4; ++i2) {
            String string;
            HFElement hFElement;
            int n2;
            ReportHFProvider reportHFProvider;
            if (this.getHeader(i2) != null) {
                reportHFProvider = this.getHeader(i2);
                reportHFProvider = this.set(reportHFProvider, mOD_COLUMN_ROW);
            }
            if (this.getFooter(i2) == null) continue;
            reportHFProvider = this.getFooter(i2);
            for (n2 = 0; n2 < reportHFProvider.getLeftList().size(); ++n2) {
                hFElement = (HFElement)reportHFProvider.getLeftList().get(n2);
                if (!(hFElement instanceof FormulaHFElement) || (string = ((FormulaHFElement)hFElement).getFormulaContent()) == null) continue;
                ((FormulaHFElement)hFElement).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(string));
            }
            for (n2 = 0; n2 < reportHFProvider.getCenterList().size(); ++n2) {
                hFElement = (HFElement)reportHFProvider.getCenterList().get(n2);
                if (!(hFElement instanceof FormulaHFElement) || (string = ((FormulaHFElement)hFElement).getFormulaContent()) == null) continue;
                ((FormulaHFElement)hFElement).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(string));
            }
            for (n2 = 0; n2 < reportHFProvider.getRightList().size(); ++n2) {
                hFElement = (HFElement)reportHFProvider.getRightList().get(n2);
                if (!(hFElement instanceof FormulaHFElement) || (string = ((FormulaHFElement)hFElement).getFormulaContent()) == null) continue;
                ((FormulaHFElement)hFElement).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(string));
            }
        }
    }

    private ReportHFProvider set(ReportHFProvider reportHFProvider, MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        String string;
        HFElement hFElement;
        int n2;
        for (n2 = 0; n2 < reportHFProvider.getLeftList().size(); ++n2) {
            hFElement = (HFElement)reportHFProvider.getLeftList().get(n2);
            if (!(hFElement instanceof FormulaHFElement) || (string = ((FormulaHFElement)hFElement).getFormulaContent()) == null) continue;
            ((FormulaHFElement)hFElement).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(string));
        }
        for (n2 = 0; n2 < reportHFProvider.getCenterList().size(); ++n2) {
            hFElement = (HFElement)reportHFProvider.getCenterList().get(n2);
            if (!(hFElement instanceof FormulaHFElement) || (string = ((FormulaHFElement)hFElement).getFormulaContent()) == null) continue;
            ((FormulaHFElement)hFElement).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(string));
        }
        for (n2 = 0; n2 < reportHFProvider.getRightList().size(); ++n2) {
            hFElement = (HFElement)reportHFProvider.getRightList().get(n2);
            if (!(hFElement instanceof FormulaHFElement) || (string = ((FormulaHFElement)hFElement).getFormulaContent()) == null) continue;
            ((FormulaHFElement)hFElement).setFormulaContent(mOD_COLUMN_ROW.mod_fm_statement(string));
        }
        return reportHFProvider;
    }
}

