/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.worksheet;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.data.Dictionary;
import com.fr.data.TableDataSource;
import com.fr.data.impl.CustomDictionary;
import com.fr.form.FormElementCaseProvider;
import com.fr.form.FormElementCaseResultProvider;
import com.fr.form.FormProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteInfo;
import com.fr.general.FArray;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.LogDuration;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.PageExcelExporter;
import com.fr.json.JSONObject;
import com.fr.log.LogUtils;
import com.fr.main.FineBook;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PageSetCreater;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.privilege.finegrain.WorkSheetPrivilegeControl;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.ResultWorkBookProvider;
import com.fr.report.cell.AbstractCellElement;
import com.fr.report.cell.AbstractDynamicCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.cell.cellattr.highlight.HighlightGroup;
import com.fr.report.core.A.A;
import com.fr.report.core.A.J;
import com.fr.report.core.A._;
import com.fr.report.core.A.b;
import com.fr.report.core.A.l;
import com.fr.report.core.ReportHF;
import com.fr.report.core.ReportParameterHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.AbstractElementCase;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.fun.ReportHeavyTDProcessor;
import com.fr.report.report.AbstractECReport;
import com.fr.report.stable.ReportAttrSet;
import com.fr.report.stable.ReportSettings;
import com.fr.report.stable.WorkSheetAttr;
import com.fr.report.utils.ElementCaseHelper;
import com.fr.report.worksheet.ElementCaseResultWorkSheet;
import com.fr.report.worksheet.PageRWorkSheet;
import com.fr.script.Calculator;
import com.fr.script.CalculatorNameSpace;
import com.fr.script.CurrentValueNameSpace;
import com.fr.stable.ColumnRow;
import com.fr.stable.DependenceProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.html.Tag;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.script.NameSpace;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WidgetSessionIDInfor;
import com.fr.web.output.html.HTMLOutlet;
import com.fr.web.output.html.chwriter.PageCellWriter;
import com.fr.web.utils.WebUtils;
import com.fr.xml.SynchronizedStyleList;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormElementCase
extends AbstractElementCase
implements TemplateElementCase,
FormElementCaseProvider {
    private TableDataSource datasource;
    private ReportAttrSet reportAttrSet = new ReportAttrSet();
    private WorkSheetAttr workSheetAttr = null;
    private transient String name;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public WorkSheetAttr getWorkSheetAttr() {
        if (this.workSheetAttr == null) {
            this.workSheetAttr = new WorkSheetAttr();
        }
        return this.workSheetAttr;
    }

    public void setWorkSheetAttr(WorkSheetAttr workSheetAttr) {
        this.workSheetAttr = workSheetAttr;
    }

    public void executeAll(WidgetSessionIDInfor widgetSessionIDInfor, Map<String, Object> map) {
        ResultWorkBook resultWorkBook;
        if (widgetSessionIDInfor.getElementCaseResult(this.name) != null) {
            return;
        }
        if (ConfigManager.getProviderInstance().getLogConfig().isRecordExe4form()) {
            FRLogManager.setSession((LogDuration)widgetSessionIDInfor);
            String string = FRLogger.createParamString(map);
            FRLogManager.declareExecuteStart((String)widgetSessionIDInfor.getBookPath(), (String)string, (DeclareRecordType)DeclareRecordType.EXECUTE_TYPE_FORM);
            long l2 = System.currentTimeMillis();
            resultWorkBook = (ResultWorkBook)this.getResultBook(map);
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            LogUtils.performanceRecord(resultWorkBook, l4);
            ExecuteInfo executeInfo = new ExecuteInfo(string, l4, FRLogManager.getDeclareSQLContent(), LogUtils.calResultWorkBookMemory(resultWorkBook));
            LogUtils.recordExecuteInfo(widgetSessionIDInfor.getBookPath(), DeclareRecordType.EXECUTE_TYPE_FORM, executeInfo);
        } else {
            resultWorkBook = (ResultWorkBook)this.getResultBook(map);
        }
        int n2 = resultWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            FormElementCaseResultProvider formElementCaseResultProvider = (FormElementCaseResultProvider)resultWorkBook.getResultReport(i2);
            widgetSessionIDInfor.putElementCaseResult(resultWorkBook.getReportName(i2), formElementCaseResultProvider);
        }
    }

    public ResultWorkBookProvider getResultBook(Map<String, Object> map) {
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        com.fr.report.core.A.B.A a2 = new com.fr.report.core.A.B.A((FormProvider)this.datasource, map);
        return a2.B();
    }

    public ResultWorkBook getElementCaseResultBook(ResultWorkBook resultWorkBook) {
        ResultWorkBook resultWorkBook2 = null;
        try {
            resultWorkBook2 = (ResultWorkBook)resultWorkBook.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage());
        }
        for (int i2 = resultWorkBook.getReportCount() - 1; i2 >= 0; --i2) {
            if (ComparatorUtils.equalsIgnoreCase((String)resultWorkBook.getReportName(i2), (String)this.name)) continue;
            resultWorkBook2.removeReport(i2);
        }
        return resultWorkBook2;
    }

    public boolean renameTableData(String string, String string2) {
        try {
            ElementCaseHelper.renameTableData(this, string, string2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void export(OutputStream outputStream, ResultWorkBookProvider resultWorkBookProvider, PageSetCreater pageSetCreater, HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, DeclareRecordType declareRecordType) {
        ResultWorkBook resultWorkBook = this.getElementCaseResultBook((ResultWorkBook)resultWorkBookProvider);
        ExcelExporter excelExporter = ComparatorUtils.equalsIgnoreCase((String)"excelO", (String)declareRecordType.getTypeString()) ? new ExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)) : new PageExcelExporter(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook));
        excelExporter.setVersion(WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"isExcel2003"));
        try {
            if (excelExporter == null || sessionIDInfor == null || outputStream == null) {
                return;
            }
            LogUtils.exportAndLogRecord(excelExporter, outputStream, new ReportRepositoryDeal(httpServletRequest, sessionIDInfor, 96), declareRecordType, (LogDuration)sessionIDInfor, sessionIDInfor.getBookPath(), resultWorkBook, pageSetCreater);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public Object getCellElementValue(int n2, int n3) {
        CellElement cellElement = this.getCellElement(n2, n3);
        return cellElement == null ? "" : cellElement.getValue();
    }

    public int resolveExpandAttr(WidgetSessionIDInfor widgetSessionIDInfor, String string) {
        ColumnRowRange columnRowRange;
        ElementCaseResultWorkSheet elementCaseResultWorkSheet = (ElementCaseResultWorkSheet)widgetSessionIDInfor.getElementCaseResult(this.name);
        if (elementCaseResultWorkSheet == null || StringUtils.isEmpty((String)string)) {
            return 0;
        }
        J j2 = elementCaseResultWorkSheet.getSe();
        List<A> list = j2.resolveColumnRowRange(columnRowRange = ColumnRowRange.columnRow2Range((ColumnRow)ColumnRow.valueOf((String)string)));
        boolean bl = list == null || list.isEmpty();
        return bl ? 0 : this.getCellExpandDir(list.get(0));
    }

    public Object resolveVariable(WidgetSessionIDInfor widgetSessionIDInfor, ColumnRowRange columnRowRange, CalculatorProvider calculatorProvider) {
        ElementCaseResultWorkSheet elementCaseResultWorkSheet = (ElementCaseResultWorkSheet)widgetSessionIDInfor.getElementCaseResult(this.name);
        if (elementCaseResultWorkSheet == null) {
            return null;
        }
        J j2 = elementCaseResultWorkSheet.getSe();
        CalculatorNameSpace calculatorNameSpace = new CalculatorNameSpace((Calculator)calculatorProvider);
        j2.calculator.pushNameSpace((NameSpace)calculatorNameSpace);
        j2.calculator.setCurrentFromColumnRow(null);
        List<A> list = j2.resolveColumnRowRange(columnRowRange);
        list = this.sortColumnRowRange(list, columnRowRange, j2);
        int n2 = list == null ? 0 : list.size();
        FArray fArray = new FArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getCellValue(list.get(i2));
            int n3 = this.getCellExpandSize(list.get(i2));
            for (int i3 = 0; i3 < n3; ++i3) {
                fArray.add(object);
            }
        }
        return fArray;
    }

    public CellExpandAttr getCellNotEmptyExpandAttr(ColumnRowRange columnRowRange, J j2) {
        TemplateCellElement templateCellElement;
        b b2;
        ColumnRow columnRow = columnRowRange.getFrom().getTargetColumnRow();
        TemplateCellElement templateCellElement2 = this.getTemplateCellElement(columnRow.column, columnRow.row);
        if (templateCellElement2 == null) {
            return null;
        }
        CellExpandAttr cellExpandAttr = templateCellElement2.getCellExpandAttr();
        String string = cellExpandAttr == null ? null : cellExpandAttr.getSortFormula();
        b b3 = b2 = j2.getCellFamilyMember(columnRow.column, columnRow.row);
        if (b3.B == null && b3.A == null) {
            return null;
        }
        while (string == null && b3 != null && b3.B != null) {
            b3 = b3.B;
            templateCellElement = this.getTemplateCellElement(b3.E.getColumn(), b3.E.getRow());
            cellExpandAttr = templateCellElement.getCellExpandAttr();
            string = cellExpandAttr == null ? null : cellExpandAttr.getSortFormula();
        }
        b3 = b2;
        while (string == null && b3 != null && b3.A != null) {
            b3 = b3.A;
            templateCellElement = this.getTemplateCellElement(b3.E.getColumn(), b3.E.getRow());
            cellExpandAttr = templateCellElement.getCellExpandAttr();
            string = cellExpandAttr == null ? null : cellExpandAttr.getSortFormula();
        }
        return cellExpandAttr;
    }

    private List<A> sortColumnRowRange(List<A> list, ColumnRowRange columnRowRange, J j2) {
        int n2;
        if (list == null || list.isEmpty() || columnRowRange.getTo() != null) {
            return list;
        }
        CellExpandAttr cellExpandAttr = this.getCellNotEmptyExpandAttr(columnRowRange, j2);
        if (cellExpandAttr == null) {
            return list;
        }
        String string = StringUtils.cutStringStartWith((String)cellExpandAttr.getSortFormula(), (String)"=");
        if (StringUtils.isBlank((String)string)) {
            return list;
        }
        l[] lArray = new l[list.size()];
        CurrentValueNameSpace currentValueNameSpace = new CurrentValueNameSpace(null);
        j2.calculator.pushNameSpace((NameSpace)currentValueNameSpace);
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object object = null;
            currentValueNameSpace.setCurrentValue(list.get(n2).getValue());
            try {
                object = j2.calculator.evalValue(string);
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().error(utilEvalError.getMessage());
            }
            if (object instanceof FArray) {
                object = ((FArray)object).elementAt(n2);
            }
            lArray[n2] = new l(list.get(n2), object);
        }
        j2.calculator.removeNameSpace((NameSpace)currentValueNameSpace);
        Arrays.sort(lArray, new _(cellExpandAttr.getOrder()));
        n3 = lArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            list.set(n2, lArray[n2].A());
            list.get(n2).mark_result_index(n2 + 1);
        }
        return list;
    }

    private Object getCellValue(CellElement cellElement) {
        Object object = cellElement.getValue();
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        if (object == null) {
            object = Primitive.NULL;
        }
        return object;
    }

    private int getCellExpandDir(CellElement cellElement) {
        CellExpandAttr cellExpandAttr = cellElement.getCellExpandAttr();
        return cellExpandAttr == null ? (byte)0 : cellExpandAttr.getDirection();
    }

    private int getCellExpandSize(CellElement cellElement) {
        boolean bl = this.getCellExpandDir(cellElement) == 1;
        return bl ? cellElement.getColumnSpan() : cellElement.getRowSpan();
    }

    public PageSetProvider generateNewPageSet(Map<String, Object> map, WidgetSessionIDInfor widgetSessionIDInfor) {
        if (widgetSessionIDInfor == null) {
            return PageSetProvider.EMPTY_PAGE;
        }
        this.executeAll(widgetSessionIDInfor, map);
        FormElementCaseResultProvider formElementCaseResultProvider = widgetSessionIDInfor.getElementCaseResult(this.name);
        if (formElementCaseResultProvider == null) {
            return PageSetProvider.EMPTY_PAGE;
        }
        return this.generateCachedPageset(formElementCaseResultProvider);
    }

    public PageSetProvider generateCachedPageset(FormElementCaseResultProvider formElementCaseResultProvider) {
        formElementCaseResultProvider.setReportSettings(this.getReportSettings());
        FU fU = FU.getInstance((long)Integer.MAX_VALUE);
        PaperSettingProvider paperSettingProvider = this.initPaperSetting((UNIT)fU, (UNIT)fU);
        return formElementCaseResultProvider.generateReportPageSet(paperSettingProvider);
    }

    public void toJsonTag(int n2, HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, PrintWriter printWriter, String string, PageSetProvider pageSetProvider) {
        ReportPageProvider reportPageProvider = pageSetProvider.getPage(n2 - 1);
        reportPageProvider = reportPageProvider.deriveResolution(96);
        try {
            JSONObject jSONObject = reportPageProvider.toJSONObject((Repository)new ReportRepositoryDeal(httpServletRequest, sessionIDInfor, 96));
            printWriter.write(jSONObject.toString());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        printWriter.flush();
        printWriter.close();
    }

    public void toHtmlTag(int n2, HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, PrintWriter printWriter, String string, PageSetProvider pageSetProvider) throws Exception {
        ReportPageProvider reportPageProvider = pageSetProvider.getPage(n2 - 1);
        reportPageProvider = reportPageProvider.deriveResolution(96);
        Tag tag = this.createAndfillPageContentTag(sessionIDInfor, reportPageProvider, httpServletRequest, string);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("htmlTag", (Object)tag.toString());
            jSONObject.put("totalPage", pageSetProvider.size());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        printWriter.write(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private PaperSettingProvider initPaperSetting(int n2, int n3) {
        int n4 = 96;
        FU fU = FU.valueOfPix((int)n2, (int)n4);
        FU fU2 = FU.valueOfPix((int)n3, (int)n4);
        return this.initPaperSetting((UNIT)fU, (UNIT)fU2);
    }

    private PaperSettingProvider initPaperSetting(UNIT uNIT, UNIT uNIT2) {
        PaperSettingProvider paperSettingProvider = (PaperSettingProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"PaperSetting", PaperSettingProvider.class);
        paperSettingProvider.setPaperSize(new PaperSize(uNIT, uNIT2));
        paperSettingProvider.setMargin(new Margin((UNIT)UNIT.ZERO, (UNIT)UNIT.ZERO, (UNIT)UNIT.ZERO, (UNIT)UNIT.ZERO));
        return paperSettingProvider;
    }

    private Tag createAndfillPageContentTag(SessionIDInfor sessionIDInfor, ReportPageProvider reportPageProvider, HttpServletRequest httpServletRequest, String string) throws Exception {
        Tag tag = new Tag("div").cls("pageContentDIV").ids(string);
        ReportRepositoryDeal reportRepositoryDeal = new ReportRepositoryDeal(httpServletRequest, sessionIDInfor, 96);
        PageCellWriter pageCellWriter = new PageCellWriter((Repository)reportRepositoryDeal, 0, new ReportSettings(), false);
        pageCellWriter.setQuickModel(reportRepositoryDeal.getBrowser().isQuirksModel());
        ReportHeavyTDProcessor reportHeavyTDProcessor = (ReportHeavyTDProcessor)ExtraReportClassManager.getInstance().getSingle("ReportHeavyTDProcessor");
        if (reportHeavyTDProcessor != null) {
            pageCellWriter.setUseLightHeavyTD(reportHeavyTDProcessor.shouldUseLightHeavyTD(sessionIDInfor));
        }
        this.writeContent(tag, reportPageProvider, pageCellWriter, (Repository)reportRepositoryDeal);
        return tag;
    }

    private void writeContent(Tag tag, ReportPageProvider reportPageProvider, PageCellWriter pageCellWriter, Repository repository) throws Exception {
        if (repository.getBrowser().shouldRelativePosition4ZoomCSS()) {
            tag.css("position", "relative");
        }
        HTMLOutlet hTMLOutlet = new HTMLOutlet(reportPageProvider, pageCellWriter, repository);
        ColumnRow columnRow = reportPageProvider.getReportPageAttr() == null ? null : reportPageProvider.getReportPageAttr().getFreezeColumnRow();
        hTMLOutlet.setFrozenColumnRow(columnRow);
        hTMLOutlet.setShowHeaderAndFooter(true);
        hTMLOutlet.out(tag);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            Object var3_3 = null;
            if ("ElementCase".equals(string)) {
                this.readElementCase(xMLableReader);
            } else if ("CellElementList".equals(string)) {
                this.readCellElementList(xMLableReader);
            } else if ("ReportAttrSet".equals(string)) {
                if (this.reportAttrSet == null) {
                    this.reportAttrSet = new ReportAttrSet();
                }
                xMLableReader.readXMLObject((XMLReadable)this.reportAttrSet);
            } else if ("WorkSheetAttr".equals(string)) {
                if (this.workSheetAttr == null) {
                    this.workSheetAttr = new WorkSheetAttr();
                }
                xMLableReader.readXMLObject((XMLReadable)this.workSheetAttr);
            }
        }
    }

    private void readElementCase(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    FormElementCase.super.readXML(xMLableReader);
                }
            }
        });
    }

    private void readCellElementList(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement();
                    xMLableReader.readXMLObject((XMLReadable)defaultTemplateCellElement);
                    FormElementCase.this.addCellElement((CellElement)defaultTemplateCellElement, false);
                }
            }
        });
    }

    public void cloneWithoutCellCase(AbstractECReport abstractECReport) throws CloneNotSupportedException {
        if (abstractECReport == null) {
            return;
        }
        abstractECReport.getBlock().setBlockName(this.getName());
        super.cloneWithoutCellCase(abstractECReport.getBlock());
    }

    @Override
    protected CellElement createDefaultCellElementCase() {
        return new DefaultTemplateCellElement();
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.reportAttrSet != null) {
            this.reportAttrSet.writeXML(xMLPrintWriter);
        }
        if (this.workSheetAttr != null) {
            this.workSheetAttr.writeXML(xMLPrintWriter);
        }
    }

    public void writeStyleXML(XMLPrintWriter xMLPrintWriter) {
        SynchronizedStyleList.getSynchronizedStyleList().xmlizeStyleList(xMLPrintWriter);
    }

    public void readStyleXML(XMLableReader xMLableReader) {
        SynchronizedStyleList.getSynchronizedStyleList().deXmlizeStyleList(xMLableReader);
    }

    public BufferedImage toImage(Calculator calculator, int n2, int n3) {
        return this.toImage(calculator, n2, n3, Collections.EMPTY_MAP, false);
    }

    public BufferedImage toImage(Calculator calculator, int n2, int n3, Map<String, Object> map, boolean bl) {
        if (this.datasource == null) {
            this.setTabledataSource((TableDataSource)calculator.getAttribute(TableDataSource.KEY));
        }
        ResultWorkBook resultWorkBook = (ResultWorkBook)this.getResultBook(map);
        PageRWorkSheet pageRWorkSheet = new PageRWorkSheet();
        int n4 = resultWorkBook.getReportCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!ComparatorUtils.equalsIgnoreCase((String)resultWorkBook.getReportName(i2), (String)this.name)) continue;
            pageRWorkSheet = (PageRWorkSheet)resultWorkBook.getResultReport(i2);
            break;
        }
        PaperSettingProvider paperSettingProvider = this.initPaperSetting(n2, n3);
        PageSetProvider pageSetProvider = pageRWorkSheet.generateReportPageSet(paperSettingProvider);
        ReportPageProvider reportPageProvider = pageSetProvider.getPage(0);
        reportPageProvider = reportPageProvider.deriveResolution(96);
        BufferedImage bufferedImage = (BufferedImage)reportPageProvider.toImage(false, false);
        return bl ? bufferedImage.getSubimage(0, 0, reportPageProvider.getContentWidth(), reportPageProvider.getContentHeight()) : bufferedImage;
    }

    public void setTabledataSource(TableDataSource tableDataSource) {
        this.datasource = tableDataSource;
    }

    public TableDataSource getTableDataSource() {
        return this.datasource;
    }

    public boolean isElementCaseReport() {
        return true;
    }

    @Override
    public void addCellElement(TemplateCellElement templateCellElement) {
        this.addCellElement(templateCellElement, true);
    }

    @Override
    public void addCellElement(TemplateCellElement templateCellElement, boolean bl) {
        if (templateCellElement == null) {
            return;
        }
        super.addCellElement(templateCellElement, bl);
    }

    @Override
    public boolean removeCellElement(TemplateCellElement templateCellElement) {
        if (templateCellElement == null) {
            return true;
        }
        return super.removeCellElement(templateCellElement);
    }

    @Override
    public TemplateCellElement getTemplateCellElement(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            throw new UnsupportedOperationException();
        }
        return (TemplateCellElement)super.getCellElement(n2, n3);
    }

    @Override
    public TemplateCellElement removeTemplateCellElement(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            throw new UnsupportedOperationException();
        }
        return (TemplateCellElement)super.removeCellElement(n2, n3);
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        Cloneable cloneable;
        Iterator iterator = this.cellIterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            HighlightGroup highlightGroup;
            String[] stringArray;
            cloneable = (DefaultTemplateCellElement)iterator.next();
            Object object = ((AbstractCellElement)cloneable).getValue();
            if (object instanceof DependenceProvider) {
                stringArray = ((DependenceProvider)object).dependence(calculatorProvider);
                arrayList.addAll(Arrays.asList(stringArray));
            }
            if ((stringArray = ((AbstractDynamicCellElement)cloneable).getPresent()) != null) {
                arrayList.addAll(Arrays.asList(stringArray.dependence(calculatorProvider)));
            }
            if ((highlightGroup = ((AbstractDynamicCellElement)cloneable).getHighlightGroup()) == null) continue;
            arrayList.addAll(Arrays.asList(highlightGroup.dependence(calculatorProvider)));
        }
        cloneable = new HashSet(arrayList);
        return ((HashSet)cloneable).toArray(new String[((HashSet)cloneable).size()]);
    }

    public FineBook getBook() {
        throw new UnsupportedOperationException();
    }

    public void setHeader(int n2, ReportHF reportHF) {
        throw new UnsupportedOperationException();
    }

    public void setFooter(int n2, ReportHF reportHF) {
        throw new UnsupportedOperationException();
    }

    public ReportHFProvider getHeader(int n2) {
        throw new UnsupportedOperationException();
    }

    public ReportHFProvider getFooter(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setReportSettings(ReportSettingsProvider reportSettingsProvider) {
        this.reportAttrSet.setReportSettings(reportSettingsProvider);
    }

    public ReportSettingsProvider getReportSettings() {
        return this.reportAttrSet.getReportSettings();
    }

    public Iterator iteratorOfElementCase() {
        throw new UnsupportedOperationException();
    }

    public TemplateWorkBook getTemplateWorkBook() {
        throw new UnsupportedOperationException();
    }

    public void setTemplateWorkBook(TemplateWorkBook templateWorkBook) {
        throw new UnsupportedOperationException();
    }

    public WorkSheetPrivilegeControl getWorkSheetPrivilegeControl() {
        throw new UnsupportedOperationException();
    }

    public void setWorkSheetPrivilegeControl(WorkSheetPrivilegeControl workSheetPrivilegeControl) {
        throw new UnsupportedOperationException();
    }

    public void convertCellElementDictionary(Map map) {
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            ReportParameterHelper.collectValueTableData(templateCellElement.getValue(), map);
            Dictionary dictionary = CellUtils.getDictionary(templateCellElement);
            if (dictionary == null) continue;
            CellUtils.setDictionary(templateCellElement, (Dictionary)this.customify(dictionary));
        }
    }

    private CustomDictionary customify(Dictionary dictionary) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (dictionary != null) {
            Iterator iterator = dictionary.entrys(Calculator.createCalculator());
            while (iterator.hasNext()) {
                Dictionary.MV mV = (Dictionary.MV)iterator.next();
                arrayList.add(mV.getModel());
                arrayList2.add(mV.getView());
            }
        }
        return new CustomDictionary(arrayList.toArray(), arrayList2.toArray());
    }
}

