/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.base.FRContext;
import com.fr.form.ui.Button;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.Widget;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.web.Location;
import com.fr.report.web.button.Email;
import com.fr.report.web.button.ExcelP;
import com.fr.report.web.button.Export;
import com.fr.report.web.button.FlashPrint;
import com.fr.report.web.button.PDF;
import com.fr.report.web.button.PDFPrint;
import com.fr.report.web.button.PageSetup;
import com.fr.report.web.button.Print;
import com.fr.report.web.button.PrintPreview;
import com.fr.report.web.button.ServerPrint;
import com.fr.report.web.button.page.First;
import com.fr.report.web.button.page.Last;
import com.fr.report.web.button.page.Next;
import com.fr.report.web.button.page.PageNavi;
import com.fr.report.web.button.page.Previous;
import com.fr.report.web.button.write.AppendColumnRow;
import com.fr.report.web.button.write.ShowCellValue;
import com.fr.report.web.button.write.Submit;
import com.fr.report.web.button.write.Verify;
import com.fr.script.Calculator;
import com.fr.stable.Mapper;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ToolBarManager
implements Serializable,
Cloneable,
XMLReadable {
    public static final String XML_TAG = "ToolBarManager";
    private Location toolBarLocation;
    private ToolBar toolBar;

    public static ToolBarManager createDefaultToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new First(), new Previous(), new PageNavi(), new Next(), new Last(), new FlashPrint(), new Print(), new Export(), new Email()}));
        return toolBarManager;
    }

    public static ToolBarManager createPrintPreviewToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new First(), new Previous(), new PageNavi(), new Next(), new Last(), new FlashPrint(), new Print(), new Export()}));
        return toolBarManager;
    }

    public static ToolBarManager createDefaultViewToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new PageSetup(), new PrintPreview(), new FlashPrint(), new Print(), new Export(), new Email()}));
        return toolBarManager;
    }

    public static ToolBarManager createDefaultFormToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new FlashPrint(), new Print(), new Export(), new Email()}));
        return toolBarManager;
    }

    public static ToolBarManager createDefaultWriteToolBar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new Submit(), new Verify(), new FlashPrint(), new Print(), new Export(), new Email(), new AppendColumnRow(), new ShowCellValue()}));
        return toolBarManager;
    }

    public static ToolBarManager createDefaultWriteOfflineToolbar() {
        ToolBarManager toolBarManager = new ToolBarManager();
        toolBarManager.setToolBar(new ToolBar(new Widget[]{new Submit(true), new Verify()}));
        return toolBarManager;
    }

    public Location getToolBarLocation() {
        return this.toolBarLocation;
    }

    public void setToolBarLocation(Location location) {
        this.toolBarLocation = location;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        Location.writeXML(this.toolBarLocation, xMLPrintWriter);
        if (this.toolBar != null) {
            this.toolBar.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        Object object;
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("toolbarPosition", null);
            if (string != null) {
                this.setToolBarLocation(Location.createEmbedLocation(Integer.parseInt(string)));
            }
            object = new ArrayList();
            object.add(new First());
            object.add(new Previous());
            object.add(new PageNavi());
            object.add(new Next());
            object.add(new Last());
            boolean bl = true;
            boolean bl2 = true;
            string = xMLableReader.getAttrAsString("isIconVisible", null);
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            if ((string = xMLableReader.getAttrAsString("isTextVisible", null)) != null) {
                bl2 = Boolean.valueOf(string);
            }
            this.readAndAddWidget(xMLableReader, string, (List)object);
            this.dealWithComponentsOnVisible((List)object, bl, bl2);
            if (!object.isEmpty()) {
                this.toolBar = new ToolBar(object.toArray(new Widget[object.size()]));
            }
        }
        if (xMLableReader.isChildNode()) {
            object = xMLableReader.getTagName();
            if ("ToolBar".equals(object)) {
                this.toolBar = new ToolBar();
                xMLableReader.readXMLObject((XMLReadable)this.toolBar);
            } else if ("Location".equals(object)) {
                this.toolBarLocation = Location.readXML(xMLableReader);
            }
        }
    }

    private void readAndAddWidget(XMLableReader xMLableReader, String string, List list) {
        string = xMLableReader.getAttrAsString("isShowFlashPrint", null);
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new FlashPrint());
        }
        if ((string = xMLableReader.getAttrAsString("isShowPDFPrint", null)) != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new PDFPrint());
        }
        if ((string = xMLableReader.getAttrAsString("isShowPDF", null)) != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new PDF());
        }
        if ((string = xMLableReader.getAttrAsString("isShowExcel", null)) != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new ExcelP());
        }
        if ((string = xMLableReader.getAttrAsString("isShowPrint", null)) != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new ServerPrint());
        }
        if ((string = xMLableReader.getAttrAsString("isShowExport", null)) != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new Export());
        }
        if ((string = xMLableReader.getAttrAsString("isShowEmail", null)) != null && Boolean.valueOf(string).booleanValue()) {
            list.add(new Email());
        }
    }

    private void dealWithComponentsOnVisible(List list, boolean bl, boolean bl2) {
        if (!bl) {
            StableUtils.map((List)list, (Mapper)new Mapper(){

                public Object map(int n2, Object object, List list) {
                    ((Button)object).setIconName(null);
                    return object;
                }
            });
        }
        if (!bl2) {
            StableUtils.map((List)list, (Mapper)new Mapper(){

                public Object map(int n2, Object object, List list) {
                    ((Button)object).setText(null);
                    return object;
                }
            });
        }
    }

    public JSONObject toJSONConfig(Repository repository, Calculator calculator) {
        JSONObject jSONObject = new JSONObject();
        Location location = this.getToolBarLocation();
        if (location == null) {
            location = Location.createTopEmbedLocation();
        }
        if (location instanceof Location.Embed) {
            try {
                jSONObject.put("position", (Object)(((Location.Embed)location).getPosition() == 1 ? "north" : "south"));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            }
        }
        try {
            jSONObject.put("toolbarConf", (Object)this.getToolBar().createJSONConfig(repository, calculator, null));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
        return jSONObject;
    }

    public boolean isBottomPos() {
        Location location = this.getToolBarLocation();
        if (location instanceof Location.Embed) {
            return ((Location.Embed)location).getPosition() == 3;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        ToolBarManager toolBarManager = (ToolBarManager)super.clone();
        if (this.toolBar != null) {
            toolBarManager.toolBar = (ToolBar)this.toolBar.clone();
        }
        return toolBarManager;
    }
}

