/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.stable;

import com.fr.general.ComparatorUtils;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.core.ReportHF;
import com.fr.report.stable.ReportSettings;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReportAttrSet
implements XMLable {
    public static final String XML_TAG = "ReportAttrSet";
    private ReportSettingsProvider reportSettings = null;
    private Hashtable headerHash = new Hashtable();
    private Hashtable footerHash = new Hashtable();

    public ReportAttrSet() {
        this.reportSettings = new ReportSettings();
    }

    public ReportSettingsProvider getReportSettings() {
        return this.reportSettings;
    }

    public void setReportSettings(ReportSettingsProvider reportSettingsProvider) {
        this.reportSettings = reportSettingsProvider;
    }

    public ReportHFProvider getHeader(int n2) {
        ReportHF reportHF = (ReportHF)this.headerHash.get(new Integer(n2));
        if (reportHF == null && n2 == 0) {
            reportHF = new ReportHF();
            this.headerHash.put(new Integer(n2), reportHF);
        }
        return reportHF;
    }

    public void setHeader(int n2, ReportHF reportHF) {
        if (reportHF == null) {
            this.headerHash.remove(new Integer(n2));
        } else {
            this.headerHash.put(new Integer(n2), reportHF);
        }
    }

    public ReportHFProvider getFooter(int n2) {
        ReportHF reportHF = (ReportHF)this.footerHash.get(new Integer(n2));
        if (reportHF == null && n2 == 0) {
            reportHF = new ReportHF();
            this.footerHash.put(new Integer(n2), reportHF);
        }
        return reportHF;
    }

    public void setFooter(int n2, ReportHF reportHF) {
        if (reportHF == null) {
            this.footerHash.remove(new Integer(n2));
        } else {
            this.footerHash.put(new Integer(n2), reportHF);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Header")) {
                this.readReportHF(xMLableReader, true);
            } else if (string.equals("Footer")) {
                this.readReportHF(xMLableReader, false);
            } else if ("ReportSettings".equals(string)) {
                ReportSettingsProvider reportSettingsProvider = this.getReportSettings();
                if (reportSettingsProvider == null) {
                    reportSettingsProvider = new ReportSettings();
                    this.setReportSettings(reportSettingsProvider);
                }
                xMLableReader.readXMLObject((XMLReadable)reportSettingsProvider);
            }
        }
    }

    protected void readReportHF(XMLableReader xMLableReader, boolean bl) {
        ReportHF reportHF = new ReportHF();
        if (bl) {
            this.setHeader(xMLableReader.getAttrAsInt("reportPageType", 0), reportHF);
        } else {
            this.setFooter(xMLableReader.getAttrAsInt("reportPageType", 0), reportHF);
        }
        reportHF.readXML(xMLableReader);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        ReportHF reportHF;
        Object object;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.reportSettings != null) {
            this.reportSettings.writeXML(xMLPrintWriter);
        }
        Enumeration enumeration = this.headerHash.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            reportHF = (ReportHF)this.headerHash.get(object);
            reportHF.writeXML(xMLPrintWriter, true, (Integer)object);
        }
        object = this.footerHash.keys();
        while (object.hasMoreElements()) {
            reportHF = object.nextElement();
            ReportHF reportHF2 = (ReportHF)this.footerHash.get(reportHF);
            reportHF2.writeXML(xMLPrintWriter, false, (Integer)((Object)reportHF));
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Object object;
        ReportAttrSet reportAttrSet = (ReportAttrSet)super.clone();
        if (this.reportSettings != null) {
            reportAttrSet.reportSettings = (ReportSettings)this.reportSettings.clone();
        }
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.headerHash.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            hashtable.put(object, ((ReportHF)this.headerHash.get(object)).clone());
        }
        reportAttrSet.headerHash = hashtable;
        object = new Hashtable();
        Enumeration enumeration2 = this.footerHash.keys();
        while (enumeration2.hasMoreElements()) {
            Object k2 = enumeration2.nextElement();
            ((Hashtable)object).put(k2, (Object)((ReportHF)this.footerHash.get(k2)).clone());
        }
        reportAttrSet.footerHash = object;
        return reportAttrSet;
    }

    public boolean equals(Object object) {
        return object instanceof ReportAttrSet && ComparatorUtils.equals((Object)this.reportSettings, (Object)((ReportAttrSet)object).reportSettings) && ComparatorUtils.equals((Object)this.headerHash, (Object)((ReportAttrSet)object).headerHash) && ComparatorUtils.equals((Object)this.footerHash, (Object)((ReportAttrSet)object).footerHash);
    }
}

