/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.core;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.itf25.ITF25Barcode;
import com.fr.report.cell.painter.barcode.line.code128.Code128Barcode;
import com.fr.report.cell.painter.barcode.line.code128.UCCEAN128Barcode;
import com.fr.report.cell.painter.barcode.line.code39.Code39Barcode;
import com.fr.report.cell.painter.barcode.line.codebar.CodabarBarcode;
import com.fr.report.cell.painter.barcode.line.ean13.EAN13Barcode;
import com.fr.report.cell.painter.barcode.pdf417.PDF417Barcode;
import com.fr.report.cell.painter.barcode.qrcode.QRcodeBarcode;

public final class BarcodeFactory {
    private BarcodeFactory() {
    }

    public static BarcodeImpl createCode128(String string) throws BarcodeException {
        return new Code128Barcode(string, 3);
    }

    public static BarcodeImpl createCode128A(String string) throws BarcodeException {
        return new Code128Barcode(string, 0);
    }

    public static BarcodeImpl createCode128B(String string) throws BarcodeException {
        return new Code128Barcode(string, 1);
    }

    public static BarcodeImpl createCode128C(String string) throws BarcodeException {
        return new Code128Barcode(string, 2);
    }

    public static BarcodeImpl createUCC128(String string, String string2) throws BarcodeException {
        return new UCCEAN128Barcode(string, string2);
    }

    public static BarcodeImpl createEAN128(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static BarcodeImpl createEAN13(String string) throws BarcodeException {
        return new EAN13Barcode(string);
    }

    public static BarcodeImpl createUSPS(String string) throws BarcodeException {
        return new UCCEAN128Barcode("420", string);
    }

    public static BarcodeImpl createShipmentIdentificationNumber(String string) throws BarcodeException {
        return new UCCEAN128Barcode("402", string);
    }

    public static BarcodeImpl createSSCC18(String string) throws BarcodeException {
        return new UCCEAN128Barcode("00", string);
    }

    public static BarcodeImpl createSCC14ShippingCode(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static BarcodeImpl createGlobalTradeItemNumber(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static BarcodeImpl createPDF417(String string) throws BarcodeException {
        return new PDF417Barcode(string);
    }

    public static BarcodeImpl createCode39(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static BarcodeImpl createCodabar(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static BarcodeImpl createUSD4(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static BarcodeImpl createNW7(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static BarcodeImpl createMonarch(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static BarcodeImpl create2of7(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static BarcodeImpl createQRcode(String string) throws BarcodeException {
        return new QRcodeBarcode(string);
    }

    public static BarcodeImpl createITF25(String string, int n2, double d2, boolean bl) throws BarcodeException {
        return new ITF25Barcode(string, n2, d2, bl);
    }
}

