/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell;

import com.fr.base.BaseUtils;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.general.Background;
import com.fr.general.FRFont;
import com.fr.report.cell.AnalyCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.CellElementCaseCreator;
import com.fr.report.cell.DefaultViewCellElement;
import com.fr.report.report.AnalyECReport;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class EditCellCaseCreator
implements CellElementCaseCreator {
    private static EditCellCaseCreator SC = new EditCellCaseCreator();

    private EditCellCaseCreator() {
    }

    public static EditCellCaseCreator getInstance() {
        return SC;
    }

    public CellElement createDefaultCellElementCase() {
        return new EditCellELement();
    }

    public static class EditCellELement
    extends DefaultViewCellElement {
        private static final int B = 2;
        private static final int I = 4;
        private static final int U = 8;
        private static final int ST = 16;
        private static final int BTOP = 2;
        private static final int BRIGHT = 4;
        private static final int BBOTTOM = 8;
        private static final int BLEFT = 16;
        private boolean valueDirty = false;
        private String fontName = null;
        private int fontSize = -1;
        private Color fontColor = null;
        private int fontStyle = -1;
        private int borderStyle = -1;
        private Color backgroundColor = null;
        private int horizontal_alignment = -1;
        private int vertical_alignment = -1;

        public void readXML(XMLableReader xMLableReader) {
            super.readXML(xMLableReader);
            if (xMLableReader.isAttr()) {
                int n2;
                this.valueDirty = xMLableReader.getAttrAsInt("vd", 0) == 1;
                String string = xMLableReader.getAttrAsString("ff", null);
                if (string != null) {
                    this.fontName = string;
                }
                this.fontSize = xMLableReader.getAttrAsInt("fs", -1);
                string = xMLableReader.getAttrAsString("fc", null);
                if (string != null) {
                    this.fontColor = new Color(Integer.parseInt(string.substring(1), 16));
                }
                this.fontStyle = xMLableReader.getAttrAsInt("ft", -1);
                this.borderStyle = xMLableReader.getAttrAsInt("br", -1);
                string = xMLableReader.getAttrAsString("bg", null);
                if (string != null) {
                    this.backgroundColor = new Color(Integer.parseInt(string.substring(1), 16));
                }
                if ((string = xMLableReader.getAttrAsString("ta", null)) != null) {
                    n2 = Integer.parseInt(string);
                    this.horizontal_alignment = n2 == 0 ? 2 : (n2 == 1 ? 0 : 4);
                }
                if ((string = xMLableReader.getAttrAsString("va", null)) != null) {
                    n2 = Integer.parseInt(string);
                    this.vertical_alignment = n2 == 0 ? 1 : (n2 == 1 ? 0 : 3);
                }
            }
        }

        public void checkDirtyValueAndStyle(AnalyCellElement analyCellElement, AnalyECReport analyECReport) {
            int n2;
            int n3;
            FRFont fRFont;
            if (analyECReport == null) {
                return;
            }
            if (analyCellElement == null) {
                analyCellElement = new DefaultViewCellElement(this.getColumn(), this.getRow(), this.getColumnSpan(), this.getRowSpan(), this.getValue());
                analyECReport.addCellElement(analyCellElement, false);
            } else if (this.valueDirty) {
                analyCellElement.setValue(this.getValue());
            }
            Style style = analyCellElement.getStyle();
            if (style == null) {
                analyCellElement.setStyle(Style.DEFAULT_STYLE);
            }
            FRFont fRFont2 = fRFont = style.getFRFont();
            if (fRFont == null) {
                fRFont2 = FRFont.getInstance();
            }
            if (this.fontName != null) {
                fRFont2 = fRFont2.applyName(this.fontName);
            }
            if (this.fontSize > 0) {
                fRFont2 = fRFont2.applySize((float)this.fontSize);
            }
            if (this.fontColor != null) {
                fRFont2 = fRFont2.applyForeground(this.fontColor);
            }
            if (this.fontStyle > 0) {
                n3 = 0;
                if ((this.fontStyle & 2) != 0) {
                    ++n3;
                }
                if ((this.fontStyle & 4) != 0) {
                    n3 += 2;
                }
                if (n3 != fRFont2.getStyle()) {
                    fRFont2 = fRFont2.applyStyle(n3);
                }
                int n4 = n3 = (this.fontStyle & 8) != 0 ? 1 : 0;
                if (n3 != fRFont2.getUnderline()) {
                    fRFont2 = fRFont2.applyUnderline(n3);
                }
                int n5 = n2 = (this.fontStyle & 0x10) != 0 ? 1 : 0;
                if (n2 != fRFont2.isStrikethrough()) {
                    fRFont2 = fRFont2.applyStrikethrough(n2 != 0);
                }
            }
            if (fRFont2 != fRFont) {
                style = style.deriveFRFont(fRFont2);
            }
            if (this.backgroundColor != null) {
                style = style.deriveBackground((Background)ColorBackground.getInstance((Color)this.backgroundColor));
            }
            if (this.borderStyle > 0) {
                n3 = (this.borderStyle & 2) != 0 ? 1 : 0;
                n2 = (this.borderStyle & 4) != 0 ? 1 : 0;
                int n6 = (this.borderStyle & 8) != 0 ? 1 : 0;
                int n7 = (this.borderStyle & 0x10) != 0 ? 1 : 0;
                style = style.deriveBorder(n3, Color.black, n6, Color.black, n7, Color.black, n2, Color.black);
            }
            if (this.horizontal_alignment >= 0 && this.horizontal_alignment != BaseUtils.getAlignment4Horizontal((Style)style)) {
                style = style.deriveHorizontalAlignment(this.horizontal_alignment);
            }
            if (this.vertical_alignment >= 0 && this.vertical_alignment != style.getVerticalAlignment()) {
                style = style.deriveVerticalAlignment(this.vertical_alignment);
            }
            analyCellElement.setStyle(style);
        }
    }
}

