/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell;

import com.fr.base.Formula;
import com.fr.base.ResultFormula;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.report.cell.AbstractDynamicCellElement;
import com.fr.report.cell.AnalyCellElement;
import com.fr.report.cell.cellattr.core.attribute.AnalyCellElementAttribute;
import com.fr.report.cell.cellattr.core.attribute.CellElementAttribute;
import com.fr.report.cell.cellattr.core.attribute.CompatibelCellElementAttribute;
import com.fr.stable.FCloneable;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;

public abstract class AbstractAnalyCellElement
extends AbstractDynamicCellElement
implements AnalyCellElement {
    private int flState = 0;
    private Object presentValue = null;
    private static final String FLSTATE = "FLSTATE";
    private static final String PV_XML_TAG = "PV";
    private static final int SELF_FL = 8192;

    public int getFlState() {
        return this.flState;
    }

    public void setFlState(int n2) {
        this.flState = n2;
    }

    private Object getPresentValue() {
        return this.presentValue;
    }

    public void setPresentValue(Object object) {
        this.presentValue = object;
    }

    public Object getShowValue() {
        if (this.getPresent() != null) {
            return this.getPresentValue();
        }
        return this.getValue();
    }

    public boolean isExist() {
        return this.getFlState() <= 0;
    }

    public boolean isSelfFilter() {
        return (this.flState & 0x2000) != 0;
    }

    public void setSelfFilter(boolean bl) {
        this.flState = bl ? (this.flState |= 0x2000) : (this.flState &= 0xFFFFDFFF);
    }

    public void addSonBoxCE(AbstractAnalyCellElement abstractAnalyCellElement) {
    }

    public int getAnalysisType() {
        if (this.getBoxElement() == null) {
            return 0;
        }
        return this.getBoxElement().getAnalysisType();
    }

    public int getSortType() {
        if (this.getBoxElement() == null) {
            return 0;
        }
        return this.getBoxElement().getSortType();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Object object;
        super.writeXML(xMLPrintWriter);
        if (this.flState != 0) {
            xMLPrintWriter.startTAG(FLSTATE).textNode(this.flState + "").end();
        }
        if ((object = this.getPresentValue()) != null) {
            xMLPrintWriter.startTAG(PV_XML_TAG);
            GeneralXMLTools.writeObject((XMLPrintWriter)xMLPrintWriter, (Object)object);
            xMLPrintWriter.end();
        }
        if (this.getBoxElement() != null) {
            xMLPrintWriter.startTAG("BE").attr("col", this.getBoxElement().getBEB().getColumnIndex()).attr("row", this.getBoxElement().getBEB().getRowIndex()).attr("idx", this.getBoxElement().getBEIndex()).end();
        }
    }

    protected Object dealWithSaveValue4Compatible(Object object) {
        if (object instanceof Formula && !((Formula)object).isResult()) {
            object = new ResultFormula((Formula)object);
        }
        return object;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (FLSTATE.equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.flState = Integer.parseInt(string2);
                }
            } else if (PV_XML_TAG.equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("O")) {
                            AbstractAnalyCellElement.this.setPresentValue(GeneralXMLTools.readObject((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if ("EAttribute".equals(string)) {
                ExtraXMLReader extraXMLReader = new ExtraXMLReader();
                xMLableReader.readXMLObject((XMLReadable)extraXMLReader);
                CellElementAttribute cellElementAttribute = extraXMLReader.getKey();
                Object object = extraXMLReader.getValue();
                if (cellElementAttribute != null && object != null) {
                    if (cellElementAttribute == CompatibelCellElementAttribute.ANALY_FILTERED) {
                        this.flState += ((Integer)object).intValue();
                    } else if (cellElementAttribute == CompatibelCellElementAttribute.ANALY_SELF_FILTERED) {
                        this.setSelfFilter((Boolean)object);
                    }
                }
            }
        }
    }

    protected CellElementAttribute getHighLightGroupAttr() {
        return AnalyCellElementAttribute.HIGHLIGHTGROUP;
    }

    protected CellElementAttribute getPresentAttr() {
        return AnalyCellElementAttribute.PRESENT;
    }

    protected CellElementAttribute getWidgetAttr() {
        return AnalyCellElementAttribute.WIDGET;
    }

    protected CellElementAttribute getCellGUIAttrAttr() {
        return AnalyCellElementAttribute.CELLGUIATTR;
    }

    protected CellElementAttribute getNameHyperLinkGroupAttr() {
        return AnalyCellElementAttribute.NAMEHYPERLINKGROUP;
    }

    protected CellElementAttribute getPageAttr() {
        return AnalyCellElementAttribute.PAGE;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractAnalyCellElement abstractAnalyCellElement = (AbstractAnalyCellElement)super.clone();
        if (this.getPresentValue() != null && this.getPresentValue() instanceof FCloneable) {
            abstractAnalyCellElement.setPresentValue(((FCloneable)this.getPresentValue()).clone());
        }
        return abstractAnalyCellElement;
    }

    public boolean isWriter() {
        return false;
    }

    public boolean isView() {
        return true;
    }

    private static class ExtraXMLReader
    implements XMLReadable {
        private CellElementAttribute key;
        private Object v;

        private ExtraXMLReader() {
        }

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode()) {
                String string = xMLableReader.getTagName();
                if ("CEA".equals(string)) {
                    this.key = CompatibelCellElementAttribute.readXMLToAttr(xMLableReader);
                } else if ("O".equals(string)) {
                    this.v = GeneralXMLTools.readObject((XMLableReader)xMLableReader);
                }
            }
        }

        public CellElementAttribute getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.v;
        }
    }
}

