/*
 * Decompiled with CFR 0.152.
 */
package com.fr.print.db;

import com.fr.cluster.rpc.RPC;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.JDBCDataAccessObjectOperator;
import com.fr.data.dao.JDBCDataAccessObjectProperties;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.file.BaseClusterHelper;
import com.fr.print.OffsetIPRelativeAction;
import com.fr.print.PrinterOffsetAction;
import com.fr.web.core.A.BA;
import com.fr.web.core.A.Z;
import com.fr.web.core.db.PlatformDB;

public class PrintDBHelper {
    private static JDBCDataAccessObjectOperator jdbcDaoManager = null;

    private static JDBCDataAccessObjectOperator getJDBCDAOManager() {
        if (jdbcDaoManager == null) {
            JDBCDataAccessObjectProperties jDBCDataAccessObjectProperties = new JDBCDataAccessObjectProperties(){

                public JDBCDatabaseConnection createDatabaseConnection() {
                    return PlatformDB.getDB();
                }

                public ObjectTableMapper[] getAllObjTableMappers() {
                    return new ObjectTableMapper[]{PrinterOffsetAction.OBJECT_MAPPER, OffsetIPRelativeAction.OBJECT_MAPPER};
                }
            };
            jdbcDaoManager = new Z(jDBCDataAccessObjectProperties.createDatabaseConnection(), jDBCDataAccessObjectProperties.getAllObjTableMappers());
        }
        return jdbcDaoManager;
    }

    public static DataAccessObjectSession createDAOSession() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                DataAccessObjectSession dataAccessObjectSession = PrintDBHelper.getJDBCDAOManager().startSession();
                RPC.registerSkeleton((Object)dataAccessObjectSession);
                return dataAccessObjectSession;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                return (DataAccessObjectSession)RPC.getProxy(BA.class, (String)string);
            }
        }
        return PrintDBHelper.getJDBCDAOManager().startSession();
    }
}

