/*
 * Decompiled with CFR 0.152.
 */
package com.fr.main.impl;

import com.fr.base.ConfigManager;
import com.fr.base.ConfigManagerProvider;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.base.io.XMLReadHelper;
import com.fr.base.parameter.ParameterUI;
import com.fr.data.TableDataSource;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.Widget;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.main.AbstractTemplateWorkBook;
import com.fr.main.SynchronizedReportSettings;
import com.fr.main.parameter.ReportParameterAttr;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ReportSettingsProvider;
import com.fr.privilege.PrivilegeEditedRoleProvider;
import com.fr.privilege.finegrain.CellPrivilegeControl;
import com.fr.privilege.finegrain.ColumnRowPrivilegeControl;
import com.fr.privilege.finegrain.FloatPrivilegeControl;
import com.fr.privilege.finegrain.WidgetPrivilegeControl;
import com.fr.report.cell.AbstractWidgetCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.utils.ScriptUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.ReportSettings;
import com.fr.report.stable.fun.Actor;
import com.fr.report.utils.ElementCaseHelper;
import com.fr.report.web.ToolBarManager;
import com.fr.report.worksheet.WorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.ListMap;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import com.fr.xml.SynchronizedFrozenColumnRow;
import java.awt.Dimension;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkBook
extends AbstractTemplateWorkBook
implements PrivilegeEditedRoleProvider {
    public static final String XML_TAG = "WorkBook";
    public static final String STRING_TO_FORMULA = "string2Formula";

    public WorkBook() {
    }

    public WorkBook(TemplateReport templateReport) {
        this.addReport(templateReport);
    }

    public void addReport(int n2, TemplateReport templateReport) {
        super.addReport(n2, null, templateReport);
    }

    public void addReport(int n2, String string, TemplateReport templateReport) {
        super.addReport(n2, string, templateReport);
    }

    @Override
    public ResultWorkBook execute(Map map, Actor actor) {
        return this.execute(map, actor, -1);
    }

    @Override
    public ResultWorkBook execute(Map map, Actor actor, int n2) {
        this.apply4Parameters(map);
        if (!actor.getBookFUNC().support() && this.getReportCount() > 1) {
            return actor.createResultBook(map);
        }
        if (this.getReportCount() > 1 && !ReportUtils.hasLayerReport4Template(this)) {
            return actor.executeWorkBook(this, map, n2);
        }
        return actor.createWorkBookExecutor(this, map).execute();
    }

    public Parameter[] getParameters() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.KEY, (Object)this);
        ParameterHelper.addGlobal_ParameterToSet(hashSet);
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        if (reportParameterAttr != null && reportParameterAttr.getParameters() != null) {
            hashSet.addAll(Arrays.asList(reportParameterAttr.getParameters()));
        }
        try {
            int n2 = this.tableDataList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TableData tableData = (TableData)this.tableDataList.get(i2);
                ParameterProvider[] parameterProviderArray = FRContext.getCurrentEnv().getTableDataParameters(tableData);
                if (tableData == null || parameterProviderArray == null) continue;
                hashSet.addAll(Arrays.asList(parameterProviderArray));
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return hashSet.toArray(new Parameter[hashSet.size()]);
    }

    @Override
    public void apply4Parameters(Map map) {
        Object object;
        Parameter[] parameterArray;
        ListMap listMap;
        ConfigManagerProvider configManagerProvider;
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        Calculator calculator = Calculator.createCalculator();
        if (reportParameterAttr != null) {
            configManagerProvider = new ListMap();
            listMap = new ListMap();
            parameterArray = reportParameterAttr.getParameters();
            for (int i2 = 0; i2 < parameterArray.length; ++i2) {
                if (map.get(parameterArray[i2].getName()) == null || this.shouldExecuteParameter(parameterArray[i2])) {
                    configManagerProvider.put((Object)parameterArray[i2].getName(), parameterArray[i2].getValue());
                    continue;
                }
                listMap.put((Object)parameterArray[i2].getName(), map.get(parameterArray[i2].getName()));
            }
            ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create((Map)listMap);
            calculator.pushNameSpace((NameSpace)parameterMapNameSpace);
            object = configManagerProvider.keySet().iterator();
            while (object.hasNext()) {
                ParameterMapNameSpace parameterMapNameSpace2 = ParameterMapNameSpace.create((Map)map);
                calculator.pushNameSpace((NameSpace)parameterMapNameSpace2);
                String string = (String)object.next();
                Object object2 = configManagerProvider.get((Object)string);
                Object object3 = object2 instanceof Formula ? ScriptUtils.executeNormalFormula(calculator, (Formula)object2) : object2;
                map.put(string, object3);
            }
            calculator.removeNameSpace((NameSpace)parameterMapNameSpace);
        }
        if ((listMap = (configManagerProvider = ConfigManager.getProviderInstance()).getGlobal_Parameters()) != null) {
            parameterArray = ParameterMapNameSpace.create((Map)map);
            calculator.pushNameSpace((NameSpace)parameterArray);
            for (int i3 = 0; i3 < ((ListMap)listMap).length; ++i3) {
                if (map.get(listMap[i3].getName()) != null) continue;
                object = listMap[i3].getValue();
                if (object instanceof Formula) {
                    object = ScriptUtils.executeNormalFormula(calculator, (Formula)object);
                }
                map.put(listMap[i3].getName(), object);
            }
            calculator.removeNameSpace((NameSpace)parameterArray);
        }
    }

    private boolean shouldExecuteParameter(Parameter parameter) {
        Object object = parameter.getValue();
        if (!(object instanceof Formula)) {
            return false;
        }
        String string = Utils.objectToString((Object)object);
        return object != null && string.startsWith("=") && string.indexOf(36) != -1;
    }

    public String[] getAllEditedRoleSet() {
        HashSet<String> hashSet = new HashSet<String>();
        this.dealWithToolBar(ReportUtils.getToolBarFromWorkBook(this, 0), hashSet);
        this.dealWithToolBar(ReportUtils.getToolBarFromWorkBook(this, 1), hashSet);
        this.dealWithToolBar(ReportUtils.getToolBarFromWorkBook(this, 3), hashSet);
        this.iteratorParameterUI(hashSet);
        this.iteratorReport(hashSet);
        return new ArrayList<String>(hashSet).toArray(new String[hashSet.size()]);
    }

    private void iteratorParameterUI(HashSet<String> hashSet) {
        Widget[] widgetArray;
        ParameterUI parameterUI;
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        if (reportParameterAttr != null && (parameterUI = reportParameterAttr.getParameterUI()) != null && (widgetArray = parameterUI.getAllWidgets()) != null) {
            for (int i2 = 0; i2 < widgetArray.length; ++i2) {
                this.dealWithWidget(widgetArray[i2], hashSet);
            }
        }
    }

    private void iteratorReport(HashSet<String> hashSet) {
        for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
            Iterator iterator;
            Report report = this.getReport(i2);
            if (report == null) continue;
            if (report instanceof TemplateReport) {
                iterator = ((TemplateReport)report).getWorkSheetPrivilegeControl();
                hashSet.addAll(Arrays.asList(iterator.getAllEditedRoles()));
            }
            iterator = report.iteratorOfElementCase();
            while (iterator.hasNext()) {
                ElementCase elementCase = (ElementCase)iterator.next();
                this.iteratorElementCase(hashSet, elementCase);
                Iterator iterator2 = elementCase.cellIterator();
                while (iterator2.hasNext()) {
                    CellElement cellElement = (CellElement)iterator2.next();
                    CellPrivilegeControl cellPrivilegeControl = cellElement.getCellPrivilegeControl();
                    hashSet.addAll(Arrays.asList(cellPrivilegeControl.getAllEditedRoles()));
                    if (!(cellElement instanceof AbstractWidgetCellElement)) continue;
                    Widget widget = ((AbstractWidgetCellElement)cellElement).getWidget();
                    this.dealWithWidget(widget, hashSet);
                }
            }
        }
    }

    private void iteratorElementCase(HashSet<String> hashSet, ElementCase elementCase) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl;
        int n2;
        int n3 = elementCase.getRowCount();
        int n4 = elementCase.getColumnCount();
        for (n2 = 0; n2 < n3; ++n2) {
            columnRowPrivilegeControl = elementCase.getRowPrivilegeControl(n2);
            hashSet.addAll(Arrays.asList(columnRowPrivilegeControl.getAllEditedRoles()));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            columnRowPrivilegeControl = elementCase.getColumnPrivilegeControl(n2);
            hashSet.addAll(Arrays.asList(columnRowPrivilegeControl.getAllEditedRoles()));
        }
        Iterator iterator = elementCase.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            FloatPrivilegeControl floatPrivilegeControl = floatElement.getFloatPrivilegeControl();
            hashSet.addAll(Arrays.asList(floatPrivilegeControl.getAllEditedRoles()));
        }
    }

    private void dealWithToolBar(ToolBarManager[] toolBarManagerArray, HashSet<String> hashSet) {
        if (toolBarManagerArray == null) {
            return;
        }
        for (int i2 = 0; i2 < toolBarManagerArray.length; ++i2) {
            ToolBar toolBar = toolBarManagerArray[i2].getToolBar();
            for (int i3 = 0; i3 < toolBar.getWidgetSize(); ++i3) {
                Widget widget = toolBar.getWidget(i3);
                this.dealWithWidget(widget, hashSet);
            }
        }
    }

    private void dealWithWidget(Widget widget, HashSet<String> hashSet) {
        if (widget == null) {
            return;
        }
        WidgetPrivilegeControl widgetPrivilegeControl = widget.getWidgetPrivilegeControl();
        hashSet.addAll(Arrays.asList(widgetPrivilegeControl.getAllEditedRoles()));
    }

    public boolean renameTableData(String string, String string2) {
        if (super.renameTableData(string, string2)) {
            if (this.getTableData(string) == null) {
                for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
                    Report report = this.getReport(i2);
                    if (report == null) continue;
                    Iterator iterator = report.iteratorOfElementCase();
                    while (iterator.hasNext()) {
                        ElementCase elementCase = (ElementCase)iterator.next();
                        ElementCaseHelper.renameTableData(elementCase, string, string2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public String openTag() {
        return XML_TAG;
    }

    @Override
    public void mainContentWriteXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter);
    }

    public void readStream(InputStream inputStream) throws Exception {
        this.readStream(inputStream, true);
    }

    public void readStream(InputStream inputStream, boolean bl) throws Exception {
        String string;
        XMLableReader xMLableReader = XMLReadHelper.createXMLableReader((InputStream)inputStream, (String)"UTF-8");
        this.xmlVersion = xMLableReader.getXMLVersion();
        if (xMLableReader == null) {
            throw new RuntimeException(Inter.getLocText((String)"FR-Engine-NS_exception_readError"));
        }
        if (bl) {
            xMLableReader.setContextAttribute((Object)STRING_TO_FORMULA, (Object)bl);
        }
        if (XML_TAG.equals(string = xMLableReader.getTagName())) {
            xMLableReader.readXMLObject((XMLReadable)this);
            this.compatibleParameterUI(xMLableReader);
        } else if ("Report".equals(string)) {
            TemplateReport templateReport = null;
            String string2 = xMLableReader.getAttrAsString("class", null);
            if (string2 != null) {
                Report report = ReportXMLUtils.readReportFromClassName(string2);
                if (report instanceof TemplateReport) {
                    templateReport = (TemplateReport)report;
                } else {
                    throw new Exception("Error Report Class (" + report.getClass().getName() + ") in Template File.");
                }
            }
            if (templateReport == null) {
                templateReport = new WorkSheet();
            }
            this.addReport("Compatible0651WorkSheet", templateReport);
            xMLableReader.readXMLObject((XMLReadable)templateReport);
            this.setReportName(0, "sheet1");
        } else if ("FREncrypted".equals(string)) {
            FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine-ECP_decode_failed"));
        }
        this.compatibleWith6_5();
        SynchronizedFrozenColumnRow.getThreadColumnRowList().set(null);
        xMLableReader.close();
        inputStream.close();
    }

    private void compatibleParameterUI(XMLableReader xMLableReader) {
        if (this.reportParameterAttr != null && this.reportParameterAttr.getParameterUI() != null) {
            this.reportParameterAttr.getParameterUI().convert();
            if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_1_XML_VERSION() && xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                this.reportParameterAttr.getParameterUI().setParameterValueFor_7_0_Version(this.getParameters());
            }
            if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_3_XML_VERSION() && xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION() && this.reportParameterAttr.getParameterUI().isUseDefaultSize()) {
                this.reportParameterAttr.getParameterUI().setDesignSize(new Dimension(800, 200));
            }
        }
    }

    private void compatibleWith6_5() {
        SynchronizedReportSettings.flushSynchronizedReportSettings();
        ColumnRow columnRow = (ColumnRow)SynchronizedFrozenColumnRow.getThreadColumnRowList().get();
        if (columnRow != null) {
            for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
                if (this.getReport(i2) == null) continue;
                ReportSettingsProvider reportSettingsProvider = this.getReport(i2).getReportSettings();
                if (reportSettingsProvider == null) {
                    reportSettingsProvider = new ReportSettings();
                    this.getReport(i2).setReportSettings(reportSettingsProvider);
                }
                reportSettingsProvider.setWriteFrozenColumnRow(columnRow);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof WorkBook;
    }
}

