/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.importer;

import com.fr.base.BaseUtils;
import com.fr.base.CoreDecimalFormat;
import com.fr.base.CustomConfigManager;
import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Margin;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TableData;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.cache.Attachment;
import com.fr.data.TableDataSource;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.io.importer.AbstractExcelPicture;
import com.fr.io.importer.ExcelImportUncertainRect;
import com.fr.io.importer.TemplateBookAdapter;
import com.fr.io.importer.WriteExcelImportException;
import com.fr.main.FineBook;
import com.fr.main.TemplateWorkBook;
import com.fr.main.impl.WorkBook;
import com.fr.main.workbook.WriteWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DynamicAttrElem;
import com.fr.report.cell.WidgetAttrElem;
import com.fr.report.cell.WriteCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.A.A;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.fun.CommentExcelProcessor;
import com.fr.report.fun.ExcelImportProcessor;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.report.WriteECReport;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.Constants;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.StringUtils;
import com.fr.stable.script.NameSpace;
import com.fr.stable.unit.INCH;
import com.fr.stable.unit.OLDPIX;
import com.fr.stable.unit.PT;
import com.fr.stable.unit.UNIT;
import com.fr.stable.xml.FRFile;
import com.fr.third.org.apache.poi.ddf.EscherClientAnchorRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.hssf.record.EscherAggregate;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPictureData;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.web.core.A.wD;
import com.fr.write.WriteException;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelReportImporter {
    private static final int EXCEL_IMPORT_UC_MAPPING_ERR_SIZE = 0;
    private static final int VERTICALROTATION = -165;
    public static int DEFAULT_EXCEL_CELL_WIDTH = 8;
    public static int KILO = 1023;
    public static int FULL_COLOR = 256;

    public WorkBook generateWorkBookByStream(InputStream inputStream) throws Exception {
        return this.generateWorkBookByStream(inputStream, new HashMap<String, Object>());
    }

    public WorkBook generateWorkBookByStream(InputStream inputStream, Map<String, Object> map) throws Exception {
        return (WorkBook)this.generate(inputStream, new TemplateBookAdapter(), map);
    }

    private FineBook generate(InputStream inputStream, TemplateBookAdapter templateBookAdapter, Map<String, Object> map) throws Exception {
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            pOIFSFileSystem = new POIFSFileSystem(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(Inter.getLocText((String)"FR-Engine-NS_exception_readExcelError"));
        }
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
        FineBook fineBook = templateBookAdapter.getBookInstance();
        List<ExcelPicture> list = ExcelReportImporter.getAllPictures(hSSFWorkbook);
        int n2 = hSSFWorkbook.getNumberOfSheets();
        wD wD2 = (wD)map.get(wD.O);
        wD.A(wD2, (short)2, true, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            wD.A(wD2, (short)2, false, i2);
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i2);
            ECReport eCReport = templateBookAdapter.getChildReportInstance(hSSFWorkbook.getSheetName(i2));
            this.applyReportSetting(eCReport, hSSFSheet);
            this.traverseByRows(eCReport, hSSFWorkbook, hSSFSheet, templateBookAdapter, list, wD2);
            this.dealWithImage(hSSFSheet, eCReport, templateBookAdapter, list);
        }
        inputStream.close();
        return fineBook;
    }

    private void applyReportSetting(ECReport eCReport, HSSFSheet hSSFSheet) {
        ReportSettingsProvider reportSettingsProvider = eCReport.getReportSettings();
        PaperSettingProvider paperSettingProvider = reportSettingsProvider.getPaperSetting();
        HSSFPrintSetup hSSFPrintSetup = hSSFSheet.getPrintSetup();
        reportSettingsProvider.setHeaderHeight((UNIT)new INCH((float)hSSFPrintSetup.getHeaderMargin()));
        reportSettingsProvider.setFooterHeight((UNIT)new INCH((float)hSSFPrintSetup.getFooterMargin()));
        paperSettingProvider.setOrientation(hSSFPrintSetup.getLandscape() ? 1 : 0);
        reportSettingsProvider.setPageOrder(hSSFPrintSetup.getLeftToRight() ? 1 : 0);
        this.applyMargin(paperSettingProvider, hSSFSheet);
    }

    private void applyMargin(PaperSettingProvider paperSettingProvider, HSSFSheet hSSFSheet) {
        Margin margin = paperSettingProvider.getMargin();
        margin.setTop((UNIT)new INCH((float)hSSFSheet.getMargin((short)2)));
        margin.setLeft((UNIT)new INCH((float)hSSFSheet.getMargin((short)0)));
        margin.setBottom((UNIT)new INCH((float)hSSFSheet.getMargin((short)3)));
        margin.setRight((UNIT)new INCH((float)hSSFSheet.getMargin((short)1)));
    }

    private void traverseByRows(ECReport eCReport, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, TemplateBookAdapter templateBookAdapter, List<ExcelPicture> list, Object object) {
        int n2 = hSSFSheet.getLastRowNum();
        int n3 = hSSFSheet.getFirstRowNum();
        if (object != null) {
            ((wD)object).E(n2 - n3);
        }
        for (int i2 = n3; i2 <= n2; ++i2) {
            HSSFRow hSSFRow;
            if (object != null) {
                ((wD)object).B(i2 - n3);
            }
            if ((hSSFRow = hSSFSheet.getRow(i2)) == null) continue;
            eCReport.setRowHeight(i2, (UNIT)new PT((float)hSSFRow.getHeight() / CustomConfigManager.getInstance().getExcelAdjustHeight()));
            short s2 = hSSFRow.getLastCellNum();
            for (int i3 = Math.max(0, hSSFRow.getFirstCellNum()); i3 <= s2; ++i3) {
                HSSFCell hSSFCell;
                if (hSSFSheet.getColumnWidth((short)i3) != DEFAULT_EXCEL_CELL_WIDTH) {
                    eCReport.setColumnWidth(i3, (UNIT)new OLDPIX((float)((short)((double)hSSFSheet.getColumnWidth((short)i3) / CustomConfigManager.getInstance().getExcelAdjustWidth()))));
                }
                if ((hSSFCell = hSSFRow.getCell((short)i3)) == null || this.isHiddenMergedCell(hSSFSheet, i3, i2)) continue;
                int[] nArray = this.getMergetColumnRow(hSSFSheet, i3, i2);
                int n4 = 1;
                int n5 = 1;
                if (nArray != null && nArray.length > 0) {
                    n4 = nArray[0];
                    n5 = nArray[1];
                }
                CellElement cellElement = templateBookAdapter.addNewCellElement(eCReport, i3, i2, n4, n5, ExcelUtils.getHSSFCellValue((HSSFCell)hSSFCell));
                int[] nArray2 = this.getMergetColumnRowTo(hSSFSheet, i3, i2);
                HSSFRow hSSFRow2 = hSSFSheet.getRow(nArray2[1]);
                HSSFCell hSSFCell2 = hSSFRow2.getCell((short)nArray2[0]);
                cellElement.setStyle(this.createStyle(hSSFWorkbook, hSSFCell, hSSFCell2));
            }
        }
    }

    private void dealWithImage(HSSFSheet hSSFSheet, ECReport eCReport, TemplateBookAdapter templateBookAdapter, List<ExcelPicture> list) {
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ColumnRow columnRow;
                ExcelPicture excelPicture = list.get(i2);
                if (!this.shouldSetImageToCellValue(hSSFSheet, eCReport, excelPicture, columnRow = excelPicture.getLeftTopColumnRow())) continue;
                BufferedImage bufferedImage = BaseUtils.readImage((InputStream)new ByteArrayInputStream(excelPicture.getData()));
                templateBookAdapter.addNewCellElement(eCReport, columnRow.column, columnRow.row, 1, 1, bufferedImage);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().info(iOException.getMessage());
        }
    }

    private boolean shouldSetImageToCellValue(HSSFSheet hSSFSheet, ECReport eCReport, ExcelPicture excelPicture, ColumnRow columnRow) {
        return ComparatorUtils.equals((Object)hSSFSheet, (Object)excelPicture.getSheet()) && columnRow != null && columnRow.column != -1 && columnRow.row != -1;
    }

    private boolean isHiddenMergedCell(HSSFSheet hSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < hSSFSheet.getNumMergedRegions(); ++i2) {
            Region region = hSSFSheet.getMergedRegionAt(i2);
            if (!this.columnRowInRegion(region, n2, n3)) continue;
            return region.getColumnFrom() != n2 || region.getRowFrom() != n3;
        }
        return false;
    }

    private boolean columnRowInRegion(Region region, int n2, int n3) {
        return region.getColumnFrom() <= n2 && region.getColumnTo() >= n2 && region.getRowFrom() <= n3 && region.getRowTo() >= n3;
    }

    private int[] getMergetColumnRow(HSSFSheet hSSFSheet, int n2, int n3) {
        int n4 = hSSFSheet.getNumMergedRegions();
        for (int i2 = 0; i2 < n4; ++i2) {
            Region region = hSSFSheet.getMergedRegionAt(i2);
            if (!this.columnRowInRegion(region, n2, n3)) continue;
            int n5 = region.getColumnTo() - region.getColumnFrom() + 1;
            int n6 = region.getRowTo() - region.getRowFrom() + 1;
            return new int[]{n5, n6};
        }
        return new int[0];
    }

    private int[] getMergetColumnRowTo(HSSFSheet hSSFSheet, int n2, int n3) {
        for (int i2 = 0; i2 < hSSFSheet.getNumMergedRegions(); ++i2) {
            Region region = hSSFSheet.getMergedRegionAt(i2);
            if (!this.columnRowInRegion(region, n2, n3)) continue;
            return new int[]{region.getColumnTo(), region.getRowTo()};
        }
        return new int[]{n2, n3};
    }

    private Style createStyle(HSSFWorkbook hSSFWorkbook, HSSFCell hSSFCell, HSSFCell hSSFCell2) {
        String string;
        if (hSSFCell == null) {
            return Style.DEFAULT_STYLE;
        }
        Style style = Style.DEFAULT_STYLE;
        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
        HSSFCellStyle hSSFCellStyle2 = hSSFCell2.getCellStyle();
        short s2 = hSSFCellStyle.getDataFormat();
        try {
            string = hSSFWorkbook.createDataFormat().getFormat(s2);
            style = ExcelReportImporter.format(string, style);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = this.createFontStyle(hSSFWorkbook, hSSFCellStyle);
        style = style.deriveFRFont((FRFont)string);
        Color color = this.createColor(hSSFWorkbook, hSSFCellStyle.getFillForegroundColor());
        if (color != null) {
            style = style.deriveBackground((Background)ColorBackground.getInstance((Color)color));
        }
        short s3 = hSSFCellStyle.getAlignment();
        short s4 = hSSFCellStyle.getVerticalAlignment();
        style = ExcelReportImporter.applyAlignStyle(s3, s4, style);
        int n2 = hSSFCellStyle.getWrapText() ? 0 : 1;
        style = style.deriveTextStyle(n2);
        style = this.createRotationStyle(hSSFCellStyle, style);
        style = this.createBorderStyle(style, hSSFWorkbook, hSSFCellStyle, hSSFCellStyle2);
        return style;
    }

    private Style createRotationStyle(HSSFCellStyle hSSFCellStyle, Style style) {
        short s2 = hSSFCellStyle.getRotation();
        if (s2 == -165) {
            style = style.deriveVerticalText(1);
            style = style.deriveRotation(0);
            return style.deriveTextDirection(0);
        }
        return style.deriveRotation((int)s2);
    }

    private FRFont createFontStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle) {
        HSSFFont hSSFFont = hSSFWorkbook.getFontAt(hSSFCellStyle.getFontIndex());
        int n2 = this.createFontType(hSSFFont);
        short s2 = hSSFFont.getFontHeightInPoints();
        FRFont fRFont = FRFont.getInstance((String)hSSFFont.getFontName(), (int)n2, (float)s2);
        this.createCanotDisplayFont(fRFont, n2, s2);
        Color color = this.createColor(hSSFWorkbook, hSSFFont.getColor());
        if (color != null) {
            fRFont = fRFont.applyForeground(color);
        }
        if (hSSFFont.getStrikeout()) {
            fRFont = fRFont.applyStrikethrough(true);
        }
        this.applyUnderLineStyle(hSSFFont, fRFont);
        return fRFont;
    }

    private int createFontType(HSSFFont hSSFFont) {
        int n2 = 0;
        if (hSSFFont.getBoldweight() == 700) {
            ++n2;
        }
        if (hSSFFont.getItalic()) {
            n2 += 2;
        }
        return n2;
    }

    private FRFont createCanotDisplayFont(FRFont fRFont, int n2, int n3) {
        String string;
        if (ComparatorUtils.equals((Object)FRContext.getLocale(), (Object)Locale.CHINA) && !fRFont.canDisplay((string = Inter.getLocText((String)"FR-Base-Song_TypeFace")).charAt(0))) {
            fRFont = FRFont.getInstance((String)string, (int)n2, (float)n3);
        }
        return fRFont;
    }

    private FRFont applyUnderLineStyle(HSSFFont hSSFFont, FRFont fRFont) {
        if (hSSFFont.getUnderline() == 0) {
            return fRFont.applyUnderline(0);
        }
        if (hSSFFont.getUnderline() == 1 || hSSFFont.getUnderline() == 33) {
            return fRFont.applyUnderline(1);
        }
        if (hSSFFont.getUnderline() == 2 || hSSFFont.getUnderline() == 34) {
            return fRFont.applyUnderline(6);
        }
        return fRFont;
    }

    private Style createBorderStyle(Style style, HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, HSSFCellStyle hSSFCellStyle2) {
        Color color = this.createColor(hSSFWorkbook, hSSFCellStyle.getTopBorderColor());
        Color color2 = this.createColor(hSSFWorkbook, hSSFCellStyle.getLeftBorderColor());
        Color color3 = this.createColor(hSSFWorkbook, hSSFCellStyle2.getBottomBorderColor());
        Color color4 = this.createColor(hSSFWorkbook, hSSFCellStyle2.getRightBorderColor());
        color = color == null ? style.getBorderTopColor() : color;
        color2 = color3 == null ? style.getBorderBottomColor() : color3;
        color3 = color2 == null ? style.getBorderLeftColor() : color2;
        color4 = color4 == null ? style.getBorderRightColor() : color4;
        int n2 = ExcelReportImporter.getBorderStyle(hSSFCellStyle.getBorderTop());
        int n3 = ExcelReportImporter.getBorderStyle(hSSFCellStyle2.getBorderBottom());
        int n4 = ExcelReportImporter.getBorderStyle(hSSFCellStyle.getBorderLeft());
        int n5 = ExcelReportImporter.getBorderStyle(hSSFCellStyle2.getBorderRight());
        return style.deriveBorder(n2, color, n3, color2, n4, color3, n5, color4);
    }

    public static Style applyAlignStyle(short s2, short s3, Style style) {
        switch (s2) {
            case 2: {
                style = style.deriveHorizontalAlignment(0);
                break;
            }
            case 3: {
                style = style.deriveHorizontalAlignment(4);
                break;
            }
            default: {
                style = style.deriveHorizontalAlignment(2);
            }
        }
        switch (s3) {
            case 0: {
                return style.deriveVerticalAlignment(1);
            }
            case 2: {
                return style.deriveVerticalAlignment(3);
            }
        }
        return style.deriveVerticalAlignment(0);
    }

    public static Style format(String string, Style style) {
        try {
            if (string != null) {
                TextFormat textFormat;
                if (ComparatorUtils.equals((String)string, (String)"@")) {
                    textFormat = TextFormat.getInstance();
                } else if (ComparatorUtils.equals((String)string.toUpperCase(), (String)"GENERAL")) {
                    textFormat = null;
                } else {
                    int n2;
                    if ((string = string.trim()).endsWith("_")) {
                        string = string.substring(0, string.length() - 1);
                    } else {
                        n2 = string.indexOf("_);");
                        if (n2 != -1) {
                            string = string.substring(0, n2);
                        }
                        if (string.startsWith("_(*")) {
                            string = string.substring(3);
                        }
                    }
                    if (string.indexOf("#,##0_") != -1) {
                        string = "#,##0";
                    }
                    if (string.indexOf("#,##0.00") != -1) {
                        string = "#,##0.00";
                    }
                    n2 = -1;
                    n2 = string.indexOf("+");
                    if (n2 != -1) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                    }
                    DecimalFormat decimalFormat = new DecimalFormat();
                    decimalFormat.applyPattern(string);
                    textFormat = new CoreDecimalFormat(decimalFormat, string);
                }
                return style.deriveFormat((Format)textFormat);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("Excel format pattern not supported by java");
        }
        return style;
    }

    private Color createColor(HSSFWorkbook hSSFWorkbook, short s2) {
        HSSFColor hSSFColor = hSSFWorkbook.getCustomPalette().getColor(s2);
        if (hSSFColor == null) {
            return null;
        }
        if (hSSFColor instanceof HSSFColor.AUTOMATIC) {
            return null;
        }
        short[] sArray = hSSFColor.getTriplet();
        return new Color(sArray[0], sArray[1], sArray[2]);
    }

    public static int getBorderStyle(short s2) {
        switch (s2) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
        }
        return 0;
    }

    public static void importExcel2Book(WriteWorkBook writeWorkBook, FineBook fineBook, TemplateWorkBook templateWorkBook, Map<String, Object> map) throws WriteExcelImportException, Exception {
        ExcelReportImporter.importExcel2Book(writeWorkBook, fineBook, templateWorkBook, map, true);
    }

    public static void importExcel2Book(WriteWorkBook writeWorkBook, FineBook fineBook, TemplateWorkBook templateWorkBook, Map<String, Object> map, boolean bl) throws Exception {
        WriteECReport writeECReport;
        long l2 = System.currentTimeMillis();
        ExcelReportImporter.putTabledata(writeWorkBook, templateWorkBook);
        wD wD2 = (wD)map.get(wD.O);
        if (templateWorkBook == null || writeWorkBook == null) {
            return;
        }
        int n2 = Math.min(templateWorkBook.getReportCount(), writeWorkBook.getReportCount());
        List[] listArray = new List[n2];
        if (wD2 != null) {
            wD2.A(n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_start") + (i2 + 1));
            }
            if (wD2 != null) {
                wD2.D(i2);
            }
            ECReport eCReport = (ECReport)templateWorkBook.getReport(i2);
            writeECReport = writeWorkBook.getWriteReport(i2);
            if (eCReport == null || writeECReport == null) continue;
            ExcelReportImporter.importExcel2BookBySheet(eCReport, writeECReport, listArray, i2, bl, fineBook);
        }
        ExcelReportImporter.recalculateAfterImport(writeWorkBook, n2, map, listArray, fineBook);
        ExcelReportImporter.modifySizeAfterImport(writeWorkBook);
        long l3 = System.currentTimeMillis() - l2;
        FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_import_cost") + l3);
        writeECReport = ExtraClassManager.getInstance().getFunctionProcessor();
        if (writeECReport != null) {
            writeECReport.recordFunction(ReportFunctionProcessor.EXCEL_IMPORT);
        }
    }

    private static void putTabledata(WriteWorkBook writeWorkBook, TemplateWorkBook templateWorkBook) {
        Iterator iterator = writeWorkBook.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TableData tableData = writeWorkBook.getTableData(string);
            templateWorkBook.putTableData(string, tableData);
        }
    }

    private static void importExcel2BookBySheet(ECReport eCReport, WriteECReport writeECReport, List<WriteCellElement>[] listArray, int n2, boolean bl, FineBook fineBook) throws Exception {
        CommentExcelProcessor commentExcelProcessor = (CommentExcelProcessor)ExtraReportClassManager.getInstance().getSingle("CommentExcelProcessor");
        if (commentExcelProcessor != null && commentExcelProcessor.importExcelMatchComment(eCReport, writeECReport, fineBook)) {
            return;
        }
        ArrayList<WriteCellElement> arrayList = new ArrayList<WriteCellElement>();
        if (ExcelReportImporter.isByLocation(eCReport, writeECReport)) {
            if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_by_location"));
            }
            ExcelReportImporter.doImportByLocation(writeECReport, eCReport, bl, arrayList);
            listArray[n2] = arrayList;
            return;
        }
        ExcelImportUncertainRect excelImportUncertainRect = writeECReport.findUnCertainWriteExpandRect();
        Object[] objectArray = excelImportUncertainRect.getUncertainRect();
        ArrayList<CellElement> arrayList2 = new ArrayList<CellElement>(Arrays.asList((Object[])objectArray));
        ExcelReportImporter.determineUnCertainList(writeECReport, arrayList2);
        if (CustomConfigManager.getInstance().isImportDoubleDir()) {
            ExcelReportImporter.importDoubleDir(excelImportUncertainRect, arrayList2, writeECReport);
        }
        ArrayList<CellElement> arrayList3 = new ArrayList<CellElement>();
        Point point = ExcelReportImporter.getLastColRow(arrayList2, arrayList3, bl);
        int n3 = point.x;
        int n4 = point.y;
        if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
            FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_uc_list") + arrayList3);
        }
        ExcelReportImporter.doImportByUnCertain(writeECReport, eCReport, bl, n3, n4, arrayList2, arrayList3, arrayList);
        listArray[n2] = arrayList;
    }

    private static void importDoubleDir(ExcelImportUncertainRect excelImportUncertainRect, List<CellElement> list, WriteECReport writeECReport) {
        int n2;
        int n3;
        Object[] objectArray = excelImportUncertainRect.getOppoUncertainRect();
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>(Arrays.asList((Object[])objectArray));
        int n4 = arrayList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            CellElement cellElement = (CellElement)arrayList.get(n3);
            if (!list.contains(cellElement)) continue;
            list.remove(cellElement);
        }
        ExcelReportImporter.determineUnCertainList(writeECReport, arrayList);
        n3 = 1;
        int n5 = 0;
        if (n5 < list.size()) {
            for (n2 = 0; n2 < n4; ++n2) {
                n3 = ExcelReportImporter.validSameColumnRow(n3 != 0, list.get(n5), (CellElement)arrayList.get(n2));
            }
        }
        if (n3 == 0) {
            return;
        }
        n2 = arrayList.size();
        for (n5 = 0; n5 < n2; ++n5) {
            CellElement cellElement = (CellElement)arrayList.get(n5);
            list.add(cellElement);
        }
    }

    private static boolean validSameColumnRow(boolean bl, CellElement cellElement, CellElement cellElement2) {
        return bl && (cellElement.getRow() == cellElement2.getRow() || cellElement.getColumn() == cellElement2.getColumn());
    }

    private static Point getLastColRow(List<CellElement> list, List<CellElement> list2, boolean bl) {
        int n2 = -1;
        int n3 = -1;
        if (list != null && !list.isEmpty()) {
            int n4 = list.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                CellElement cellElement = list.get(i2);
                ExcelReportImporter.addToWidgetList(bl, cellElement, list2);
                int n5 = cellElement.getRow() + cellElement.getRowSpan() - 1;
                int n6 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
                n2 = Math.max(n5, n2);
                n3 = Math.max(n6, n3);
            }
        }
        return new Point(n2, n3);
    }

    private static void addToWidgetList(boolean bl, CellElement cellElement, List<CellElement> list) {
        if (!bl) {
            list.add(cellElement);
            return;
        }
        if (((WidgetAttrElem)((Object)cellElement)).getWidget() != null) {
            list.add(cellElement);
        }
    }

    private static boolean isByLocation(ECReport eCReport, WriteECReport writeECReport) {
        return eCReport.getRowCount() == writeECReport.getRowCount() && eCReport.getColumnCount() == writeECReport.getColumnCount();
    }

    private static boolean isAllVerticalOrHorizontal(List<CellElement> list, List<CellElement> list2) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n2 = list.size();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            CellElement cellElement = list.get(i2);
            list2.add(cellElement);
            byte by = cellElement.getCellExpandAttr().getDirection();
            switch (by) {
                case 0: {
                    bl2 = false;
                    continue block4;
                }
                case 1: {
                    bl = false;
                }
            }
        }
        return bl || bl2;
    }

    private static void determineUnCertainList(WriteECReport writeECReport, List<CellElement> list) {
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        if (ExcelReportImporter.isAllVerticalOrHorizontal(list, arrayList)) {
            return;
        }
        boolean bl = CustomConfigManager.getInstance().isImportDoubleDir();
        list.clear();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            CellElement cellElement = (CellElement)arrayList.get(i2);
            CellExpandAttr cellExpandAttr = cellElement.getCellExpandAttr();
            boolean bl3 = cellExpandAttr.getDirection() == 0;
            boolean bl4 = cellExpandAttr.getDirection() == 1;
            int n3 = cellElement.getColumn();
            int n4 = cellElement.getRow();
            int n5 = ExcelReportImporter.getExpandSize(writeECReport, n4, n3, bl3, cellExpandAttr, bl2 = true);
            if (n5 <= 1) continue;
            ColumnRow columnRow = ColumnRow.valueOf((int)n3, (int)n4);
            int n6 = 0;
            HashSet<CellElement> hashSet = new HashSet<CellElement>();
            int n7 = arrayList.size();
            for (int i3 = i2 + 1; i3 < n7; ++i3) {
                boolean bl5;
                CellElement cellElement2 = (CellElement)arrayList.get(i3);
                if (hashSet.contains(cellElement2)) continue;
                hashSet.add(cellElement2);
                CellExpandAttr cellExpandAttr2 = cellElement2.getCellExpandAttr();
                boolean bl6 = cellExpandAttr2.getDirection() == 0;
                boolean bl7 = bl5 = cellExpandAttr2.getDirection() == 1;
                if (ExcelReportImporter.determineUnCertainHorizon(bl4, bl6, cellExpandAttr2, columnRow)) {
                    n6 = ExcelReportImporter.addExpandSons(n6, n5, cellElement2, list, writeECReport);
                }
                if (ExcelReportImporter.determineUnCertainVertical(bl3, bl5, cellExpandAttr2, columnRow)) {
                    n6 = ExcelReportImporter.addExpandSons(n6, n5, cellElement2, list, writeECReport);
                }
                if (bl) continue;
                return;
            }
            if (n6 <= 0) continue;
            return;
        }
    }

    private static int addExpandSons(int n2, int n3, CellElement cellElement, List<CellElement> list, WriteECReport writeECReport) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = cellElement.getColumn() + i2 + n2;
            list.add(writeECReport.getCellElement(n4, cellElement.getRow()));
        }
        return n2 += n3 - 1;
    }

    private static int getExpandSize(WriteECReport writeECReport, int n2, int n3, boolean bl, CellExpandAttr cellExpandAttr, boolean bl2) {
        ColumnRow columnRow;
        int n4 = writeECReport.getBoxExpandSize(n3, n2, bl);
        CellExpandAttr cellExpandAttr2 = cellExpandAttr;
        while ((columnRow = ExcelReportImporter.getExpandDirParent(bl2, cellExpandAttr2)) != null) {
            int n5 = columnRow.column;
            int n6 = columnRow.row;
            CellElement cellElement = writeECReport.getCellElement(n5, n6);
            cellExpandAttr2 = cellElement.getCellExpandAttr();
            n4 *= writeECReport.getBoxExpandSize(n5, n6, bl);
        }
        return n4;
    }

    private static ColumnRow getExpandDirParent(boolean bl, CellExpandAttr cellExpandAttr) {
        return bl ? cellExpandAttr.getLeftParentColumnRow() : cellExpandAttr.getUpParentColumnRow();
    }

    private static boolean determineUnCertainVertical(boolean bl, boolean bl2, CellExpandAttr cellExpandAttr, ColumnRow columnRow) {
        return bl && bl2 && ComparatorUtils.equals((Object)cellExpandAttr.getLeftParentColumnRow(), (Object)columnRow);
    }

    private static boolean determineUnCertainHorizon(boolean bl, boolean bl2, CellExpandAttr cellExpandAttr, ColumnRow columnRow) {
        return bl && bl2 && ComparatorUtils.equals((Object)cellExpandAttr.getUpParentColumnRow(), (Object)columnRow);
    }

    private static void doImportByUnCertain(WriteECReport writeECReport, ECReport eCReport, boolean bl, int n2, int n3, List<CellElement> list, List<CellElement> list2, List<WriteCellElement> list3) throws Exception {
        CellElement cellElement;
        boolean bl2 = false;
        int n4 = list == null ? 0 : list.size();
        for (int i2 = 0; i2 < n4 && !(bl2 = ExcelReportImporter.importDependsDir(cellElement = list.get(i2), writeECReport, eCReport, bl, n2, n3, list, list2, list3)); ++i2) {
            if (!FRContext.getLogger().isLoggable(Level.CONFIG)) continue;
            ColumnRow columnRow = ColumnRow.valueOf((int)cellElement.getColumn(), (int)cellElement.getRow());
            FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_uc_failed") + columnRow);
        }
        if (!bl2) {
            if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_uc_to_location"));
            }
            ExcelReportImporter.doImportByLocation(writeECReport, eCReport, bl, list3);
        }
    }

    private static boolean importDependsDir(CellElement cellElement, WriteECReport writeECReport, ECReport eCReport, boolean bl, int n2, int n3, List<CellElement> list, List<CellElement> list2, List<WriteCellElement> list3) throws Exception {
        boolean bl2;
        CellExpandAttr cellExpandAttr = cellElement.getCellExpandAttr();
        if (cellExpandAttr == null) {
            return false;
        }
        byte by = cellExpandAttr.getDirection();
        boolean bl3 = bl2 = by != 1;
        if (bl2) {
            return ExcelReportImporter.dealWithUCImport(writeECReport, eCReport, cellElement, cellElement.getRow(), bl, list2, list3, n2, eCReport.getRowCount(), bl2);
        }
        if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
            FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_Horizon"));
        }
        return ExcelReportImporter.dealWithUCImport(writeECReport, eCReport, cellElement, cellElement.getColumn(), bl, list2, list3, n3, eCReport.getColumnCount(), bl2);
    }

    private static void doImportByLocation(WriteECReport writeECReport, ECReport eCReport, boolean bl, List<WriteCellElement> list) {
        Iterator iterator = writeECReport.cellIterator();
        while (iterator.hasNext()) {
            WriteCellElement writeCellElement = (WriteCellElement)iterator.next();
            if (bl) {
                if (writeCellElement.getWidget() == null) continue;
                ExcelReportImporter.getExcelValueSetToWB(eCReport, writeCellElement, list, writeECReport);
                continue;
            }
            ExcelReportImporter.getExcelValueSetToWB(eCReport, writeCellElement, list, writeECReport);
        }
    }

    private static void getExcelValueSetToWB(ECReport eCReport, WriteCellElement writeCellElement, List<WriteCellElement> list, WriteECReport writeECReport) {
        Object object = eCReport.getCellValue(writeCellElement.getColumn(), writeCellElement.getRow());
        if (object == null) {
            return;
        }
        ExcelReportImporter.setValue4ExcelImport(writeCellElement, object, list, writeECReport);
    }

    private static int[] getMappingArray(boolean bl, WriteECReport writeECReport) {
        return bl ? writeECReport.getRowMappingArray() : writeECReport.getColumnMappingArray();
    }

    private static boolean dealWithUCImport(WriteECReport writeECReport, ECReport eCReport, CellElement cellElement, int n2, boolean bl, List<CellElement> list, List<WriteCellElement> list2, int n3, int n4, boolean bl2) throws Exception {
        int[] nArray = ExcelReportImporter.getMappingArray(bl2, writeECReport);
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        int n5 = ExcelReportImporter.getExpandLastRC(writeECReport, nArray, n3, bl2, arrayList);
        int n6 = ExcelReportImporter.matchReportToVerify(eCReport, n5, n4, arrayList, bl2);
        int n7 = ExcelReportImporter.getStartRowColumn(nArray, n2);
        if (n7 < 0) {
            if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_Excel_not_found_start"));
            }
            return false;
        }
        ArrayList<List<CellElement>> arrayList2 = new ArrayList<List<CellElement>>();
        int n8 = writeECReport.getBoxExpandSize(cellElement.getColumn(), cellElement.getRow(), bl2);
        int n9 = ExcelReportImporter.doAppendData(writeECReport, eCReport, n7, n3, n2, n8, cellElement, n4, n6, bl2, arrayList2, list);
        if (n9 <= n8 || n8 < 0) {
            if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_no_need_insert"));
            }
            return false;
        }
        ExcelReportImporter.setDataAfterAppend(writeECReport, eCReport, bl2, bl, n7, list2, arrayList2, list, cellElement);
        return true;
    }

    private static int getStartRowColumn(int[] nArray, int n2) {
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    private static Iterator<WriteCellElement> getColRowIterator(boolean bl, WriteECReport writeECReport, int n2) {
        return bl ? writeECReport.getRow(n2) : writeECReport.getColumn(n2);
    }

    private static int getExpandLastRC(WriteECReport writeECReport, int[] nArray, int n2, boolean bl, List<CellElement> list) {
        int n3 = -1;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            if (nArray[i2] == n2) {
                n3 = i2;
                break;
            }
            if (nArray[i2] <= n2) continue;
            ExcelReportImporter.addCellBelowExpand(bl, writeECReport, i2, list);
        }
        return n3;
    }

    private static void addCellBelowExpand(boolean bl, WriteECReport writeECReport, int n2, List<CellElement> list) {
        Iterator<WriteCellElement> iterator = ExcelReportImporter.getColRowIterator(bl, writeECReport, n2);
        while (iterator.hasNext()) {
            Object object;
            WriteCellElement writeCellElement = iterator.next();
            if (!ExcelReportImporter.validCellNoPresentOrWidget(writeCellElement) || !ExcelReportImporter.validValueAsNumerOrString(object = writeCellElement.getValue())) continue;
            list.add(writeCellElement);
        }
    }

    private static boolean validCellNoPresentOrWidget(WriteCellElement writeCellElement) {
        return writeCellElement != null && writeCellElement.getPresent() == null && writeCellElement.getWidget() == null;
    }

    private static boolean validValueAsNumerOrString(Object object) {
        return object instanceof String && StringUtils.isNotBlank((String)((String)object)) || object instanceof Number;
    }

    private static int doAppendData(WriteECReport writeECReport, ECReport eCReport, int n2, int n3, int n4, int n5, CellElement cellElement, int n6, int n7, boolean bl, List<List<CellElement>> list, List<CellElement> list2) throws Exception {
        Point[] pointArray = new Point[list2.size()];
        int n8 = ExcelReportImporter.matchReportForLocation(writeECReport, eCReport, pointArray, list2, cellElement, bl);
        if (n8 < 0 || !CustomConfigManager.getInstance().isExcelMatchTitle()) {
            if (FRContext.getLogger().isLoggable(Level.CONFIG)) {
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine_no_title"));
            }
            ExcelReportImporter.importDataWithoutMatchTitle(pointArray, cellElement, list2, bl);
            n8 = n2 - 1;
        }
        int n9 = Math.min(n7, n6 - 1);
        int n10 = n3 - n4 + 1;
        int n11 = n8;
        int n12 = 0;
        int n13 = ExcelReportImporter.computeStepCount(n8, n9 - 1, n10) - n5;
        if (n13 > 0) {
            ExcelReportImporter.insertData(writeECReport, cellElement, bl, n2 + n5 * n10, n10, n13);
        }
        HashMap<CellElement, Integer> hashMap = new HashMap<CellElement, Integer>();
        n12 = ExcelReportImporter.getInsertCellInLine(n8, n9, n2, pointArray, bl, eCReport, n12, hashMap, n10, list);
        try {
            ExcelReportImporter.dealMergeCells(writeECReport, hashMap, cellElement, n11, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n12;
    }

    private static int getInsertCellInLine(int n2, int n3, int n4, Point[] pointArray, boolean bl, ECReport eCReport, int n5, Map<CellElement, Integer> map, int n6, List<List<CellElement>> list) {
        int n7 = pointArray.length;
        while (n2 < n3) {
            ArrayList<CellElement> arrayList = new ArrayList<CellElement>(n7);
            for (int i2 = 0; i2 < n7; ++i2) {
                if (pointArray[i2] == null) continue;
                int n8 = bl ? pointArray[i2].y : n2 + 1;
                int n9 = bl ? n2 + 1 : pointArray[i2].x;
                CellElement cellElement = eCReport.getCellElement(n8, n9);
                arrayList.add(cellElement);
                if (!ExcelReportImporter.isMergeCell(cellElement) || map.containsKey(cellElement)) continue;
                map.put(cellElement, i2);
            }
            if (arrayList.isEmpty()) break;
            ++n5;
            list.add(arrayList);
            n4 += n6;
            n2 += n6;
        }
        return n5;
    }

    private static void importDataWithoutMatchTitle(Point[] pointArray, CellElement cellElement, List<CellElement> list, boolean bl) {
        int n2 = pointArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CellElement cellElement2 = list.get(i2);
            int n3 = cellElement2.getRow();
            int n4 = cellElement2.getColumn();
            int n5 = bl ? n3 - cellElement.getRow() : n3;
            int n6 = bl ? n4 : n4 - cellElement.getColumn();
            pointArray[i2] = new Point(n5, n6);
        }
    }

    private static void insertData(WriteECReport writeECReport, CellElement cellElement, boolean bl, int n2, int n3, int n4) throws WriteException {
        int n5 = bl ? cellElement.getColumn() : n2 - n3;
        int n6 = bl ? n2 - n3 : cellElement.getRow();
        ColumnRow columnRow = ColumnRow.valueOf((int)n5, (int)n6);
        writeECReport.simpleAppendData(columnRow, false, n4, true, false);
    }

    private static int computeStepCount(int n2, int n3, int n4) {
        if (n2 > n3) {
            return 0;
        }
        return (n3 - n2) / n4 + 1;
    }

    private static boolean isMergeCell(CellElement cellElement) {
        return cellElement != null && (cellElement.getRowSpan() > 1 || cellElement.getColumnSpan() > 1);
    }

    private static void dealMergeCells(WriteECReport writeECReport, Map<CellElement, Integer> map, CellElement cellElement, int n2, boolean bl) {
        for (CellElement cellElement2 : map.keySet()) {
            int n3;
            int n4 = map.get(cellElement2);
            if (cellElement2 == null) continue;
            int n5 = bl ? cellElement.getColumn() + n4 : cellElement.getColumn() - 1 + cellElement2.getColumn() - n2;
            int n6 = n3 = bl ? cellElement.getRow() - 1 + cellElement2.getRow() - n2 : cellElement.getRow() + n4;
            if (cellElement2.getRowSpan() > 1) {
                ExcelReportImporter.importMergeRow(cellElement2, writeECReport, n5, n3, bl);
            }
            if (cellElement2.getColumnSpan() <= 1) continue;
            ExcelReportImporter.importMergeColumn(cellElement2, writeECReport, n5, n3, bl);
        }
    }

    private static void importMergeColumn(CellElement cellElement, WriteECReport writeECReport, int n2, int n3, boolean bl) {
        int n4 = cellElement.getColumnSpan();
        for (int i2 = 0; i2 < n4; ++i2) {
            CellElement cellElement2 = writeECReport.getCellElement(n2 + i2, n3);
            if (cellElement2 == null) continue;
            cellElement2.setColumnSpan(n4);
            cellElement2.setColumn(n2);
            if (bl) continue;
            cellElement2.doExcelImportWithUpSon(writeECReport, cellElement2, n2, n3, n4);
        }
    }

    private static void importMergeRow(CellElement cellElement, WriteECReport writeECReport, int n2, int n3, boolean bl) {
        int n4 = cellElement.getRowSpan();
        for (int i2 = 0; i2 < n4; ++i2) {
            CellElement cellElement2 = writeECReport.getCellElement(n2, n3 + i2);
            if (cellElement2 == null) continue;
            cellElement2.setRowSpan(n4);
            cellElement2.setRow(n3);
            if (!bl) continue;
            cellElement2.doExcelImportWithLeftSon(writeECReport, cellElement2, n2, n2, n4);
        }
    }

    private static CellElement getExcelCell4Import(ECReport eCReport, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            CellElement cellElement = eCReport.getCellElement(n2, n4);
            if (cellElement != null && cellElement.getColumn() == n2 && cellElement.getRow() == n4) {
                return cellElement;
            }
        } else {
            CellElement cellElement = eCReport.getCellElement(n4, n3);
            if (cellElement != null && cellElement.getColumn() == n4 && cellElement.getRow() == n3) {
                return cellElement;
            }
        }
        return null;
    }

    private static void setValue4ExcelImport(WriteCellElement writeCellElement, Object object, List<WriteCellElement> list, Report report) {
        if (writeCellElement.getOriValue() == Constants.INIT_NULL) {
            writeCellElement.setOriValue(writeCellElement.getValue());
        }
        if (object instanceof Attachment) {
            Attachment attachment = (Attachment)object;
            object = new FRFile(attachment.getType(), attachment.getFilename(), attachment.getBytes());
        }
        if (object instanceof Formula) {
            object = new ResultFormula((Formula)object);
        }
        writeCellElement.setValue(ExcelReportImporter.processExtraValue(writeCellElement, object, report));
        if (writeCellElement.getPresent() != null) {
            list.add(writeCellElement);
        }
    }

    private static Object processExtraValue(DynamicAttrElem dynamicAttrElem, Object object, Report report) {
        ExcelImportProcessor excelImportProcessor = (ExcelImportProcessor)ExtraReportClassManager.getInstance().getSingle("ExcelImportProcessor");
        return excelImportProcessor == null ? object : excelImportProcessor.processImportCellValue(dynamicAttrElem, object, report);
    }

    private static void setDataAboveUncertain(WriteECReport writeECReport, ECReport eCReport, boolean bl, boolean bl2, int n2, List<WriteCellElement> list, List<List<CellElement>> list2, CellElement cellElement) {
        int n3;
        if (CustomConfigManager.getInstance().isImportDoubleDir()) {
            return;
        }
        CellElement cellElement2 = list2.get(0).get(0);
        if (cellElement2 == null) {
            return;
        }
        int n4 = n2 - 1;
        int n5 = bl ? cellElement.getColumn() : cellElement.getRow();
        int n6 = bl ? cellElement2.getRow() - 1 : cellElement2.getColumn() - 1;
        int n7 = n3 = bl ? cellElement2.getColumn() : cellElement2.getRow();
        if (ExcelReportImporter.validCptAndExcelStart(n4, n6, n3, n5)) {
            return;
        }
        int n8 = n6 - n4;
        int n9 = n6 >= n4 ? 0 : n4 - n6;
        for (int i2 = n4; i2 >= n9; --i2) {
            Iterator<WriteCellElement> iterator = ExcelReportImporter.getColRowIterator(bl, writeECReport, i2);
            int n10 = 0;
            while (iterator.hasNext()) {
                int n11;
                WriteCellElement writeCellElement = iterator.next();
                int n12 = n11 = bl ? writeCellElement.getColumnSpan() : writeCellElement.getRowSpan();
                if (bl2 && writeCellElement.getWidget() == null) continue;
                Object object = ExcelReportImporter.getExcelCellValue(n3, n10, i2, n8, bl, eCReport);
                ExcelReportImporter.setValue4ExcelImport(writeCellElement, object, list, writeECReport);
                n10 += n11;
            }
        }
    }

    private static Object getExcelCellValue(int n2, int n3, int n4, int n5, boolean bl, ECReport eCReport) {
        return bl ? eCReport.getCellValue(n2 + n3, n4 + n5) : eCReport.getCellValue(n4 + n5, n2 + n3);
    }

    private static boolean validCptAndExcelStart(int n2, int n3, int n4, int n5) {
        return n2 < 0 || n3 < 0 || n4 != 0 || n5 != 0;
    }

    private static void setDataAfterAppend(WriteECReport writeECReport, ECReport eCReport, boolean bl, boolean bl2, int n2, List<WriteCellElement> list, List<List<CellElement>> list2, List<CellElement> list3, CellElement cellElement) {
        ExcelReportImporter.setDataAboveUncertain(writeECReport, eCReport, bl, bl2, n2, list, list2, cellElement);
        int n3 = list2.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            List<CellElement> list4 = list2.get(i2);
            int n4 = list4.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object;
                CellElement cellElement2 = list4.get(i3);
                CellElement cellElement3 = list3.get(i3);
                int n5 = bl ? cellElement3.getColumn() : cellElement3.getColumn() + i2;
                int n6 = bl ? cellElement3.getRow() + i2 : cellElement3.getRow();
                WriteCellElement writeCellElement = writeECReport.getWriteCellElement(n5, n6);
                Object object2 = object = cellElement2 == null ? null : cellElement2.getValue();
                if (object == null) continue;
                ExcelReportImporter.setValue4ExcelImport(writeCellElement, object, list, writeECReport);
            }
        }
    }

    private static void recalculateAfterImport(WriteWorkBook writeWorkBook, int n2, Map<String, Object> map, List<WriteCellElement>[] listArray, TableDataSource tableDataSource) {
        for (int i2 = 0; i2 < n2; ++i2) {
            WriteECReport writeECReport = writeWorkBook.getWriteReport(i2);
            writeECReport.recalculate(null, map);
            List<WriteCellElement> list = listArray[i2];
            if (list == null || list.isEmpty()) continue;
            Calculator calculator = Calculator.createCalculator();
            calculator.pushNameSpace((NameSpace)SimpleCellValueNameSpace.getInstance());
            calculator.setAttribute(Report.KEY, (Object)writeECReport);
            calculator.setAttribute(TableDataSource.KEY, (Object)tableDataSource);
            int n3 = list.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                WriteCellElement writeCellElement = list.get(i3);
                writeCellElement.setPresentValue(writeCellElement.getPresent().present(writeCellElement.getValue(), calculator));
            }
        }
    }

    private static boolean fitHeight(int n2) {
        return n2 == 1;
    }

    private static boolean fitWidth(int n2) {
        return n2 == 2;
    }

    private static boolean fitDefault(int n2) {
        return n2 == 3;
    }

    private static void shrinkWithGlobalAttr(int n2, A a2, WriteECReport writeECReport) {
        if (ExcelReportImporter.fitHeight(n2)) {
            writeECReport.shrinkTOFitRowHeightForCellElement(a2);
        } else if (ExcelReportImporter.fitWidth(n2)) {
            writeECReport.shrinkTOFitColumnWidthForCellElement(a2);
        }
    }

    private static void shrinkWithSelfAttr(int n2, A a2, WriteECReport writeECReport, int n3) {
        if (ExcelReportImporter.shrinkHeight(n2, n3)) {
            writeECReport.shrinkTOFitRowHeightForCellElement(a2);
        } else if (ExcelReportImporter.shrinkWidth(n2, n3)) {
            writeECReport.shrinkTOFitColumnWidthForCellElement(a2);
        }
    }

    private static boolean shrinkWidth(int n2, int n3) {
        return ExcelReportImporter.fitWidth(n2) && ExcelReportImporter.fitDefault(n3) || ExcelReportImporter.fitWidth(n3);
    }

    private static boolean shrinkHeight(int n2, int n3) {
        return ExcelReportImporter.fitHeight(n2) && ExcelReportImporter.fitDefault(n3) || ExcelReportImporter.fitHeight(n3);
    }

    private static void modifySizeAfterImport(WriteWorkBook writeWorkBook) {
        int n2 = writeWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            WriteECReport writeECReport = (WriteECReport)writeWorkBook.getReport(i2);
            int n3 = ReportUtils.getReportSettings(writeECReport).getShrinkToFitMode();
            Iterator iterator = writeECReport.cellIterator();
            while (iterator.hasNext()) {
                A a2 = (A)iterator.next();
                CellGUIAttr cellGUIAttr = a2.getCellGUIAttr();
                if (cellGUIAttr == null) {
                    ExcelReportImporter.shrinkWithGlobalAttr(n3, a2, writeECReport);
                    continue;
                }
                int n4 = cellGUIAttr.getAdjustMode();
                ExcelReportImporter.shrinkWithSelfAttr(n3, a2, writeECReport, n4);
            }
        }
    }

    private static int matchReportToVerify(ECReport eCReport, int n2, int n3, List<CellElement> list, boolean bl) throws Exception {
        int n4 = Integer.MAX_VALUE;
        if (n2 < 0 || list.isEmpty()) {
            return n4;
        }
        CellElement cellElement = list.get(0);
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            Object object;
            CellElement cellElement2 = ExcelReportImporter.getExcelCell4Import(eCReport, cellElement.getColumn(), cellElement.getRow(), i2, bl);
            if (cellElement2 == null || (object = cellElement2.getValue()) == null || !ComparatorUtils.equals((String)object.toString().trim(), (String)cellElement.getValue().toString().trim())) continue;
            int n5 = 0;
            if (list.size() > 1) {
                int n6 = list.size();
                for (int i3 = 1; i3 < n6; ++i3) {
                    int n7;
                    CellElement cellElement3 = list.get(i3);
                    int n8 = cellElement2.getColumn() + cellElement3.getColumn() - cellElement.getColumn();
                    CellElement cellElement4 = eCReport.getCellElement(n8, n7 = cellElement2.getRow() + cellElement3.getRow() - cellElement.getRow());
                    if (cellElement4 == null || cellElement4.getColumn() != n8 || cellElement4.getRow() != n7 ? ++n5 > 0 : ((object = cellElement4.getValue()) == null || !ComparatorUtils.equals((String)object.toString().trim(), (String)cellElement.getValue().toString().trim())) && ++n5 > 0) break;
                }
            }
            n4 = ExcelReportImporter.getExcelEndRowColumn(n4, n5, n2, bl, cellElement, i2);
            break;
        }
        return n4;
    }

    private static int getExcelEndRowColumn(int n2, int n3, int n4, boolean bl, CellElement cellElement, int n5) throws WriteExcelImportException {
        if (n3 <= 0 && (n2 = n4 - (bl ? cellElement.getRow() : cellElement.getColumn()) + n5) == Integer.MAX_VALUE) {
            throw new WriteExcelImportException(Inter.getLocText((String)"FR-Engine-ExcelImport_Write_Match_Error_Info"));
        }
        return n2;
    }

    private static List<String> initWriteTitleList(List<CellElement> list, boolean bl, WriteECReport writeECReport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CellElement cellElement = list.get(i2);
            int n3 = cellElement.getColumn();
            int n4 = cellElement.getRow();
            CellElement cellElement2 = bl ? writeECReport.getCellElement(n3, n4 - 1) : writeECReport.getCellElement(n3 - 1, n4);
            String string = cellElement2 == null ? "" : Utils.objectToString((Object)cellElement2.getValue());
            arrayList.add(i2, string);
        }
        return arrayList;
    }

    private static int matchReportForLocation(WriteECReport writeECReport, ECReport eCReport, Point[] pointArray, List<CellElement> list, CellElement cellElement, boolean bl) throws Exception {
        int n2 = -1;
        try {
            List<String> list2 = ExcelReportImporter.initWriteTitleList(list, bl, writeECReport);
            boolean[] blArray = new boolean[]{false, false};
            n2 = ExcelReportImporter.getExcelStartRC(eCReport, list2, bl, blArray, pointArray, n2);
            if (!blArray[0]) {
                for (int i2 = 0; i2 < pointArray.length; ++i2) {
                    pointArray[i2] = null;
                }
                return -1;
            }
        }
        catch (Exception exception) {
            n2 = -1;
        }
        for (int i3 = 0; i3 < pointArray.length; ++i3) {
            if (pointArray[i3] != null) continue;
            pointArray[i3] = new Point(-1, -1);
        }
        return n2;
    }

    private static int getExcelStartRC(ECReport eCReport, List<String> list, boolean bl, boolean[] blArray, Point[] pointArray, int n2) {
        int n3 = bl ? eCReport.getRowCount() : eCReport.getColumnCount();
        int n4 = bl ? eCReport.getColumnCount() : eCReport.getRowCount();
        int n5 = 0;
        int n6 = list.size() != 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7 = 0;
            boolean[] blArray2 = new boolean[n4];
            HashMap<Integer, Point> hashMap = new HashMap<Integer, Point>();
            for (int i3 = 0; i3 < n4; ++i3) {
                n7 = ExcelReportImporter.validEachCellMatch(n7, blArray2, eCReport, list, bl, i2, i3, hashMap);
            }
            if (n7 > n6 && n7 >= n5) {
                blArray[0] = true;
                ExcelReportImporter.pushOffsetPoints(hashMap, pointArray);
                n5 = n7;
                if (!FRContext.getLogger().isLoggable(Level.CONFIG)) continue;
                FRContext.getLogger().info(Inter.getLocText((String)"FR-Engine-Excel_Title_Match") + (i2 + 1));
                continue;
            }
            if (!blArray[0]) continue;
            n2 = i2 - 1;
            break;
        }
        return n2;
    }

    private static void pushOffsetPoints(Map<Integer, Point> map, Point[] pointArray) {
        for (int n2 : map.keySet()) {
            pointArray[n2] = map.get(n2);
        }
    }

    private static int validEachCellMatch(int n2, boolean[] blArray, ECReport eCReport, List<String> list, boolean bl, int n3, int n4, Map<Integer, Point> map) {
        CellElement cellElement;
        CellElement cellElement2 = cellElement = bl ? eCReport.getCellElement(n4, n3) : eCReport.getCellElement(n3, n4);
        if (cellElement == null || cellElement.getValue() == null) {
            return n2;
        }
        String string = Utils.objectToString((Object)cellElement.getValue());
        if (StringUtils.isEmpty((String)string)) {
            return n2;
        }
        int n5 = ExcelReportImporter.checkTitleContains(list, 0, string, blArray);
        if (n5 != -1) {
            ++n2;
            if (n5 < blArray.length) {
                blArray[n5] = true;
            }
            map.put(new Integer(n5), bl ? new Point(n3, n4) : new Point(n4, n3));
        }
        return n2;
    }

    private static int checkTitleContains(List<String> list, int n2, String string, boolean[] blArray) {
        int n3 = list.indexOf(string);
        if (n3 == -1) {
            return -1;
        }
        int n4 = n2 + n3;
        if (n4 < blArray.length && blArray[n4]) {
            return ExcelReportImporter.checkTitleContains(list.subList(n3 + 1, list.size()), n4 + 1, string, blArray);
        }
        return n4;
    }

    public static List<ExcelPicture> getAllPictures(HSSFWorkbook hSSFWorkbook) {
        ArrayList<ExcelPicture> arrayList = new ArrayList<ExcelPicture>();
        List list = hSSFWorkbook.getAllPictures();
        List<ClientAnchorInfo> list2 = ExcelReportImporter.getClientAnchorRecords(hSSFWorkbook);
        if (list.size() != list2.size()) {
            FRContext.getLogger().error("Error Happens On Picture Analysis");
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HSSFPictureData hSSFPictureData = (HSSFPictureData)list.get(i2);
            ClientAnchorInfo clientAnchorInfo = list2.get(i2);
            HSSFSheet hSSFSheet = clientAnchorInfo.sheet;
            EscherClientAnchorRecord escherClientAnchorRecord = clientAnchorInfo.clientAnchorRecord;
            arrayList.add(new ExcelPicture(hSSFWorkbook, hSSFSheet, hSSFPictureData, escherClientAnchorRecord));
        }
        return arrayList;
    }

    private static List<ClientAnchorInfo> getClientAnchorRecords(HSSFWorkbook hSSFWorkbook) {
        ArrayList<ClientAnchorInfo> arrayList = new ArrayList<ClientAnchorInfo>();
        int n2 = hSSFWorkbook.getNumberOfSheets();
        for (int i2 = 0; i2 < n2; ++i2) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i2);
            EscherAggregate escherAggregate = hSSFSheet.getDrawingEscherAggregate();
            if (escherAggregate == null) continue;
            List list = escherAggregate.getEscherRecords();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExcelReportImporter.getClientAnchorRecords(hSSFSheet, (EscherRecord)iterator.next(), 1, arrayList);
            }
        }
        return arrayList;
    }

    private static void getClientAnchorRecords(HSSFSheet hSSFSheet, EscherRecord escherRecord, int n2, List<ClientAnchorInfo> list) {
        List list2 = escherRecord.getChildRecords();
        for (EscherRecord escherRecord2 : list2) {
            if (escherRecord2 instanceof EscherClientAnchorRecord) {
                ClientAnchorInfo clientAnchorInfo = new ClientAnchorInfo(hSSFSheet, (EscherClientAnchorRecord)escherRecord2);
                list.add(clientAnchorInfo);
            }
            if (escherRecord2.getChildRecords().size() <= 0) continue;
            ExcelReportImporter.getClientAnchorRecords(hSSFSheet, escherRecord2, n2 + 1, list);
        }
    }

    public static class ExcelPicture
    extends AbstractExcelPicture {
        private final HSSFWorkbook workbook;
        private final HSSFSheet sheet;
        private final HSSFPictureData pictureData;

        public ExcelPicture(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, HSSFPictureData hSSFPictureData, EscherClientAnchorRecord escherClientAnchorRecord) {
            this.workbook = hSSFWorkbook;
            this.sheet = hSSFSheet;
            this.pictureData = hSSFPictureData;
            this.clientAnchor = escherClientAnchorRecord;
        }

        public HSSFSheet getSheet() {
            return this.sheet;
        }

        public byte[] getData() {
            return this.pictureData.getData();
        }
    }

    private static class ClientAnchorInfo {
        public HSSFSheet sheet;
        public EscherClientAnchorRecord clientAnchorRecord;

        public ClientAnchorInfo(HSSFSheet hSSFSheet, EscherClientAnchorRecord escherClientAnchorRecord) {
            this.sheet = hSSFSheet;
            this.clientAnchorRecord = escherClientAnchorRecord;
        }
    }
}

