/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.io.attr.PDFExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.exporter.AbstractPDFExporter;
import com.fr.io.exporter.PDFExporterNameSpace;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetCreater;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.performance.PerformanceManager;
import com.fr.performance.status.ReportStatus;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.core.ReportUtils;
import com.fr.script.Calculator;
import com.fr.stable.OperatingSystem;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.FontProcessor;
import com.fr.stable.script.NameSpace;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.ExceptionConverter;
import com.fr.third.com.lowagie.text.Rectangle;
import com.fr.third.com.lowagie.text.pdf.BaseFont;
import com.fr.third.com.lowagie.text.pdf.FontMapper;
import com.fr.third.com.lowagie.text.pdf.PdfContentByte;
import com.fr.third.com.lowagie.text.pdf.PdfReader;
import com.fr.third.com.lowagie.text.pdf.PdfStamper;
import com.fr.third.com.lowagie.text.pdf.PdfWriter;
import com.fr.web.core.ReportRepositoryDeal;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;

public class PDFExporter
extends AbstractPDFExporter {
    protected static MyFontMapper fontMapper = null;
    protected boolean isPrint = false;

    public boolean isPrint() {
        return this.isPrint;
    }

    public PDFExporter() {
        this(false);
    }

    public PDFExporter(boolean bl) {
        this.isPrint = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, PageSetCreater pageSetCreater, ReportRepositoryDeal reportRepositoryDeal, int[] nArray) throws Exception {
        if (this.isPrint) {
            this.export(outputStream, pageSetCreater.createPageSet());
        } else {
            this.export(outputStream, resultWorkBook);
        }
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        Calculator.putThreadSavedNameSpace((NameSpace)new PDFExporterNameSpace(resultWorkBook));
        this.export(outputStream, pageSetProvider, resultWorkBook.getReportExportAttr());
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        this.export(outputStream, pageSetProvider, null);
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider, ReportExportAttr reportExportAttr) throws Exception {
        PdfReader pdfReader;
        long l2;
        boolean bl;
        Document document;
        PDFExportAttr pDFExportAttr;
        PerformanceManager.getRuntimeMonitor().setCurrentSessionStatus(ReportStatus.EXPORT_PDF);
        String string = null;
        PdfWriter pdfWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PDFExportAttr pDFExportAttr2 = pDFExportAttr = reportExportAttr == null ? null : reportExportAttr.getPDFExportAttr();
        if (pDFExportAttr != null && StringUtils.isNotEmpty((String)pDFExportAttr.getPassword())) {
            string = pDFExportAttr.getPassword();
        }
        if ((document = this.getDocument(pageSetProvider, pdfWriter, byteArrayOutputStream, bl = true, l2 = 0L)) != null) {
            document.close();
        }
        if (string != null) {
            pdfReader = new PdfReader(byteArrayOutputStream.toByteArray());
            pdfReader.removeUsageRights();
            PdfStamper pdfStamper = new PdfStamper(pdfReader, outputStream);
            pdfStamper.setEncryption(false, string, "", 3900);
            pdfStamper.close();
        }
        try {
            outputStream.write(byteArrayOutputStream.toByteArray());
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            this.catchException();
        }
        PerformanceManager.getRuntimeMonitor().setCurrentSessionStatus(ReportStatus.COMPLETE);
        pdfReader = ExtraClassManager.getInstance().getFunctionProcessor();
        if (pdfReader != null) {
            pdfReader.recordFunction(ReportFunctionProcessor.PDF_EXPORT);
        }
    }

    private void catchException() {
    }

    private Document getDocument(PageSetProvider pageSetProvider, PdfWriter pdfWriter, ByteArrayOutputStream byteArrayOutputStream, boolean bl, long l2) throws DocumentException {
        Document document = null;
        for (int i2 = 0; i2 < pageSetProvider.size(); ++i2) {
            long l3 = byteArrayOutputStream.size();
            PerformanceManager.getRuntimeMonitor().addMemoryAndCheck(l3 - l2);
            l2 = l3;
            ReportPageProvider reportPageProvider = pageSetProvider.getPage(i2);
            if (reportPageProvider == null) break;
            float f2 = reportPageProvider.getPaperWidth().toPixF(72);
            float f3 = reportPageProvider.getPaperHeight().toPixF(72);
            if (document == null) {
                document = new Document(new Rectangle(f2, f3));
                pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
                document.open();
            }
            if (!bl) {
                document.setPageSize(new Rectangle(f2, f3));
                document.newPage();
            }
            bl = false;
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            Graphics2D graphics2D = pdfContentByte.createGraphics(f2, f3, (FontMapper)PDFExporter.prepareFontMapper());
            double d2 = 0.75;
            graphics2D.scale(d2, d2);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = (PagePainterProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"PagePainter", (Object[])new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(96)), this.isPrint}, hashMap, PagePainterProvider.class);
            pagePainterProvider.convert();
            graphics2D.dispose();
        }
        return document;
    }

    public static MyFontMapper prepareFontMapper() {
        if (fontMapper != null) {
            return fontMapper;
        }
        fontMapper = new MyFontMapper();
        try {
            PDFExporter.insertOSFont();
            PDFExporter.insertJavaLib();
            PDFExporter.insertExtraFont();
            PDFExporter.createDefaultFont();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        return fontMapper;
    }

    private static void insertOSFont() {
        if (OperatingSystem.isWindows()) {
            PDFExporter.insertDirectory4Windows();
        } else {
            PDFExporter.insertDirectory4Linux();
        }
    }

    private static void insertExtraFont() {
        FontProcessor fontProcessor = (FontProcessor)ExtraClassManager.getInstance().getSingle("FontProcessor");
        if (fontProcessor != null) {
            PDFExporter.insertDirectory(fontMapper, fontProcessor.createFontCacheDirectory());
        }
    }

    private static void createDefaultFont() throws DocumentException, IOException {
        MyFontMapper.defaultFont = FRContext.getLocale() == Locale.CHINA || FRContext.getLocale() == Locale.CHINESE ? BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false) : (FRContext.getLocale() == Locale.TAIWAN || FRContext.getLocale() == Locale.TRADITIONAL_CHINESE ? BaseFont.createFont((String)"MSung-Light", (String)"UniCNS-UCS2-H", (boolean)false) : (FRContext.getLocale() == Locale.JAPAN || FRContext.getLocale() == Locale.JAPANESE ? BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)false) : (FRContext.getLocale() == Locale.KOREA || FRContext.getLocale() == Locale.KOREAN ? BaseFont.createFont((String)"HYGoThic-Medium", (String)"UniKS-UCS2-H", (boolean)false) : BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false))));
    }

    private static void insertJavaLib() {
        String string = System.getProperty("java.home");
        if (string != null) {
            File file = new File(StableUtils.pathJoin((String[])new String[]{string, "lib", "fonts"}));
            PDFExporter.insertDirectory(fontMapper, file);
        }
    }

    private static void insertDirectory4Linux() {
        PDFExporter.insertDirectory(fontMapper, new File("/usr/X11R6/lib/X11/fonts"));
        PDFExporter.insertDirectory(fontMapper, new File("/usr/share/fonts"));
        String string = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "fonts"});
        PDFExporter.insertDirectory(fontMapper, new File(string));
        PDFExporter.insertDirectory(fontMapper, new File("/usr/X/lib/X11/fonts/TrueType"));
        PDFExporter.insertDirectory(fontMapper, new File("/usr/openwin/lib/X11/fonts/TrueType"));
    }

    private static void insertDirectory4Windows() {
        String string = System.getProperty("java.library.path");
        String[] stringArray = StableUtils.splitString((String)string, (String)";");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file = new File(stringArray[i2]);
            PDFExporter.insertDirectory(fontMapper, new File(file, "Fonts"));
        }
        PDFExporter.insertDirectory(fontMapper, new File("C:\\WINNT\\Fonts"));
        PDFExporter.insertDirectory(fontMapper, new File("C:\\WINDOWS\\Fonts"));
    }

    protected static void insertDirectory(MyFontMapper myFontMapper, File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        myFontMapper.insertDirectory(file.getAbsolutePath());
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            PDFExporter.insertDirectory(myFontMapper, fileArray[i2]);
        }
    }

    public static class MyFontMapper
    implements FontMapper {
        public static final String CHINESE_SIMPLIFIED_FONT = "STSong-Light";
        public static final String CHINESE_SIMPLIFIED_ENCODING_H = "UniGB-UCS2-H";
        public static final String CHINESE_SIMPLIFIED_ENCODING_V = "UniGB-UCS2-V";
        public static final String CHINESE_TRADITIONAL_FONT_M_HEI = "MHei-Medium";
        public static final String CHINESE_TRADITIONAL_FONT_M_SUNG = "MSung-Light";
        public static final String CHINESE_TRADITIONAL_ENCODING_H = "UniCNS-UCS2-H";
        public static final String CHINESE_TRADITIONAL_ENCODING_V = "UniCNS-UCS2-V";
        public static final String JAPANESE_FONT_GO = "HeiseiKakuGo-W5";
        public static final String JAPANESE_FONT_MIN = "HeiseiMin-W3";
        public static final String JAPANESE_ENCODING_H = "UniJIS-UCS2-H";
        public static final String JAPANESE_ENCODING_V = "UniJIS-UCS2-V";
        public static final String JAPANESE_ENCODING_HW_H = "UniJIS-UCS2-HW-H";
        public static final String JAPANESE_ENCODING_HW_V = "UniJIS-UCS2-HW-V";
        public static final String KOREAN_FONT_GO_THIC = "HYGoThic-Medium";
        public static final String KOREAN_FONT_S_MYEONG_JO = "HYSMyeongJo-Medium";
        public static final String KOREAN_ENCODING_H = "UniKS-UCS2-H";
        public static final String KOREAN_ENCODING_V = "UniKS-UCS2-V";
        public static BaseFont defaultFont;
        private HashMap mapper = new HashMap();

        public BaseFont awtToPdf(Font font) {
            try {
                BaseFontParameters baseFontParameters = this.getBaseFontParameters(font.getFontName());
                if (baseFontParameters == null) {
                    baseFontParameters = this.getBaseFontParameters(font.getName());
                }
                if (baseFontParameters != null) {
                    return BaseFont.createFont((String)baseFontParameters.fontName, (String)baseFontParameters.encoding, (boolean)baseFontParameters.embedded, (boolean)baseFontParameters.cached, (byte[])baseFontParameters.ttfAfm, (byte[])baseFontParameters.pfb);
                }
                if (defaultFont != null) {
                    return defaultFont;
                }
                String string = "Courier";
                if (font.isBold() && font.isItalic()) {
                    string = "Courier-BoldOblique";
                } else if (font.isBold()) {
                    string = "Courier-Bold";
                } else if (font.isItalic()) {
                    string = "Courier-Oblique";
                }
                return BaseFont.createFont((String)string, (String)"Cp1252", (boolean)false);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                throw new ExceptionConverter(exception);
            }
        }

        public Font pdfToAwt(BaseFont baseFont, int n2) {
            String string;
            String[][] stringArray = baseFont.getFullFontName();
            if (stringArray.length == 1) {
                return new Font(stringArray[0][3], 0, n2);
            }
            String string2 = null;
            String string3 = null;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2];
                if (ComparatorUtils.equals((String)stringArray2[0], (String)"1") && ComparatorUtils.equals((String)stringArray2[1], (String)"0")) {
                    string2 = stringArray2[3];
                    continue;
                }
                if (!ComparatorUtils.equals((String)stringArray2[2], (String)"1033")) continue;
                string3 = stringArray2[3];
                break;
            }
            if ((string = string3) == null) {
                string = string2;
            }
            if (string == null) {
                string = stringArray[0][3];
            }
            return new Font(string, 0, n2);
        }

        private BaseFontParameters getBaseFontParameters(String string) {
            return (BaseFontParameters)this.mapper.get(string);
        }

        protected void insertNames(String[][] stringArray, String string) {
            Object object;
            int n2;
            String string2 = null;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object = stringArray[n2];
                if (!ComparatorUtils.equals((String)object[2], (String)"1033")) continue;
                string2 = object[3];
                break;
            }
            if (string2 == null) {
                string2 = stringArray[0][3];
            }
            object = new BaseFontParameters(string);
            this.mapper.put(string2, object);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.mapper.put(stringArray[n2][3], object);
            }
        }

        public int insertDirectory(String string) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            File[] fileArray = file.listFiles();
            int n2 = 0;
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                file = fileArray[i2];
                String string2 = file.getPath().toLowerCase();
                try {
                    String[][] stringArray;
                    if (this.matchPostfix(string2)) {
                        stringArray = BaseFont.getFullFontName((String)file.getPath(), (String)"Cp1252", null);
                        this.insertNames(stringArray, file.getPath());
                        ++n2;
                        continue;
                    }
                    if (!string2.endsWith(".ttc")) continue;
                    stringArray = BaseFont.enumerateTTCNames((String)file.getPath());
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        String string3 = String.valueOf(new StringBuffer(file.getPath()).append(',').append(i3));
                        String[][] stringArray2 = BaseFont.getFullFontName((String)string3, (String)"Cp1252", null);
                        this.insertNames(stringArray2, string3);
                    }
                    ++n2;
                    continue;
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
            }
            return n2;
        }

        private boolean matchPostfix(String string) {
            return string.endsWith(".ttf") || string.endsWith(".otf") || string.endsWith(".afm");
        }

        public static class BaseFontParameters {
            public String fontName;
            public String encoding;
            public boolean embedded;
            public boolean cached;
            public byte[] ttfAfm;
            public byte[] pfb;

            public BaseFontParameters(String string) {
                this.fontName = string;
                this.encoding = "Identity-H";
                this.embedded = true;
                this.cached = true;
            }

            public String toString() {
                return "{fontName:" + this.fontName + ",encoding:" + this.encoding + ",embedded:" + this.embedded + ",cached:" + this.cached;
            }
        }
    }
}

