/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.CustomConfigManager;
import com.fr.base.DynamicUnitList;
import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.chart.BaseChartPainter;
import com.fr.cache.list.IntList;
import com.fr.general.Background;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.io.attr.ExcelExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.core.ExcelExporterReport;
import com.fr.io.exporter.AbstractExcelExporter;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.excel.stream.StreamExcel2007Exporter;
import com.fr.io.exporter.poi.wrapper.HssfCellStyleWrapper;
import com.fr.io.exporter.poi.wrapper.HssfCellWrapper;
import com.fr.io.exporter.poi.wrapper.HssfClientAnchorWrapper;
import com.fr.io.exporter.poi.wrapper.HssfFontWrapper;
import com.fr.io.exporter.poi.wrapper.HssfFooterWrapper;
import com.fr.io.exporter.poi.wrapper.HssfHeaderWrapper;
import com.fr.io.exporter.poi.wrapper.HssfPatriarchWrapper;
import com.fr.io.exporter.poi.wrapper.HssfPrintSetupWrapper1;
import com.fr.io.exporter.poi.wrapper.HssfRichStringWrapper;
import com.fr.io.exporter.poi.wrapper.HssfSheetWrapper;
import com.fr.io.exporter.poi.wrapper.HssfWorkbookWrapper;
import com.fr.io.exporter.poi.wrapper.POICellAction;
import com.fr.io.exporter.poi.wrapper.POIFontAction;
import com.fr.io.exporter.poi.wrapper.POIHeaderFooterAction;
import com.fr.io.exporter.poi.wrapper.POIRichStringAction;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.io.exporter.poi.wrapper.PaperSettingWrapper;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PageSetCreater;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.performance.PerformanceManager;
import com.fr.performance.status.ReportStatus;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.painter.shape.LineShapePainter;
import com.fr.report.cell.painter.shape.OvalShapePainter;
import com.fr.report.cell.painter.shape.ShapePainter;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.ExportConstants;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics;
import com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics2d;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPalette;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.web.core.ReportRepositoryDeal;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Time;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends AbstractExcelExporter<Boolean> {
    private static final short COLOR_INDEX = 8;
    private short colorIndex = (short)8;
    private HSSFCellStyle defaultHSSFCellStyle = null;
    private HSSFDataFormat format = null;
    private static int V_ROTATION = 90;
    private static int EX_WIDTH = 80;
    private static int EX_HEIGHT = 120;
    protected boolean isExcel2003 = false;
    private static HSSFWorkbook hssfWorkbook;

    public ExcelExporter() {
        this(null);
    }

    public ExcelExporter(List list) {
        this.paperSettingList = list;
    }

    public boolean isExcel2003() {
        return this.isExcel2003;
    }

    @Override
    public void setVersion(Boolean bl) {
        this.isExcel2003 = bl;
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, PageSetCreater pageSetCreater, ReportRepositoryDeal reportRepositoryDeal, int[] nArray) throws Exception {
        this.export(outputStream, resultWorkBook, true, nArray);
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    protected AppExporter getExporterFor2007(List<PaperSettingProvider> list) throws ClassNotFoundException {
        return new StreamExcel2007Exporter(list);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        this.export(outputStream, resultWorkBook, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl, int[] nArray) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        ResultWorkBook resultWorkBook2 = this.removeUselessSheet(resultWorkBook, nArray, resultWorkBook);
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(ReportFunctionProcessor.EXCEL_EXPORT);
        }
        try {
            if (this.checkExcelExportVersion()) {
                PerformanceManager.getRuntimeMonitor().setCurrentSessionStatus(ReportStatus.EXPORT_EXCEL_2007);
                this.exportFor2007(outputStream, resultWorkBook2);
                return;
            }
            PerformanceManager.getRuntimeMonitor().setCurrentSessionStatus(ReportStatus.EXPORT_EXCEL_2003);
            this.exportFor2003(outputStream, resultWorkBook2, bl);
        }
        finally {
            PerformanceManager.getRuntimeMonitor().setCurrentSessionStatus(ReportStatus.COMPLETE);
        }
    }

    private ResultWorkBook removeUselessSheet(ResultWorkBook resultWorkBook, int[] nArray, ResultWorkBook resultWorkBook2) {
        int n2 = ArrayUtils.getLength((Object)nArray);
        if (n2 <= 0) {
            return resultWorkBook2;
        }
        if (resultWorkBook.getReportCount() > n2) {
            try {
                resultWorkBook2 = (ResultWorkBook)resultWorkBook.clone();
                int n3 = resultWorkBook.getReportCount();
                for (int i2 = n3 - 1; i2 >= 0; --i2) {
                    if (ArrayUtils.contains((int[])nArray, (int)i2)) continue;
                    resultWorkBook2.removeReport(i2);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().info(exception.getMessage());
            }
        }
        return resultWorkBook2;
    }

    protected void exportFor2007(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.getExporterFor2007(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).export(outputStream, resultWorkBook);
    }

    protected void exportFor2003(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        ArrayList<Report> arrayList = new ArrayList<Report>();
        this.defaultHSSFCellStyle = null;
        this.hssfFontHash.clear();
        this.hssfCellStyleHash.clear();
        this.format = null;
        this.colorIndex = (short)8;
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        this.setDefaultFont(new HssfWorkbookWrapper(hSSFWorkbook));
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.exportBook(resultWorkBook, new HssfWorkbookWrapper(hSSFWorkbook), arrayList2, arrayList3, arrayList, bl);
        this.dealWithFormula(arrayList2, arrayList3);
        String string = this.getPassword(resultWorkBook);
        if (StringUtils.isNotBlank((String)string)) {
            hSSFWorkbook.setFilePassword(string);
        }
        try {
            hSSFWorkbook.write(outputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputStream.flush();
    }

    private void dealWithFormula(List list, List list2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HSSFCell hSSFCell = (HSSFCell)list.get(i2);
            this.dealWithFormula(new HssfCellWrapper(hSSFCell), (String)list2.get(i2));
        }
    }

    protected boolean checkExcelExportVersion() {
        return ExcelUtils.checkThirdJarSupportPOI() && !this.isExcel2003;
    }

    @Override
    protected void innerExportReports(ResultECReport resultECReport, ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, int n2) {
        Point point = new Point(0, 0);
        int n3 = resultECReport.getColumnCount();
        int n4 = resultECReport.getRowCount();
        int n5 = 1;
        while (point.x < n3) {
            point.y = 0;
            while (point.y < n4) {
                try {
                    this.innerExportReport(new ExcelExporterReport(resultECReport, point.x, point.y, Math.min(n3 - point.x, ExportConstants.MAX_COLS), Math.min(n4 - point.y, ExportConstants.MAX_ROWS)), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n2) + (n5 == 1 ? "" : "_" + n5), (HSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, n2);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                }
                point.y += ExportConstants.MAX_ROWS;
                ++n5;
            }
            point.x += ExportConstants.MAX_COLS;
        }
    }

    protected void innerExportReport(Report report, ReportExportAttr reportExportAttr, String string, HSSFWorkbook hSSFWorkbook, List list, List<String> list2, int n2) throws Exception {
        ExcelExportAttr excelExportAttr = reportExportAttr == null ? new ExcelExportAttr() : reportExportAttr.getExcelExportAttr();
        HSSFSheet hSSFSheet = hSSFWorkbook.createSheet();
        if (StringUtils.isNotEmpty((String)excelExportAttr.getProtectedWord())) {
            hSSFSheet.protectSheet(excelExportAttr.getProtectedWord());
        }
        this.setSheetName(new HssfWorkbookWrapper(hSSFWorkbook), string);
        this.iterateReport((ElementCase)((Object)report), hSSFSheet, hSSFWorkbook, list, list2, excelExportAttr, n2);
    }

    protected void dealECReportAndBlockPageSetting(ElementCase elementCase, HSSFSheet hSSFSheet, int n2) {
        this.dealWithPageSetting((Report)((Object)elementCase), hSSFSheet, n2);
    }

    private void iterateReport(ElementCase elementCase, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, List list, List list2, ExcelExportAttr excelExportAttr, int n2) throws Exception {
        this.dealECReportAndBlockPageSetting(elementCase, hSSFSheet, n2);
        hSSFSheet.setDefaultColumnWidth((short)9);
        Iterator iterator = elementCase.cellIterator();
        DynamicUnitList dynamicUnitList = ReportHelper.getRowHeightList(elementCase);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getColumnWidthList(elementCase);
        IntList intList = new IntList();
        IntList intList2 = new IntList();
        boolean bl = excelExportAttr.isExportHidedRow();
        boolean bl2 = excelExportAttr.isExportHidedColumn();
        this.dealHiddenAndFrozen(bl, bl2, dynamicUnitList, dynamicUnitList2, intList, intList2, elementCase, hSSFSheet);
        int[] nArray = new int[]{-1, -1};
        HSSFPatriarch hSSFPatriarch = hSSFSheet.createDrawingPatriarch();
        HSSFPatriarch hSSFPatriarch2 = null;
        if (this.columnRowPostileMaps != null && this.columnRowPostileMaps[n2] != null) {
            hSSFPatriarch2 = hSSFSheet.createDrawingPatriarch();
        }
        Calculator calculator = Calculator.createCalculator();
        this.setAttr4ECReportSIL(calculator, intList, intList2, elementCase);
        this.iterateCell(iterator, list, list2, intList, intList2, elementCase, hSSFSheet, hSSFWorkbook, nArray, bl2, bl, dynamicUnitList, dynamicUnitList2, hSSFPatriarch2, hSSFPatriarch, excelExportAttr, n2, calculator);
        this.dealWithFloatElement(elementCase, hSSFPatriarch, dynamicUnitList, dynamicUnitList2, nArray[0], nArray[1], hSSFSheet, hSSFWorkbook);
    }

    private void iterateCell(Iterator iterator, List list, List list2, IntList intList, IntList intList2, ElementCase elementCase, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, int[] nArray, boolean bl, boolean bl2, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, HSSFPatriarch hSSFPatriarch, HSSFPatriarch hSSFPatriarch2, ExcelExportAttr excelExportAttr, int n2, Calculator calculator) {
        HSSFRow hSSFRow = null;
        long l2 = 0L;
        while (iterator.hasNext()) {
            int n3;
            if ((l2++ & 0x3FFL) == 0L) {
                MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
            }
            CellElement cellElement = (CellElement)iterator.next();
            int n4 = cellElement.getColumn();
            int n5 = cellElement.getRow();
            int n6 = cellElement.getColumnSpan();
            int n7 = cellElement.getRowSpan();
            int[] nArray2 = this.dealWithHiddenCR(n5, n7, intList);
            n5 = nArray2[0];
            n7 = nArray2[1];
            nArray2 = this.dealWithHiddenCR(n4, n6, intList2);
            n4 = nArray2[0];
            n6 = nArray2[1];
            if (n7 <= 0 || n6 <= 0) continue;
            int n8 = n4 + n6 - 1;
            int n9 = n5 + n7 - 1;
            this.dealLastIndex(nArray, n8, n9, bl, bl2, dynamicUnitList, dynamicUnitList2, hSSFSheet);
            this.setColumnRowBreak(cellElement, new HssfSheetWrapper(hSSFSheet), n4, n5, n8, n9);
            CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
            if (cellGUIAttr == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            if (!cellGUIAttr.isPrintContent() && !cellGUIAttr.isPrintBackground()) continue;
            int n10 = n4 + n6;
            for (int i2 = n3 = n4; i2 < n10; ++i2) {
                int n11;
                int n12 = n5 + n7;
                for (int i3 = n11 = n5; i3 < n12; ++i3) {
                    HSSFCell hSSFCell = this.createHSSFCell(hSSFRow, hSSFSheet, i3, i2, n8, n5, n2, elementCase, hSSFPatriarch);
                    if (i2 != n3 || i3 != n11 || !cellGUIAttr.isPrintContent() && cellGUIAttr.isPrintBackground()) {
                        hSSFCell.setCellStyle(this.createHSSFCellStyle(hSSFWorkbook, cellElement.getStyle()));
                        continue;
                    }
                    this.dealWithValue(cellElement, list, hSSFCell, excelExportAttr, calculator, list2, cellGUIAttr, hSSFWorkbook, dynamicUnitList, dynamicUnitList2, n4, n5, n6, n7, hSSFPatriarch2);
                }
            }
            if (n7 <= 1 && n6 <= 1) continue;
            Region region = new Region(n5, (short)n4, n5 + n7 - 1, (short)(n4 + n6 - 1));
            hSSFSheet.addMergedRegion(region);
        }
    }

    private void dealLastIndex(int[] nArray, int n2, int n3, boolean bl, boolean bl2, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, HSSFSheet hSSFSheet) {
        int n4;
        if (nArray[0] < n2) {
            for (n4 = Math.max(0, nArray[0]); n4 <= n2; ++n4) {
                if (dynamicUnitList2.get(n4).toFU() <= 0L) {
                    hSSFSheet.setColumnHidden((short)n4, bl);
                    continue;
                }
                hSSFSheet.setColumnWidth((short)n4, (short)(dynamicUnitList2.get(n4).toPixD(96) * CustomConfigManager.getInstance().getExcelAdjustWidth()));
            }
            nArray[0] = n2;
        }
        if (nArray[1] < n3) {
            for (n4 = Math.max(0, nArray[1]); n4 <= n3; ++n4) {
                HSSFRow hSSFRow = hSSFSheet.createRow(n4);
                if (dynamicUnitList.get(n4).toFU() <= 0L) {
                    hSSFRow.setZeroHeight(bl2);
                    continue;
                }
                hSSFRow.setHeight((short)(dynamicUnitList.get(n4).toPTValue4Scale2() * CustomConfigManager.getInstance().getExcelAdjustHeight()));
            }
            nArray[1] = n3;
        }
    }

    private void dealHiddenAndFrozen(boolean bl, boolean bl2, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, IntList intList, IntList intList2, ElementCase elementCase, HSSFSheet hSSFSheet) {
        int n2;
        if (!bl) {
            for (n2 = dynamicUnitList.size() - 1; n2 >= 0; --n2) {
                if (!dynamicUnitList.get(n2).equal_zero()) continue;
                intList.add(n2);
                dynamicUnitList.remove(n2);
            }
        }
        if (!bl2) {
            for (n2 = dynamicUnitList2.size() - 1; n2 >= 0; --n2) {
                if (!dynamicUnitList2.get(n2).equal_zero()) continue;
                intList2.add(n2);
                dynamicUnitList2.remove(n2);
            }
        }
        if (elementCase.getReportPageAttr() != null && elementCase.getReportPageAttr().getFreezeColumnRow() != null) {
            int n3;
            ColumnRow columnRow = elementCase.getReportPageAttr().getFreezeColumnRow();
            int n4 = columnRow.getColumn();
            int n5 = columnRow.getRow();
            for (n3 = 0; n3 < columnRow.getColumn(); ++n3) {
                if (!intList2.contain(n3)) continue;
                --n4;
            }
            for (n3 = 0; n3 < columnRow.getRow(); ++n3) {
                if (!intList.contain(n3)) continue;
                --n5;
            }
            hSSFSheet.createFreezePane(n4, n5);
        }
    }

    private HSSFCell createHSSFCell(HSSFRow hSSFRow, HSSFSheet hSSFSheet, int n2, int n3, int n4, int n5, int n6, ElementCase elementCase, HSSFPatriarch hSSFPatriarch) {
        String string;
        if (hSSFRow == null || hSSFRow.getRowNum() != n2) {
            hSSFRow = hSSFSheet.getRow(n2);
        }
        HSSFCell hSSFCell = hSSFRow.createCell((short)n3);
        if (n2 == n5 && n3 == n4 && this.columnRowPostileMaps != null && this.columnRowPostileMaps[n6] != null && (string = (String)this.columnRowPostileMaps[n6].get(ColumnRow.valueOf((int)n4, (int)n5))) != null) {
            int n7;
            int n8 = n5;
            long l2 = 0L;
            long l3 = 0L;
            for (n7 = n4; n7 < elementCase.getColumnCount(); ++n7) {
                if ((l3 += elementCase.getColumnWidth(n7).getLen()) <= (long)(EX_WIDTH * 38100)) continue;
                ++n7;
                break;
            }
            while (n8 < elementCase.getRowCount()) {
                if ((l2 += elementCase.getRowHeight(n8).getLen()) > (long)(EX_HEIGHT * 38100)) {
                    ++n8;
                    break;
                }
                ++n8;
            }
            HSSFClientAnchor hSSFClientAnchor = new HSSFClientAnchor(0, 0, 0, 0, (short)n4, n5, (short)n7, n8);
            HSSFComment hSSFComment = hSSFPatriarch.createComment((HSSFAnchor)hSSFClientAnchor);
            hSSFComment.setString(new HSSFRichTextString(string));
            hSSFComment.setAuthor("FineReport");
            hSSFCell.setCellComment(hSSFComment);
        }
        hSSFCell.setEncoding((short)1);
        return hSSFCell;
    }

    protected void dealWithPageSetting(Report report, HSSFSheet hSSFSheet, int n2) {
        POIHeaderFooterAction pOIHeaderFooterAction;
        ReportSettingsProvider reportSettingsProvider = ReportUtils.getReportSettings(report);
        PaperSettingWrapper paperSettingWrapper = new PaperSettingWrapper(this.paperSettingList, n2, reportSettingsProvider);
        HssfSheetWrapper hssfSheetWrapper = new HssfSheetWrapper(hSSFSheet);
        this.dealWithAlignAndMargin(hssfSheetWrapper, reportSettingsProvider, paperSettingWrapper.getMargin());
        HssfPrintSetupWrapper1 hssfPrintSetupWrapper1 = new HssfPrintSetupWrapper1(hSSFSheet.getPrintSetup());
        this.dealWithPrintSetUp(hssfPrintSetupWrapper1, paperSettingWrapper.getPaperSize(), paperSettingWrapper.getOrientation(), reportSettingsProvider);
        if (reportSettingsProvider.getHeaderHeight().more_than_zero()) {
            pOIHeaderFooterAction = new HssfHeaderWrapper(hSSFSheet.getHeader());
            this.applyReportHFHeader(report.getHeader(0), pOIHeaderFooterAction);
        }
        if (reportSettingsProvider.getFooterHeight().more_than_zero()) {
            pOIHeaderFooterAction = new HssfFooterWrapper(hSSFSheet.getFooter());
            this.applyReportHFFooter(report.getFooter(0), pOIHeaderFooterAction);
        }
    }

    private void dealWithFloatElement(ElementCase elementCase, HSSFPatriarch hSSFPatriarch, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        Iterator iterator = elementCase.floatIterator();
        while (iterator.hasNext()) {
            BufferedImage bufferedImage;
            FloatElement floatElement = (FloatElement)iterator.next();
            Object object = floatElement.getValue();
            POIPictureLocation pOIPictureLocation = this.locateFloatElementInExcel(floatElement, dynamicUnitList, dynamicUnitList2, elementCase, object);
            HSSFClientAnchor hSSFClientAnchor = new HSSFClientAnchor(pOIPictureLocation.getFirst_cell_x(), pOIPictureLocation.getFirst_cell_y(), pOIPictureLocation.getSecond_cell_x(), pOIPictureLocation.getSecond_cell_y(), pOIPictureLocation.getFirst_cell_col(), pOIPictureLocation.getFirst_cell_row(), pOIPictureLocation.getSecond_cell_col(), pOIPictureLocation.getSecond_cell_row());
            Style style = floatElement.getStyle();
            if (style == null) {
                style = Style.DEFAULT_STYLE;
            }
            int n4 = floatElement.getWidth().toPixI(96);
            int n5 = floatElement.getHeight().toPixI(96);
            if (object instanceof Formula) {
                object = ((Formula)object).getResult();
            }
            if (object instanceof ShapePainter) {
                this.dealWithShapePainter(object, hSSFPatriarch, hSSFClientAnchor, hSSFSheet, hSSFWorkbook, style);
                continue;
            }
            if (object instanceof Image) {
                bufferedImage = GraphHelper.createBufferedImageFromImageWithLayout((Image)((Image)object), (int)n4, (int)n5, (Style)style);
                this.dealWithBufferImage(object, hSSFClientAnchor, hSSFPatriarch, hSSFWorkbook, style, n4, n5, bufferedImage);
                continue;
            }
            if (object instanceof BaseChartPainter) {
                bufferedImage = CoreGraphHelper.createBufferedImage((int)n4, (int)n5, (int)6);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                Style.paintBackground((Graphics2D)graphics2D, (Style)style, (double)n4, (double)n5);
                ((BaseChartPainter)object).paint((Graphics)graphics2D, n4, n5, 96, style);
                Style.paintBorder((Graphics2D)graphics2D, (Style)style, (double)n4, (double)n5);
                graphics2D.dispose();
                this.dealWithBufferImage(object, hSSFClientAnchor, hSSFPatriarch, hSSFWorkbook, style, n4, n5, bufferedImage);
                continue;
            }
            this.dealWithTextBox(object, hSSFPatriarch, hSSFClientAnchor, hSSFWorkbook, style);
        }
    }

    @Override
    protected int getFloatLeftMax(double d2) {
        return 1023;
    }

    @Override
    protected int getFloatTopMax(double d2) {
        return 255;
    }

    private void dealWithBufferImage(Object object, HSSFClientAnchor hSSFClientAnchor, HSSFPatriarch hSSFPatriarch, HSSFWorkbook hSSFWorkbook, Style style, int n2, int n3, BufferedImage bufferedImage) {
        this.dealWithBufferImage(object, new HssfClientAnchorWrapper(hSSFClientAnchor), new HssfPatriarchWrapper(hSSFPatriarch), style, n2, n3, bufferedImage, new HssfWorkbookWrapper(hSSFWorkbook));
    }

    private void dealWithTextBox(Object object, HSSFPatriarch hSSFPatriarch, HSSFClientAnchor hSSFClientAnchor, HSSFWorkbook hSSFWorkbook, Style style) {
        String string = Utils.objectToString((Object)object);
        HSSFTextbox hSSFTextbox = hSSFPatriarch.createTextbox(hSSFClientAnchor);
        Color color = Color.white;
        Background background = style.getBackground();
        if (background != null && background instanceof ColorBackground) {
            color = ((ColorBackground)background).getColor();
        }
        if (color != null) {
            hSSFTextbox.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        hSSFTextbox.setLineStyle(style.getBorderLeftWidth());
        hSSFTextbox.setVerticalAlignment(this.changeAlignment(style.getVerticalAlignment()));
        hSSFTextbox.setHorizontalAlignment(this.changeAlignment(style.getHorizontalAlignment()));
        HSSFRichTextString hSSFRichTextString = new HSSFRichTextString(string);
        hSSFRichTextString.applyFont(this.createFont(hSSFWorkbook, (Font)style.getFRFont()));
        hSSFTextbox.setString(hSSFRichTextString);
    }

    private void dealWithShapePainter(Object object, HSSFPatriarch hSSFPatriarch, HSSFClientAnchor hSSFClientAnchor, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, Style style) {
        ShapePainter shapePainter = (ShapePainter)object;
        HSSFShapeGroup hSSFShapeGroup = hSSFPatriarch.createGroup(hSSFClientAnchor);
        float f2 = hSSFClientAnchor.getAnchorHeightInPoints(hSSFSheet) / (float)Math.abs(hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
        EscherGraphics escherGraphics = new EscherGraphics(hSSFShapeGroup, hSSFWorkbook, Color.black, f2);
        EscherGraphics2d escherGraphics2d = new EscherGraphics2d(escherGraphics);
        escherGraphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (shapePainter instanceof LineShapePainter) {
            LineShapePainter lineShapePainter = (LineShapePainter)shapePainter;
            escherGraphics2d.setPaint((Paint)style.getFRFont().getForeground());
            if (lineShapePainter.isPositiveArrow()) {
                escherGraphics2d.drawLine(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2(), hSSFShapeGroup.getX2(), hSSFShapeGroup.getY1());
            } else {
                escherGraphics2d.drawLine(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2(), hSSFShapeGroup.getY2());
            }
        } else if (shapePainter instanceof OvalShapePainter) {
            this.applyBackgroundToGraphic2d(escherGraphics2d, style.getBackground());
            escherGraphics2d.fillOval(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
            escherGraphics2d.setPaint((Paint)style.getFRFont().getForeground());
            escherGraphics2d.drawOval(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
        } else {
            this.applyBackgroundToGraphic2d(escherGraphics2d, style.getBackground());
            escherGraphics2d.fillRect(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
            escherGraphics2d.setPaint((Paint)style.getFRFont().getForeground());
            escherGraphics2d.drawRect(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
        }
        escherGraphics2d.dispose();
    }

    private short changeAlignment(int n2) {
        if (n2 == 0) {
            return 2;
        }
        if (n2 == 3 || n2 == 4) {
            return 3;
        }
        return 1;
    }

    private void dealWithValue(CellElement cellElement, List list, HSSFCell hSSFCell, ExcelExportAttr excelExportAttr, Calculator calculator, List list2, CellGUIAttr cellGUIAttr, HSSFWorkbook hSSFWorkbook, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, int n4, int n5, HSSFPatriarch hSSFPatriarch) {
        Style style = cellElement.getStyle();
        boolean bl = excelExportAttr.isExportHidedRow();
        boolean bl2 = excelExportAttr.isExportHidedColumn();
        Object object = this.evalCellValue(cellElement, bl, bl2, list, new HssfCellWrapper(hSSFCell), calculator, style, list2, cellGUIAttr, dynamicUnitList, dynamicUnitList2, n2, n3, n4, n5, new HssfWorkbookWrapper(hSSFWorkbook));
        Format format = style.getFormat();
        HSSFCellStyle hSSFCellStyle = this.createHSSFCellStyle(hSSFWorkbook, style);
        if ((object = this.checkNumberFormat(format, object)) instanceof Formula) {
            this.dealDateFormula(hSSFCell, object, hSSFWorkbook, hSSFCellStyle, style);
        } else if (object instanceof Number) {
            this.dealWithNumberValue(object, hSSFCell);
        } else if (object instanceof Boolean) {
            hSSFCell.setCellType(4);
            hSSFCell.setCellValue(((Boolean)object).booleanValue());
        } else if (object instanceof Painter || object instanceof Image) {
            this.dealWithImageValue(object, n2, n3, n4, n5, dynamicUnitList, dynamicUnitList2, style, hSSFPatriarch, hSSFWorkbook);
        } else if (object instanceof HSSFRichTextString) {
            hSSFCell.setCellType(1);
            hSSFCell.setCellValue((HSSFRichTextString)object);
        } else if (object instanceof Date) {
            this.dealWithDateValue(object, hSSFCell, style, hSSFWorkbook);
        } else {
            this.dealWithOtherValue(object, dynamicUnitList, dynamicUnitList2, format, bl, bl2, hSSFCell, list, calculator, list2);
        }
        if (hSSFCell.getCellType() == 1 && hSSFCell.getStringCellValue().startsWith("--")) {
            style.deriveFormat((Format)TextFormat.getInstance());
        }
        if (!cellGUIAttr.isPrintBackground()) {
            Style style2 = style.deriveBackground(null);
            hSSFCell.setCellStyle(this.createHSSFCellStyle(hSSFWorkbook, style2));
        } else if (!(object instanceof Date) && !(object instanceof Formula)) {
            hSSFCell.setCellStyle(hSSFCellStyle);
        }
    }

    @Override
    protected Object evalFormulaValue(Object object, boolean bl, boolean bl2, List list, POICellAction pOICellAction, Calculator calculator, List list2) {
        return this.dealWithFormulaValue(object, bl, bl2, list, (HSSFCell)pOICellAction.getCell(), calculator, list2);
    }

    private Object dealWithFormulaValue(Object object, boolean bl, boolean bl2, List list, HSSFCell hSSFCell, Calculator calculator, List list2) {
        Formula formula = (Formula)object;
        if (formula.isReserveInResult() && formula instanceof ResultFormula) {
            String string = formula.getContent();
            boolean bl3 = !bl || !bl2;
            if ((string = this.dealWithSumFormula(string, object, formula, bl3)) != null) {
                if (string.startsWith("=")) {
                    string = string.substring(1);
                }
                list.add(hSSFCell);
                if (bl3 && StringUtils.isNotBlank((String)string)) {
                    try {
                        String string2 = calculator.exStatement(null, string);
                        list2.add(string2 == null ? FORMULA_ERROR : string2);
                    }
                    catch (Exception exception) {
                        list2.add(FORMULA_ERROR);
                    }
                } else {
                    list2.add(string);
                }
            }
        } else {
            object = formula.getResult();
        }
        return object;
    }

    private void dealWithImageValue(Object object, int n2, int n3, int n4, int n5, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, Style style, HSSFPatriarch hSSFPatriarch, HSSFWorkbook hSSFWorkbook) {
        HSSFClientAnchor hSSFClientAnchor = new HSSFClientAnchor(0, 0, 0, 0, (short)n2, n3, (short)(n2 + n4), n3 + n5);
        if (object != null) {
            hSSFClientAnchor.setAnchorType(2);
            if (object instanceof BufferedImage && style.getImageLayout() == 2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)((BufferedImage)object), "png", byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    int n6 = hSSFWorkbook.addPicture(byteArrayOutputStream.toByteArray(), 6);
                    hSSFPatriarch.createPicture(hSSFClientAnchor, n6);
                }
                catch (IOException iOException) {
                    FRContext.getLogger().error(iOException.getMessage());
                }
                return;
            }
            int n7 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
            int n8 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)(n7 + 1), (int)(n8 + 1), (int)2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(style.getBorderLeftWidth(), style.getBorderTopWidth());
            Style.paintContent((Graphics2D)graphics2D, (Object)object, (Style)style, (int)(n7 - style.getBorderLeftWidth()), (int)(n8 - style.getBorderTopWidth()), (int)96);
            bufferedImage.flush();
            graphics2D.dispose();
            try {
                int n9 = this.loadPicture(bufferedImage, new HssfWorkbookWrapper(hSSFWorkbook));
                hSSFPatriarch.createPicture(hSSFClientAnchor, n9);
            }
            catch (IOException iOException) {
                FRContext.getLogger().error(iOException.getMessage());
            }
        }
    }

    private void dealWithOtherValue(Object object, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, Format format, boolean bl, boolean bl2, HSSFCell hSSFCell, List list, Calculator calculator, List list2) {
        String string = Style.valueToText((Object)object, (Format)format);
        if (string != null) {
            if (string.startsWith("=")) {
                String string2 = string.substring(1);
                list.add(hSSFCell);
                if (!(bl && bl2 || !StringUtils.isNotBlank((String)string2))) {
                    try {
                        String string3 = calculator.exStatement(null, string2);
                        list2.add(string3 == null ? FORMULA_ERROR : string3);
                    }
                    catch (Exception exception) {
                        list2.add(FORMULA_ERROR);
                    }
                } else {
                    list2.add(string2);
                }
            } else if (string.length() > 0) {
                string = this.replaceNewLineChar(string);
                if (format instanceof NumberFormat) {
                    try {
                        hSSFCell.setCellValue(Double.parseDouble(string));
                        hSSFCell.setCellType(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        hSSFCell.setCellType(1);
                        hSSFCell.setCellValue(string);
                    }
                } else {
                    hSSFCell.setCellType(1);
                    hSSFCell.setCellValue(string);
                }
            }
        }
    }

    private void dealWithNumberValue(Object object, HSSFCell hSSFCell) {
        String string = StableUtils.checkInfinity((Object)object);
        if (StringUtils.isNotEmpty((String)string)) {
            hSSFCell.setCellType(1);
            hSSFCell.setCellValue(string);
        } else {
            hSSFCell.setCellType(0);
            hSSFCell.setCellValue(((Number)object).doubleValue());
        }
    }

    private void dealWithDateValue(Object object, HSSFCell hSSFCell, Style style, HSSFWorkbook hSSFWorkbook) {
        hSSFCell.setCellValue((Date)object);
        Format format = style.getFormat();
        if (format == null) {
            format = object instanceof Time ? DateUtils.TIMEFORMAT : DateUtils.DATETIMEFORMAT2;
        }
        HSSFCellStyle hSSFCellStyle = this.createHSSFCellStyle(hSSFWorkbook, style.deriveFormat(format));
        hSSFCell.setCellStyle(hSSFCellStyle);
    }

    private void executeHSSFCellStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, Style style) {
        this.executeCellStyle(new HssfWorkbookWrapper(hSSFWorkbook), new HssfCellStyleWrapper(hSSFCellStyle), style);
        hSSFCellStyle.setTopBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderTopColor()));
        hSSFCellStyle.setLeftBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderLeftColor()));
        hSSFCellStyle.setBottomBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderBottomColor()));
        hSSFCellStyle.setRightBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderRightColor()));
        Background background = style.getBackground();
        if (background != null) {
            if (background instanceof ColorBackground) {
                ColorBackground colorBackground = (ColorBackground)background;
                if (colorBackground.getColor() == null) {
                    colorBackground = ColorBackground.getInstance((Color)Color.WHITE);
                }
                hSSFCellStyle.setFillPattern((short)1);
                hSSFCellStyle.setFillForegroundColor(this.getNearestColor(hSSFWorkbook, colorBackground.getColor()));
                hSSFCellStyle.setFillBackgroundColor(this.getNearestColor(hSSFWorkbook, colorBackground.getColor()));
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                hSSFCellStyle.setFillPattern((short)16);
                hSSFCellStyle.setFillBackgroundColor(this.getNearestColor(hSSFWorkbook, patternBackground.getBackground()));
                hSSFCellStyle.setFillForegroundColor(this.getNearestColor(hSSFWorkbook, patternBackground.getForeground()));
            } else {
                FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine-NS_export_excelCellBg"));
            }
        }
    }

    private void dealDateFormula(HSSFCell hSSFCell, Object object, HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, Style style) {
        hSSFCell.setCellType(2);
        String string = ((Formula)object).getContent();
        if (string.equalsIgnoreCase("=now()")) {
            hSSFCell.setCellFormula("now()");
            HSSFCellStyle hSSFCellStyle2 = this.createHSSFCellStyle(hSSFWorkbook, style.deriveFormat((Format)DateUtils.DATETIMEFORMAT2));
            hSSFCell.setCellStyle(hSSFCellStyle2);
        } else if (string.equalsIgnoreCase("=today()")) {
            hSSFCell.setCellFormula("today()");
            HSSFCellStyle hSSFCellStyle3 = this.createHSSFCellStyle(hSSFWorkbook, style.deriveFormat((Format)DateUtils.DATEFORMAT2));
            hSSFCell.setCellStyle(hSSFCellStyle3);
        } else {
            hSSFCell.setCellStyle(hSSFCellStyle);
        }
    }

    private short getNearestColor(HSSFWorkbook hSSFWorkbook, Color color) {
        HSSFPalette hSSFPalette;
        HSSFColor hSSFColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if ((hSSFColor = (hSSFPalette = hSSFWorkbook.getCustomPalette()).findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue())) == null || hSSFColor.getIndex() > this.colorIndex) {
            this.colorIndex = (short)(this.colorIndex + 1);
            hSSFPalette.setColorAtIndex(this.colorIndex, (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            hSSFColor = hSSFPalette.findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        return hSSFColor.getIndex();
    }

    private HSSFCellStyle createHSSFCellStyle(HSSFWorkbook hSSFWorkbook, Style style) {
        if (style == null) {
            if (this.defaultHSSFCellStyle == null) {
                this.defaultHSSFCellStyle = hSSFWorkbook.createCellStyle();
                this.executeHSSFCellStyle(hSSFWorkbook, this.defaultHSSFCellStyle, Style.DEFAULT_STYLE);
            }
            return this.defaultHSSFCellStyle;
        }
        HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)this.hssfCellStyleHash.get(style = this.adjustProperFontSize(style));
        if (hSSFCellStyle == null) {
            hSSFCellStyle = hSSFWorkbook.createCellStyle();
            this.executeHSSFCellStyle(hSSFWorkbook, hSSFCellStyle, style);
            this.hssfCellStyleHash.put(style, hSSFCellStyle);
        }
        if (style.getHorizontalAlignment() == 4) {
            int n2 = style.getPaddingRight() <= 2 ? 0 : style.getPaddingRight() / 27;
            hSSFCellStyle.setIndention((short)n2);
        } else {
            int n3 = style.getPaddingLeft() <= 2 ? 0 : style.getPaddingLeft() / 27;
            hSSFCellStyle.setIndention((short)n3);
        }
        return hSSFCellStyle;
    }

    @Override
    protected short getRotation(Style style) {
        int n2 = style.getRotation();
        if (n2 > V_ROTATION || n2 < -V_ROTATION) {
            n2 = 0;
        }
        return (short)n2;
    }

    @Override
    protected POIFontAction createFont(POIWorkbookAction pOIWorkbookAction, Font font) {
        return new HssfFontWrapper(this.createFont((HSSFWorkbook)pOIWorkbookAction.getWorkbook(), font));
    }

    private HSSFFont createFont(HSSFWorkbook hSSFWorkbook, Font font) {
        if (font == null) {
            return null;
        }
        HSSFFont hSSFFont = this.createSimpleHSSFFont(hSSFWorkbook, new AbstractExcelExporter.JavaFontAdapter(font), font.getName());
        if (font instanceof FRFont) {
            FRFont fRFont = (FRFont)font;
            Color color = fRFont.getForeground();
            hSSFFont.setColor(this.getNearestColor(hSSFWorkbook, color));
            this.createComplexFont4FR(fRFont, new HssfFontWrapper(hSSFFont));
        }
        return hSSFFont;
    }

    private HSSFDataFormat getHSSFDataFormat(HSSFWorkbook hSSFWorkbook) {
        return this.format == null ? hSSFWorkbook.createDataFormat() : this.format;
    }

    @Override
    protected short getFormat(POIWorkbookAction pOIWorkbookAction, String string) {
        return this.getHSSFDataFormat((HSSFWorkbook)pOIWorkbookAction.getWorkbook()).getFormat(string);
    }

    private void applyBackgroundToGraphic2d(EscherGraphics2d escherGraphics2d, Background background) {
        if (background == null) {
            escherGraphics2d.setPaint(null);
        } else if (background instanceof ColorBackground) {
            ColorBackground colorBackground = (ColorBackground)background;
            escherGraphics2d.setPaint((Paint)colorBackground.getColor());
        } else {
            escherGraphics2d.setPaint((Paint)Color.white);
        }
    }

    @Override
    protected POIRichStringAction<HSSFRichTextString> initRichString(String string) {
        return new HssfRichStringWrapper(new HSSFRichTextString(string));
    }

    private HSSFFont createSimpleHSSFFont(HSSFWorkbook hSSFWorkbook, AbstractExcelExporter.FontAdapter fontAdapter, String string) {
        return (HSSFFont)this.createSimpleFont(new HssfWorkbookWrapper(hSSFWorkbook), fontAdapter, new HssfFontWrapper(), string).getFont();
    }
}

