/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container.cardlayout;

import com.fr.form.ui.LayoutBorderStyle;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetTitle;
import com.fr.form.ui.container.WBorderLayout;
import com.fr.form.ui.container.WCardLayout;
import com.fr.form.ui.container.cardlayout.ButtonNameWrapper;
import com.fr.form.ui.container.cardlayout.WCardTagLayout;
import com.fr.form.ui.container.cardlayout.WCardTitleLayout;
import com.fr.form.ui.container.cardlayout.WTabFitLayout;
import com.fr.general.Background;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;

public class WCardMainBorderLayout
extends WBorderLayout {
    public static final int TAB_HEIGHT = 36;
    private boolean WEB_WIDGET_INITIALIZED = false;

    public WCardMainBorderLayout() {
        this.setNorthSize(36);
        this.clearMargin();
    }

    public WCardTitleLayout getTitlePart() {
        return (WCardTitleLayout)this.getLayoutWidget("North");
    }

    public WCardLayout getCardPart() {
        return (WCardLayout)this.getLayoutWidget("Center");
    }

    public String getXType() {
        return "cardborder";
    }

    public int getNorthSize() {
        return 36;
    }

    public String getNorthTitle() {
        return "";
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        this.prepareChildStyle();
        if (repository.getDevice().isMobile()) {
            return this.createMobileJSONConfig(repository, calculator, nodeVisitor);
        }
        return super.createJSONConfig(repository, calculator, nodeVisitor);
    }

    private JSONObject createMobileJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", (Object)this.getXType());
        if (this.widgetName != null) {
            jSONObject.put("widgetName", (Object)this.widgetName.toUpperCase());
        }
        if (this.background != null) {
            jSONObject.put("widgetBackground", (Object)this.background.toJSONObject());
        }
        if (this.borderStyle != null) {
            this.borderStyle.createJSONConfig(repository, jSONObject);
        }
        if (this.getTitlePart() != null && this.getCardPart() != null) {
            WCardTitleLayout wCardTitleLayout = this.getTitlePart();
            WCardTagLayout wCardTagLayout = wCardTitleLayout.getTagPart();
            WCardLayout wCardLayout = this.getCardPart();
            if (wCardTagLayout != null) {
                int n2;
                int n3 = wCardTagLayout.getWidgetCount();
                if (n3 == (n2 = wCardLayout.getWidgetCount())) {
                    JSONObject jSONObject2;
                    JSONArray jSONArray = JSONArray.create();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        jSONObject2 = wCardTagLayout.getSwitchButton(i2).createJSONConfig(repository, calculator, nodeVisitor);
                        JSONObject jSONObject3 = wCardLayout.getWidget(i2).createJSONConfig(repository, calculator, nodeVisitor);
                        JSONObject jSONObject4 = JSONObject.create();
                        jSONObject4.put("tag", (Object)jSONObject2);
                        jSONObject4.put("content", (Object)jSONObject3);
                        jSONArray.put((Object)jSONObject4);
                    }
                    JSONObject jSONObject5 = wCardTitleLayout.createJSONConfig(repository, calculator, nodeVisitor);
                    jSONObject.put("title", (Object)jSONObject5);
                    jSONObject.put("item", (Object)jSONArray);
                    jSONObject2 = wCardLayout.createJSONListener(repository);
                    if (jSONObject2.length() > 0) {
                        jSONObject.put("listeners", (Object)jSONObject2);
                    }
                } else {
                    FRLogger.getLogger().error("error!numbers of cards and cardTags isn't equal.");
                }
            } else {
                FRLogger.getLogger().error("CardTagLayout null.");
            }
        } else {
            FRLogger.getLogger().error("titleLayout or cardLayout null.");
        }
        return jSONObject;
    }

    private void prepareChildStyle() {
        if (this.WEB_WIDGET_INITIALIZED) {
            return;
        }
        WCardLayout wCardLayout = this.getCardPart();
        LayoutBorderStyle layoutBorderStyle = wCardLayout.getBorderStyle();
        this.setBorderStyle(layoutBorderStyle);
        wCardLayout.setBorderStyle(new LayoutBorderStyle());
        int n2 = layoutBorderStyle.getType();
        if (n2 == 1) {
            this.prepareTitleConfig(layoutBorderStyle, wCardLayout);
        } else {
            this.removeAll();
            this.addCenter((Widget)wCardLayout);
        }
        this.WEB_WIDGET_INITIALIZED = true;
    }

    private void prepareTitleConfig(LayoutBorderStyle layoutBorderStyle, WCardLayout wCardLayout) {
        WidgetTitle widgetTitle = layoutBorderStyle.getTitle();
        Background background = widgetTitle.getBackground();
        WCardTitleLayout wCardTitleLayout = this.getTitlePart();
        wCardTitleLayout.setBackground(background);
        WCardTagLayout wCardTagLayout = wCardTitleLayout.getTagPart();
        wCardTagLayout.setBackground(background);
        wCardTagLayout.setTitleFont(widgetTitle.getFrFont());
        ButtonNameWrapper buttonNameWrapper = this.getAllTagName();
        wCardLayout.setBtnsName(buttonNameWrapper);
    }

    private ButtonNameWrapper getAllTagName() {
        ButtonNameWrapper buttonNameWrapper = new ButtonNameWrapper();
        WCardTitleLayout wCardTitleLayout = this.getTitlePart();
        String string = wCardTitleLayout.getPreBtnName();
        String string2 = wCardTitleLayout.getNextBtnName();
        WCardTagLayout wCardTagLayout = wCardTitleLayout.getTagPart();
        wCardTagLayout.adjustPreferWidth();
        int n2 = 0;
        int n3 = wCardTagLayout.getWidgetCount();
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            Widget widget = wCardTagLayout.getWidget(i2);
            stringArray[i2] = widget.getWidgetName();
            n2 += wCardTagLayout.getWidthAtWidget(widget);
        }
        buttonNameWrapper.setAllTagName(stringArray);
        buttonNameWrapper.setPreBtnName(string);
        buttonNameWrapper.setNextBtnName(string2);
        buttonNameWrapper.setTitleWidth(n2);
        buttonNameWrapper.setTagLayoutName(wCardTagLayout.getWidgetName());
        return buttonNameWrapper;
    }

    public void resize(double d2, double d3, double d4) {
        WCardLayout wCardLayout = this.getCardPart();
        double d5 = this.getTitlePart() == null ? d3 : d3 - 36.0;
        wCardLayout.resize(d2, d5, d4);
    }

    public void dealInvisible() throws Exception {
        WCardLayout wCardLayout = this.getCardPart();
        int n2 = wCardLayout.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            WTabFitLayout wTabFitLayout = (WTabFitLayout)wCardLayout.getWidget(i2);
            wTabFitLayout.dealInvisible();
        }
    }
}

