/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.main.Form;
import com.fr.form.main.WidgetGatherAdapter;
import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WLayout;
import com.fr.form.ui.container.WScaleLayout;
import com.fr.form.ui.widget.CRBoundsWidget;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSortLayout
extends WLayout {
    private List<String> mobileWidgetList = new ArrayList<String>();
    private boolean sorted = false;

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    @Override
    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("itemsIndex", (Object)this.createItemIndexList());
        return jSONObject;
    }

    public JSONArray createItemIndexList() {
        JSONArray jSONArray = new JSONArray();
        this.mobileWidgetList = this.getOrderedMobileWidgetList();
        int n2 = this.mobileWidgetList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            jSONArray.put((Object)this.mobileWidgetList.get(i2).toUpperCase());
        }
        return jSONArray;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        String string = xMLableReader.getTagName();
        if ("Sorted".equals(string)) {
            this.setSorted(xMLableReader.getAttrAsBoolean("sorted", false));
        } else if (string.equals("MobileWidgetList")) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if ("Widget".equals(xMLableReader.getTagName())) {
                        WSortLayout.this.addToMobileList(xMLableReader.getAttrAsString("widgetName", ""));
                    }
                }
            });
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Sorted").attr("sorted", this.isSorted()).end();
        xMLPrintWriter.startTAG("MobileWidgetList");
        int n2 = this.mobileWidgetList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("Widget").attr("widgetName", this.mobileWidgetList.get(i2)).end();
        }
        xMLPrintWriter.end();
    }

    private ArrayList<String> traverseWidgetName() {
        final ArrayList<String> arrayList = new ArrayList<String>();
        Form.traversalWidget((Widget)this, new WidgetGatherAdapter(){

            public void dealWith(Widget widget) {
                if (widget.getWidgetName() != "body") {
                    arrayList.add(widget.getWidgetName());
                }
            }
        }, Widget.class);
        return arrayList;
    }

    public List<String> getOrderedMobileWidgetList() {
        Cloneable cloneable;
        HashMap<Double, HashMap<Double, String>> hashMap = new HashMap<Double, HashMap<Double, String>>();
        int n2 = this.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            CRBoundsWidget cRBoundsWidget = (CRBoundsWidget)this.getWidget(i2);
            if (cRBoundsWidget == null) continue;
            if (cRBoundsWidget.getWidget().acceptType(new Class[]{WScaleLayout.class})) {
                cloneable = cRBoundsWidget.getBounds();
                cRBoundsWidget = (CRBoundsWidget)((WScaleLayout)cRBoundsWidget.getWidget()).getBoundsWidget();
                this.initXYMap(cRBoundsWidget, (Rectangle)cloneable, hashMap);
                continue;
            }
            this.initXYMap(cRBoundsWidget, cRBoundsWidget.getBounds(), hashMap);
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Arrays.sort(objectArray);
        if (!this.isSorted()) {
            this.mobileWidgetList.clear();
        }
        int n3 = objectArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            cloneable = (HashMap)hashMap.get(objectArray[n2]);
            Object[] objectArray2 = ((HashMap)cloneable).keySet().toArray();
            Arrays.sort(objectArray2);
            int n4 = objectArray2.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                String string = (String)((HashMap)cloneable).get(objectArray2[i3]);
                this.addToMobileList(string);
            }
        }
        Iterator<String> iterator = this.getMobileWidgetIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.traverseWidgetName().contains(string)) continue;
            iterator.remove();
        }
        return this.mobileWidgetList;
    }

    public void addToMobileList(String string) {
        this.addToMobileList(-1, string);
    }

    public void addToMobileList(int n2, String string) {
        if (!this.traverseWidgetName().contains(string)) {
            return;
        }
        if (this.mobileWidgetList.contains(string)) {
            return;
        }
        if (n2 == -1) {
            this.mobileWidgetList.add(string);
        } else if (n2 > this.mobileWidgetList.size()) {
            this.mobileWidgetList.add(this.mobileWidgetList.size(), string);
        } else {
            this.mobileWidgetList.add(n2, string);
        }
    }

    public void adjustOrder(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = this.mobileWidgetList.size();
        if (n2 > n4) {
            return;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        String string = this.mobileWidgetList.get(n2);
        this.mobileWidgetList.remove(n2);
        if (n2 < n3) {
            --n3;
        }
        this.addToMobileList(n3, string);
        this.setSorted(true);
    }

    private void initXYMap(CRBoundsWidget cRBoundsWidget, Rectangle rectangle, HashMap<Double, HashMap<Double, String>> hashMap) {
        HashMap<Double, String> hashMap2 = hashMap.get(rectangle.getY());
        if (hashMap2 != null) {
            hashMap2.put(rectangle.getX(), cRBoundsWidget.getWidget().getWidgetName());
            return;
        }
        hashMap2 = new HashMap();
        hashMap2.put(rectangle.getX(), cRBoundsWidget.getWidget().getWidgetName());
        hashMap.put(rectangle.getY(), hashMap2);
    }

    public Iterator<String> getMobileWidgetIterator() {
        return this.mobileWidgetList.iterator();
    }

    public int getMobileWidgetListSize() {
        return this.mobileWidgetList.size();
    }

    public String getMobileWidget(int n2) {
        if (n2 > -1 && n2 < this.mobileWidgetList.size()) {
            return this.mobileWidgetList.get(n2);
        }
        return null;
    }

    public void addMobileWidget(String string) {
        this.mobileWidgetList.add(string);
    }

    public void addMobileWidget(int n2, String string) {
        this.mobileWidgetList.add(n2, string);
    }

    public void removeMobileWidget(int n2) {
        this.mobileWidgetList.remove(n2);
    }

    public void clearMobileWidgetList() {
        this.mobileWidgetList.clear();
    }

    public boolean isContainsMoibleWidget(String string) {
        return this.mobileWidgetList.contains(string);
    }
}

