/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.container.WLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class WGridLayout
extends WLayout {
    private int cols;
    private int rows;
    private Map map;

    public WGridLayout() {
        this(1, 1, 0, 0);
    }

    public WGridLayout(int n2, int n3, int n4, int n5) {
        this.setRows(n2);
        this.setColumns(n3);
        this.setHgap(n4);
        this.setVgap(n5);
        this.map = new HashMap();
    }

    public void addWidget(Widget widget) {
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int i3 = 0; i3 < this.cols; ++i3) {
                Point point = new Point(i3, i2);
                if (this.map.get(point) != null) continue;
                this.addWidget(widget, point);
                return;
            }
        }
    }

    public void addWidget(Widget widget, int n2, int n3) {
        this.addWidget(widget, new Point(n2, n3));
    }

    public void addWidget(Widget widget, Point point) {
        super.addWidget(widget);
        this.map.put(point, widget);
    }

    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        for (Point point : this.map.keySet()) {
            if (!ComparatorUtils.equals(this.map.get(point), (Object)widget)) continue;
            this.map.remove(point);
            return;
        }
    }

    public String getLayoutToolTip() {
        return Inter.getLocText((String)"WLayout-Grid-ToolTips");
    }

    public void removeAll() {
        super.removeAll();
        this.map.clear();
    }

    public Dimension getMinDesignSize() {
        return new Dimension();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public Widget getWidget(Point point) {
        Object v2 = this.map.get(point);
        return v2 == null ? null : (Widget)v2;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n2) {
        this.rows = n2 == 0 ? 1 : n2;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int n2) {
        this.cols = n2 == 0 ? 1 : n2;
    }

    public String getXType() {
        return "grid";
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("columns", this.cols);
        jSONObject.put("rows", this.rows);
        return jSONObject;
    }

    protected JSONArray createJSONItems(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Point point : this.map.keySet()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("column", point.x);
            jSONObject.put("row", point.y);
            jSONObject.put("el", (Object)((Widget)this.map.get(point)).createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.map.clear();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("GLAttr")) {
                this.rows = xMLableReader.getAttrAsInt("rows", 1);
                this.cols = xMLableReader.getAttrAsInt("cols", 1);
            } else if (string.equals("WMap")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Widget")) {
                            Point point = new Point(xMLableReader.getAttrAsInt("col", 0), xMLableReader.getAttrAsInt("row", 0));
                            Widget widget = WidgetXmlUtils.readWidget((XMLableReader)xMLableReader);
                            WGridLayout.this.map.put(point, widget);
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("GLAttr").attr("rows", this.rows).attr("cols", this.cols).end();
        xMLPrintWriter.startTAG("WMap");
        for (Point point : this.map.keySet()) {
            WidgetXmlUtils.writeXMLWidget((XMLPrintWriter)xMLPrintWriter, (Widget)((Widget)this.map.get(point)), (Point)point);
        }
        xMLPrintWriter.end();
    }
}

